/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.openconcerto.erp.modules.AvailableModulesPanel;
import org.openconcerto.erp.modules.ModuleFrame;
import org.openconcerto.erp.modules.ModuleManager;
import org.openconcerto.erp.modules.ModuleReference;
import org.openconcerto.erp.modules.ModuleTableModel;
import org.openconcerto.erp.modules.ModulesStateChange;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FontUtils;
import org.openconcerto.ui.table.AlternateTableCellRenderer;
import org.openconcerto.ui.table.TableCellRendererDecorator;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.JImage;

public class ModulePanel
extends JPanel {
    private final ModuleTableModel tm;

    ModulePanel(ModuleFrame moduleFrame, final boolean onlyInstall) {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.tm = new ModuleTableModel();
        JTable t = new JTable(this.tm){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                Container viewPort = SwingUtilities.getAncestorOfClass(JViewport.class, this);
                return viewPort.getSize().width >= this.getMinimumSize().width;
            }
        };
        t.setAutoCreateRowSorter(true);
        t.setShowGrid(false);
        t.setShowVerticalLines(false);
        t.setFocusable(false);
        t.setRowSelectionAllowed(false);
        t.setColumnSelectionAllowed(false);
        t.setCellSelectionEnabled(false);
        t.setRowHeight(FontUtils.getPreferredRowHeight(t));
        TableColumnModel columnModel = t.getColumnModel();
        TableCellRenderer headerDefaultRenderer = t.getTableHeader().getDefaultRenderer();
        EnumSet<ModuleTableModel.Columns> booleanCols = EnumSet.of(ModuleTableModel.Columns.LOCAL, ModuleTableModel.Columns.REMOTE, ModuleTableModel.Columns.DB_REQUIRED, ModuleTableModel.Columns.ADMIN_REQUIRED);
        final JImage trueComp = new JImage(TableCellRendererDecorator.TableCellRendererDecoratorUtils.class.getResource("okay.png"));
        trueComp.setBackground(Color.WHITE);
        trueComp.setCenterImage(true);
        final JPanel falseComp = new JPanel();
        falseComp.setBackground(Color.WHITE);
        TableCellRenderer booleanRenderer = new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return (Boolean)value != false ? trueComp : falseComp;
            }
        };
        int i = 0;
        while (i < columnModel.getColumnCount()) {
            TableColumn col = columnModel.getColumn(i);
            col.setIdentifier((Object)ModuleTableModel.Columns.values()[i]);
            int minCellWidth = this.tm.getColumnClass(i) == Boolean.class ? 32 : 48;
            col.setMinWidth(minCellWidth);
            int prefCellWidth = col.getIdentifier() == ModuleTableModel.Columns.NAME || col.getIdentifier() == ModuleTableModel.Columns.STATE ? 192 : minCellWidth;
            Component headerComp = headerDefaultRenderer.getTableCellRendererComponent(null, col.getHeaderValue(), false, false, 0, 0);
            col.setPreferredWidth(Math.max(headerComp.getMinimumSize().width, prefCellWidth));
            if (col.getIdentifier() == ModuleTableModel.Columns.CB) {
                col.setMaxWidth(minCellWidth);
            } else {
                col.setMaxWidth(Integer.MAX_VALUE);
            }
            col.setWidth(col.getPreferredWidth());
            if (booleanCols.contains(col.getIdentifier())) {
                col.setCellRenderer(new AlternateTableCellRenderer(booleanRenderer));
            } else {
                AlternateTableCellRenderer.setRenderer(col);
            }
            ++i;
        }
        t.setPreferredScrollableViewportSize(new Dimension(t.getPreferredSize().width, 400));
        t.getTableHeader().setReorderingAllowed(false);
        t.setShowHorizontalLines(false);
        t.setGridColor(new Color(230, 230, 230));
        t.setRowHeight(t.getRowHeight() + 4);
        t.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 2L) != 0L) {
                    if (!e.getChanged().isDisplayable()) {
                        ModulePanel.this.tm.clear();
                    } else {
                        ModulePanel.this.reload();
                    }
                }
            }
        });
        JScrollPane scroll = new JScrollPane(t);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridheight = 5;
        c.fill = 1;
        this.add((Component)scroll, c);
        c.weightx = 0.0;
        c.weighty = 0.0;
        ++c.gridx;
        c.fill = 0;
        c.gridheight = 1;
        final JButton installButton = new JButton(AvailableModulesPanel.createInstallAction(this, onlyInstall));
        installButton.setOpaque(false);
        this.add((Component)installButton, c);
        if (!onlyInstall) {
            ++c.gridy;
            JButton activateButton = new JButton(new StartStopAction(ModuleManager.ModuleAction.START));
            activateButton.setOpaque(false);
            this.add((Component)activateButton, c);
            JButton desactivateButton = new JButton(new StartStopAction(ModuleManager.ModuleAction.STOP));
            desactivateButton.setOpaque(false);
            ++c.gridy;
            this.add((Component)desactivateButton, c);
        }
        c.insets = new Insets(20, 3, 2, 2);
        JButton uninstallButton = new JButton(new AbstractAction("D\u00e9sinstaller"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String dialogTitle = "D\u00e9sinstallation de modules";
                Collection<ModuleTableModel.ModuleRow> checkedRows = ModulePanel.this.getSelection();
                if (checkedRows.isEmpty()) {
                    JOptionPane.showMessageDialog(ModulePanel.this, "Aucune ligne coch\u00e9e", "D\u00e9sinstallation de modules", 1);
                    return;
                }
                final ModuleManager mngr = ModuleManager.getInstance();
                final boolean forceUninstall = (evt.getModifiers() & 2) != 0 && mngr.currentUserIsAdmin();
                try {
                    String denied;
                    final HashSet<ModuleReference> ids = new HashSet<ModuleReference>();
                    final HashSet<ModuleReference> deniedRefs = new HashSet<ModuleReference>();
                    for (ModuleTableModel.ModuleRow f : checkedRows) {
                        if (!mngr.canCurrentUser(ModuleManager.ModuleAction.UNINSTALL, f)) {
                            deniedRefs.add(f.getRef());
                            continue;
                        }
                        ids.add(f.getRef());
                    }
                    String string = denied = deniedRefs.size() == 0 ? "" : "D\u00e9sinstallation refus\u00e9e pour les modules :\n" + ModulePanel.formatList(deniedRefs) + ".\n";
                    if (ids.size() == 0) {
                        if (!$assertionsDisabled && denied.length() <= 0) {
                            throw new AssertionError();
                        }
                        JOptionPane.showMessageDialog(ModulePanel.this, denied, "D\u00e9sinstallation de modules", 2);
                        return;
                    }
                    if (!$assertionsDisabled && ids.size() <= 0) {
                        throw new AssertionError();
                    }
                    int answer = JOptionPane.showConfirmDialog(ModulePanel.this, "\u00cates-vous s\u00fbr de vouloir d\u00e9sinstaller ces modules " + (forceUninstall ? "*en ce passant des modules si n\u00e9cessaire* " : "") + "?\n" + denied + "Toutes les donn\u00e9es seront irr\u00e9m\u00e9diablement effac\u00e9es.", "D\u00e9sinstallation de modules", 0, 2);
                    if (answer == 1) {
                        return;
                    }
                    final JDialog dialog = AvailableModulesPanel.displayDialog(ModulePanel.this, "Calcul des d\u00e9pendences");
                    new SwingWorker<ModulesStateChange, Object>(){

                        @Override
                        protected ModulesStateChange doInBackground() throws Exception {
                            return mngr.getUninstallSolution(ids, true, forceUninstall);
                        }

                        @Override
                        protected void done() {
                            dialog.dispose();
                            try {
                                ModulesStateChange solution = (ModulesStateChange)this.get();
                                HashSet<ModuleReference> dependentModules = new HashSet<ModuleReference>(solution.getReferencesToRemove());
                                dependentModules.removeAll(ids);
                                if (!dependentModules.isEmpty()) {
                                    deniedRefs.clear();
                                    for (ModuleReference depModule : dependentModules) {
                                        if (mngr.canCurrentUserInstall(ModuleManager.ModuleAction.UNINSTALL, depModule, solution.getInstallState())) continue;
                                        deniedRefs.add(depModule);
                                    }
                                    if (deniedRefs.size() > 0) {
                                        JOptionPane.showMessageDialog(ModulePanel.this, "D\u00e9sinstallation refus\u00e9e pour les modules :" + ModulePanel.formatList(deniedRefs), "D\u00e9sinstallation de modules", 2);
                                        return;
                                    }
                                    int selectAnswer = JOptionPane.showConfirmDialog(ModulePanel.this, "Les modules suivants doivent \u00eatre d\u00e9sinstall\u00e9s : \n" + ModulePanel.formatList(dependentModules) + ".\nVoulez-vous \u00e9galement d\u00e9sinstaller ces modules ?", "D\u00e9sinstallation de modules", 0, 2);
                                    if (selectAnswer == 1) {
                                        return;
                                    }
                                }
                                AvailableModulesPanel.applySolution(mngr, ModulePanel.this, solution, onlyInstall);
                            }
                            catch (Exception e) {
                                ExceptionHandler.handle(ModulePanel.this, "Impossible de d\u00e9sinstaller les modules", e);
                            }
                        }
                    }.execute();
                }
                catch (Exception e) {
                    ExceptionHandler.handle(ModulePanel.this, "Impossible de trouver les modules \u00e0 d\u00e9sinstaller", e);
                }
            }
        });
        uninstallButton.setOpaque(false);
        ++c.gridy;
        this.add((Component)uninstallButton, c);
        JPanel space = new JPanel();
        space.setOpaque(false);
        c.weighty = 1.0;
        ++c.gridy;
        this.add((Component)space, c);
        this.tm.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                installButton.setEnabled(ModulePanel.this.tm.isValid());
            }
        });
        this.setTransferHandler(AvailableModulesPanel.createTransferHandler(this));
    }

    public final void reload() {
        try {
            this.tm.reload();
        }
        catch (Exception e) {
            ExceptionHandler.handle(this, "Impossible de recharger la liste des modules", e);
        }
    }

    protected final Collection<ModuleTableModel.ModuleRow> getSelection() {
        return this.tm.getCheckedRows();
    }

    public static String formatList(Collection<ModuleReference> refs) {
        String str = "";
        ArrayList<ModuleReference> lInstall = new ArrayList<ModuleReference>(refs);
        Collections.sort(lInstall, ModuleReference.COMP_ID_ASC_VERSION_DESC);
        for (ModuleReference moduleReference : refs) {
            str = String.valueOf(str) + "- " + ModulePanel.format(moduleReference);
        }
        return str;
    }

    public static String format(ModuleReference moduleReference) {
        String str = moduleReference.getID();
        if (moduleReference.getVersion() != null) {
            str = String.valueOf(str) + " (" + moduleReference.getVersion().toString() + ")";
        }
        return str;
    }

    private final class StartStopAction
    extends AbstractAction {
        private final boolean start;
        private final ModuleManager.ModuleAction action;

        public StartStopAction(ModuleManager.ModuleAction action) {
            super(action == ModuleManager.ModuleAction.START ? "Activer" : "D\u00e9sactiver");
            if (action != ModuleManager.ModuleAction.START && action != ModuleManager.ModuleAction.STOP) {
                throw new IllegalArgumentException((Object)((Object)action) + " is neither START nor STOP");
            }
            this.action = action;
            this.start = action == ModuleManager.ModuleAction.START;
            this.putValue("ShortDescription", this.start ? "D\u00e9marrer le(s) module(s), maintenir CTRL pour rendre obligatoire le d\u00e9marrage" : "Arr\u00eate le(s) module(s), maintenir CTRL pour rendre facultatif le d\u00e9marrage");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            HashSet<ModuleReference> deniedRefs;
            HashSet<ModuleReference> refs;
            HashSet<ModuleReference> adminRequired;
            String dialogTitle;
            ModuleManager mngr;
            block25: {
                String msg;
                mngr = ModuleManager.getInstance();
                dialogTitle = this.start ? "D\u00e9marrage de modules" : "Arr\u00eat de modules";
                Collection<ModuleTableModel.ModuleRow> checkedRows = ModulePanel.this.getSelection();
                if (checkedRows.isEmpty()) {
                    JOptionPane.showMessageDialog(ModulePanel.this, "Aucune ligne coch\u00e9e", dialogTitle, 1);
                    return;
                }
                boolean userIsAdmin = mngr.currentUserIsAdmin();
                boolean changeRequired = (evt.getModifiers() & 2) != 0 && userIsAdmin;
                adminRequired = changeRequired ? new HashSet<ModuleReference>() : Collections.emptySet();
                refs = new HashSet<ModuleReference>();
                deniedRefs = new HashSet<ModuleReference>();
                for (ModuleTableModel.ModuleRow f : checkedRows) {
                    if (!mngr.canCurrentUser(this.action, f)) {
                        deniedRefs.add(f.getRef());
                    } else {
                        refs.add(f.getRef());
                    }
                    if (!changeRequired) continue;
                    adminRequired.add(f.getRef());
                }
                if (deniedRefs.size() <= 0 || !AvailableModulesPanel.displayDenied(ModulePanel.this, dialogTitle, msg = this.getDeniedMessage(deniedRefs), refs.size() == 0)) break block25;
                try {
                    mngr.setAdminRequiredModules(adminRequired, this.start);
                }
                catch (BackingStoreException e1) {
                    ExceptionHandler.handle(ModulePanel.this, "Impossible de rendre " + (this.start ? "obligatoires" : "facultatifs") + " les modules", e1);
                }
                ModulePanel.this.reload();
                return;
            }
            try {
                try {
                    assert (refs.size() > 0);
                    if (this.start) {
                        Set<ModuleReference> notStarted = mngr.startModules(refs, ModuleManager.NoChoicePredicate.NO_CHANGE, true);
                        if (notStarted.size() > 0) {
                            JOptionPane.showMessageDialog(ModulePanel.this, String.valueOf(this.getDeniedMessage(notStarted)) + "\nEssayer d'abord de les installer", dialogTitle, 2);
                        }
                    } else {
                        for (ModuleReference ref : refs) {
                            List<ModuleReference> runningDepModules = mngr.getRunningDependentModulesRecursively(ref.getID());
                            deniedRefs.clear();
                            for (ModuleReference runningDepModule : runningDepModules) {
                                if (mngr.canCurrentUser(this.action, ModulePanel.this.tm.getRow(runningDepModule))) continue;
                                deniedRefs.add(runningDepModule);
                            }
                            if (!deniedRefs.isEmpty()) {
                                JOptionPane.showMessageDialog(ModulePanel.this, this.getDeniedMessage(deniedRefs), dialogTitle, 2);
                                continue;
                            }
                            for (ModuleReference runningDepModule : runningDepModules) {
                                mngr.stopModule(runningDepModule.getID());
                            }
                        }
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle(ModulePanel.this, "Impossible " + (this.start ? "d'activer" : "de d\u00e9sactiver") + " les modules", e);
                    try {
                        mngr.setAdminRequiredModules(adminRequired, this.start);
                    }
                    catch (BackingStoreException e1) {
                        ExceptionHandler.handle(ModulePanel.this, "Impossible de rendre " + (this.start ? "obligatoires" : "facultatifs") + " les modules", e1);
                    }
                    ModulePanel.this.reload();
                }
            }
            catch (Throwable throwable) {
                try {
                    mngr.setAdminRequiredModules(adminRequired, this.start);
                }
                catch (BackingStoreException e1) {
                    ExceptionHandler.handle(ModulePanel.this, "Impossible de rendre " + (this.start ? "obligatoires" : "facultatifs") + " les modules", e1);
                }
                ModulePanel.this.reload();
                throw throwable;
            }
            try {
                mngr.setAdminRequiredModules(adminRequired, this.start);
            }
            catch (BackingStoreException e1) {
                ExceptionHandler.handle(ModulePanel.this, "Impossible de rendre " + (this.start ? "obligatoires" : "facultatifs") + " les modules", e1);
            }
            ModulePanel.this.reload();
        }

        private final String getDeniedMessage(Set<ModuleReference> deniedRefs) {
            return "Les modules suivants ne peuvent \u00eatre " + (this.start ? "d\u00e9marr\u00e9s" : "arr\u00eat\u00e9s") + " : \n" + ModulePanel.formatList(deniedRefs);
        }
    }
}

