/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.model;

import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.generationDoc.AbstractSheetXml;
import org.openconcerto.erp.model.PrintDocumentAction;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.ui.EmailComposer;
import org.openconcerto.utils.ExceptionHandler;

public class MouseSheetXmlListeListener {
    private Class<? extends AbstractSheetXml> clazz;
    protected IListe liste;
    private boolean previewIsVisible = true;
    private boolean showIsVisible = true;
    private boolean printIsVisible = true;
    private boolean generateIsVisible = true;
    private boolean previewHeader = false;
    private boolean showHeader = false;
    private boolean generateHeader = false;

    public MouseSheetXmlListeListener(Class<? extends AbstractSheetXml> clazz) {
        this(clazz, true, true, true, true);
    }

    public MouseSheetXmlListeListener(Class<? extends AbstractSheetXml> clazz, boolean show, boolean preview, boolean print, boolean generate) {
        this.clazz = clazz;
        this.printIsVisible = print;
        this.previewIsVisible = preview;
        this.showIsVisible = show;
        this.generateIsVisible = generate;
    }

    protected Class<? extends AbstractSheetXml> getSheetClass() {
        return this.clazz;
    }

    protected AbstractSheetXml createAbstractSheet(SQLRow row) {
        try {
            Constructor<? extends AbstractSheetXml> ctor = this.getSheetClass().getConstructor(SQLRow.class);
            AbstractSheetXml sheet = ctor.newInstance(row);
            return sheet;
        }
        catch (Exception e) {
            ExceptionHandler.handle("sheet creation error", e);
            return null;
        }
    }

    public List<AbstractSheetXml> createAbstractSheets(List<SQLRow> rows) {
        ArrayList<AbstractSheetXml> sheets = new ArrayList<AbstractSheetXml>(rows.size());
        try {
            Constructor<? extends AbstractSheetXml> ctor = this.getSheetClass().getConstructor(SQLRow.class);
            for (SQLRow row : rows) {
                AbstractSheetXml sheet = ctor.newInstance(row);
                sheets.add(sheet);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle("sheet creation error", e);
        }
        return sheets;
    }

    protected String getMailObject(SQLRow row) {
        return "";
    }

    public void setPreviewHeader(boolean previewHeader) {
        this.previewHeader = previewHeader;
    }

    public void setGenerateHeader(boolean generateHeader) {
        this.generateHeader = generateHeader;
    }

    public void setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
    }

    protected void sendMail(AbstractSheetXml sheet, boolean readOnly) {
        ArrayList<AbstractSheetXml> l = new ArrayList<AbstractSheetXml>(1);
        l.add(sheet);
        this.sendMail(l, readOnly);
    }

    protected void sendMail(final List<AbstractSheetXml> sheets, boolean readOnly) {
        String mail = "";
        for (AbstractSheetXml sheet : sheets) {
            SQLRow rowM;
            Set<SQLField> setM;
            SQLTable tableM;
            SQLBase base;
            SQLRow row = sheet.getSQLRow();
            Set<SQLField> setContact = null;
            SQLTable tableContact = Configuration.getInstance().getRoot().findTable("CONTACT");
            setContact = row.getTable().getForeignKeys(tableContact);
            Set<SQLField> setClient = null;
            SQLTable tableClient = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("CLIENT");
            setClient = row.getTable().getForeignKeys(tableClient);
            for (SQLField field : setContact) {
                if (mail != null && mail.trim().length() != 0) continue;
                mail = row.getForeignRow(field.getName()).getString("EMAIL");
            }
            if (setClient != null && (mail == null || mail.trim().length() == 0)) {
                for (SQLField field : setClient) {
                    SQLRow rowCli = row.getForeignRow(field.getName());
                    if (mail != null && mail.trim().length() != 0) continue;
                    mail = rowCli.getString("MAIL");
                }
            }
            if (mail != null && mail.trim().length() != 0) continue;
            SQLTable tableF = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("FOURNISSEUR");
            Set<SQLField> setF = null;
            setF = row.getTable().getForeignKeys(tableF);
            if (setF != null) {
                for (SQLField field : setF) {
                    SQLRow rowF = row.getForeignRow(field.getName());
                    if (mail != null && mail.trim().length() != 0) continue;
                    mail = rowF.getString("MAIL");
                }
            }
            if ((mail == null || mail.trim().length() == 0) && (base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete()).containsTable("MONTEUR")) {
                tableM = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("MONTEUR");
                setM = null;
                setM = row.getTable().getForeignKeys(tableM);
                if (setM != null) {
                    for (SQLField field : setM) {
                        rowM = row.getForeignRow(field.getName());
                        if (rowM.getForeignRow("ID_CONTACT_FOURNISSEUR") == null || rowM.getForeignRow("ID_CONTACT_FOURNISSEUR").isUndefined()) continue;
                        mail = rowM.getForeignRow("ID_CONTACT_FOURNISSEUR").getString("EMAIL");
                    }
                }
            }
            if (mail != null && mail.trim().length() != 0 || !(base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete()).containsTable("TRANSPORTEUR")) continue;
            tableM = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("TRANSPORTEUR");
            setM = null;
            setM = row.getTable().getForeignKeys(tableM);
            if (setM == null) continue;
            for (SQLField field : setM) {
                rowM = row.getForeignRow(field.getName());
                if (rowM.getForeignRow("ID_CONTACT_FOURNISSEUR") == null || rowM.getForeignRow("ID_CONTACT_FOURNISSEUR").isUndefined()) continue;
                mail = rowM.getForeignRow("ID_CONTACT_FOURNISSEUR").getString("EMAIL");
            }
        }
        final String adresseMail = mail;
        final String subject = sheets.get(0).getReference();
        if (readOnly) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    final ArrayList<File> files = new ArrayList<File>();
                    try {
                        for (AbstractSheetXml sheet : sheets) {
                            files.add(sheet.getOrCreatePDFDocumentFile(true).getAbsoluteFile());
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    EmailComposer.getInstance().compose(adresseMail, String.valueOf(subject) + (subject.trim().length() == 0 ? "" : ", ") + ((File)files.get(0)).getName(), MouseSheetXmlListeListener.this.getMailObject(((AbstractSheetXml)sheets.get(0)).getSQLRow()), files.toArray(new File[files.size()]));
                                }
                                catch (Exception e) {
                                    ExceptionHandler.handle("Impossible de charger le document PDF dans l'email!", e);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle("Impossible de charger le document PDF", e);
                    }
                }
            };
            t.start();
        } else {
            try {
                ArrayList<File> files = new ArrayList<File>();
                for (AbstractSheetXml sheet : sheets) {
                    files.add(sheet.getGeneratedFile().getAbsoluteFile());
                }
                EmailComposer.getInstance().compose(adresseMail, String.valueOf(subject) + (subject.trim().length() == 0 ? "" : ", ") + sheets.get(0).getGeneratedFile().getName(), this.getMailObject(sheets.get(0).getSQLRow()), files.toArray(new File[files.size()]));
            }
            catch (Exception exn) {
                ExceptionHandler.handle(null, "Impossible de cr\u00e9er le courriel", exn);
            }
        }
    }

    public List<RowAction> addToMenu() {
        return null;
    }

    public List<RowAction> getRowActions() {
        List<RowAction> list;
        ArrayList<RowAction> l = new ArrayList<RowAction>();
        if (!Boolean.getBoolean("org.openconcerto.oo.useODSViewer")) {
            if (this.showIsVisible) {
                RowAction action = new RowAction(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        try {
                            MouseSheetXmlListeListener.this.createAbstractSheet(IListe.get(ev).fetchSelectedRow()).openDocument(false);
                        }
                        catch (Exception e) {
                            ExceptionHandler.handle("Impossible d'ouvrir le fichier", e);
                        }
                    }
                }, this.previewHeader, "document.modify"){

                    @Override
                    public boolean enabledFor(IListeAction.IListeEvent evt) {
                        return evt.getSelectedRow() != null && evt.getTotalRowCount() >= 1;
                    }
                };
                l.add(action);
            }
        } else if (this.previewIsVisible) {
            l.add(new RowAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    try {
                        MouseSheetXmlListeListener.this.createAbstractSheet(IListe.get(ev).fetchSelectedRow()).showPreviewDocument();
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle("Impossible d'ouvrir le fichier", e);
                    }
                }
            }, this.previewHeader, "document.preview"){

                @Override
                public boolean enabledFor(IListeAction.IListeEvent evt) {
                    return evt.getSelectedRow() != null && evt.getTotalRowCount() >= 1;
                }
            });
        }
        if ((list = this.addToMenu()) != null) {
            for (RowAction rowAction : list) {
                l.add(rowAction);
            }
        }
        if (Boolean.getBoolean("org.openconcerto.oo.useODSViewer") && this.showIsVisible) {
            l.add(new RowAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    try {
                        MouseSheetXmlListeListener.this.createAbstractSheet(IListe.get(ev).fetchSelectedRow()).openDocument(false);
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle("Impossible d'ouvrir le fichier", e);
                    }
                }
            }, this.showHeader, "document.modify"){

                @Override
                public boolean enabledFor(IListeAction.IListeEvent evt) {
                    return evt.getSelectedRow() != null && evt.getTotalRowCount() >= 1;
                }
            });
        }
        if (this.printIsVisible) {
            l.add(new RowAction(new PrintDocumentAction(this), false, "document.print"){

                @Override
                public boolean enabledFor(IListeAction.IListeEvent evt) {
                    return evt.getSelectedRow() != null && evt.getSelectedRows().size() > 0;
                }
            });
        }
        if (this.showIsVisible) {
            l.add(this.getSendMailPDF());
            l.add(this.getSendMail());
        }
        if (this.generateIsVisible) {
            l.add(new RowAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    List<SQLRowValues> l = IListe.get(ev).getSelectedRows();
                    if (l.size() == 1) {
                        MouseSheetXmlListeListener.this.createDocument(ev);
                    } else {
                        MouseSheetXmlListeListener.this.createDocuments(l);
                    }
                }
            }, this.generateHeader, "document.create"){

                @Override
                public boolean enabledFor(List<SQLRowValues> selection) {
                    return selection != null && selection.size() > 0;
                }
            });
        }
        return l;
    }

    public RowAction getSendMail() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                List<SQLRowValues> selectedRows = IListe.get(ev).getSelectedRows();
                SQLTable table = IListe.get(ev).getSource().getPrimaryTable();
                ArrayList<SQLRow> rows = new ArrayList<SQLRow>();
                for (SQLRowValues r : selectedRows) {
                    rows.add(table.getRow(r.getID()));
                }
                MouseSheetXmlListeListener.this.sendMail(MouseSheetXmlListeListener.this.createAbstractSheets(rows), false);
            }
        }, false, "document.send.email"){

            @Override
            public boolean enabledFor(IListeAction.IListeEvent evt) {
                return evt.getSelectedRow() != null && evt.getTotalRowCount() >= 1;
            }
        };
    }

    public RowAction getSendMailPDF() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                try {
                    List<SQLRowValues> selectedRows = IListe.get(ev).getSelectedRows();
                    SQLTable table = IListe.get(ev).getSource().getPrimaryTable();
                    ArrayList<SQLRow> rows = new ArrayList<SQLRow>();
                    for (SQLRowValues r : selectedRows) {
                        rows.add(table.getRow(r.getID()));
                    }
                    MouseSheetXmlListeListener.this.sendMail(MouseSheetXmlListeListener.this.createAbstractSheets(rows), true);
                }
                catch (Exception e) {
                    ExceptionHandler.handle("Impossible d'envoyer le(s) fichier(s)", e);
                }
            }
        }, false, "document.pdf.send.email"){

            @Override
            public boolean enabledFor(IListeAction.IListeEvent evt) {
                return evt.getSelectedRow() != null && evt.getTotalRowCount() >= 1;
            }
        };
    }

    private void createDocuments(List<? extends SQLRowAccessor> selection) {
        int a = JOptionPane.showConfirmDialog(null, "Voulez vous recr\u00e9er l'ensemble des documents s\u00e9lectionn\u00e9s?", "G\u00e9n\u00e9ration de documents", 0);
        if (a == 0) {
            for (SQLRowAccessor sQLRowAccessor : selection) {
                AbstractSheetXml sheet = this.createAbstractSheet(sQLRowAccessor.getTable().getRow(sQLRowAccessor.getID()));
                sheet.createDocumentAsynchronous();
                sheet.showPrintAndExportAsynchronous(false, false, true);
            }
        }
    }

    private void createDocument(ActionEvent ev) {
        int a;
        AbstractSheetXml sheet = this.createAbstractSheet(IListe.get(ev).fetchSelectedRow());
        if (sheet.getGeneratedFile().exists() && (a = JOptionPane.showConfirmDialog(null, "Voulez vous remplacer le document existant?", "G\u00e9n\u00e9ration de documents", 0)) == 0) {
            sheet.createDocumentAsynchronous();
            sheet.showPrintAndExportAsynchronous(true, false, true);
            return;
        }
        try {
            sheet.getOrCreateDocumentFile();
            sheet.showPrintAndExportAsynchronous(true, false, false);
        }
        catch (Exception exn) {
            exn.printStackTrace();
        }
    }

    public RowAction getDefaultRowAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AbstractSheetXml sheet = MouseSheetXmlListeListener.this.createAbstractSheet(IListe.get(ev).fetchSelectedRow().asRow());
                try {
                    sheet.getOrCreateDocumentFile();
                    sheet.showPrintAndExportAsynchronous(true, false, true);
                }
                catch (Exception exn) {
                    ExceptionHandler.handle("Une erreur est survenue lors de la cr\u00e9ation du document.", exn);
                }
            }
        }, false, false, "document.create"){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                return selection != null && selection.size() == 1;
            }

            @Override
            public Action getDefaultAction(IListeAction.IListeEvent evt) {
                return this.getAction();
            }
        };
    }
}

