/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.injector;

import java.math.BigDecimal;
import java.util.Collection;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class DevisBlSQLInjector
extends SQLInjector {
    public DevisBlSQLInjector(DBRoot root) {
        super(root, "DEVIS", "BON_DE_LIVRAISON", true);
        SQLTable tableDevis = this.getSource();
        SQLTable tableBon = this.getDestination();
        this.map(tableDevis.getField("ID_CLIENT"), tableBon.getField("ID_CLIENT"));
        if (this.getSource().getTable().contains("ID_CONTACT")) {
            this.map(tableDevis.getField("ID_CONTACT"), tableBon.getField("ID_CONTACT"));
        }
        this.mapDefaultValues(tableBon.getField("SOURCE"), tableBon.getName());
        this.map(tableDevis.getField("ID_DEVIS"), tableBon.getField("IDSOURCE"));
        if (tableDevis.getTable().contains("ID_POLE_PRODUIT")) {
            this.map(tableDevis.getField("ID_POLE_PRODUIT"), tableBon.getField("ID_POLE_PRODUIT"));
        }
        if (this.getSource().getTable().contains("ID_CLIENT_DEPARTEMENT")) {
            this.map(this.getSource().getField("ID_CLIENT_DEPARTEMENT"), this.getDestination().getField("ID_CLIENT_DEPARTEMENT"));
        }
        if (this.getSource().getTable().contains("ID_ADRESSE") && this.getDestination().contains("ID_ADRESSE")) {
            this.map(this.getSource().getField("ID_ADRESSE"), this.getDestination().getField("ID_ADRESSE"));
        }
        if (this.getSource().getTable().contains("ID_ADRESSE_LIVRAISON")) {
            this.map(this.getSource().getField("ID_ADRESSE_LIVRAISON"), this.getDestination().getField("ID_ADRESSE_LIVRAISON"));
        }
    }

    @Override
    protected void merge(SQLRowAccessor srcRow, SQLRowValues rowVals) {
        super.merge(srcRow, rowVals);
        SQLTable tableElementSource = this.getSource().getTable("DEVIS_ELEMENT");
        SQLTable tableElementDestination = this.getSource().getTable("BON_DE_LIVRAISON_ELEMENT");
        Collection myListItem = srcRow.asRow().getReferentRows(tableElementSource);
        this.transfertReference(srcRow, rowVals, "NOM", "NOM");
        this.transfertReference(srcRow, rowVals, "INFOS", "INFOS");
        this.transfertNumberReference(srcRow, rowVals, tableElementDestination, "ID_BON_DE_LIVRAISON");
        if (myListItem.size() != 0) {
            SQLInjector injector = SQLInjector.getInjector(tableElementSource, tableElementDestination);
            for (SQLRowAccessor rowElt : myListItem) {
                SQLRowValues createRowValuesFrom = injector.createRowValuesFrom(rowElt.asRow());
                if (createRowValuesFrom.getTable().getFieldsName().contains("POURCENT_ACOMPTE") && createRowValuesFrom.getObject("POURCENT_ACOMPTE") == null) {
                    createRowValuesFrom.put("POURCENT_ACOMPTE", new BigDecimal(100.0));
                }
                createRowValuesFrom.put("ID_BON_DE_LIVRAISON", (Object)rowVals);
            }
        }
    }
}

