/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.gestcomm;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.openconcerto.erp.generationDoc.AbstractListeSheetXml;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.cc.ITransformer;

public class ReportingTaxeComplementaireSheetXML
extends AbstractListeSheetXml {
    public static final String TEMPLATE_ID = "ReportingTaxeComplementaire";
    public static final String TEMPLATE_PROPERTY_NAME = "Default";
    private Date date;
    private Date dateD;
    private Date dateF;
    private static SQLTable tableVF = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE").getTable();

    public ReportingTaxeComplementaireSheetXML(Date debut, Date fin) {
        this.dateD = debut;
        this.dateF = fin;
    }

    @Override
    public String getStoragePathP() {
        return "Autres";
    }

    @Override
    public String getDefaultTemplateId() {
        return TEMPLATE_ID;
    }

    @Override
    public String getName() {
        if (this.date == null) {
            this.date = new Date();
        }
        return "ReportingTaxeCompl" + this.date.getTime();
    }

    @Override
    protected void createListeValues() {
        this.mapAllSheetValues = new HashMap();
        this.listAllSheetValues = new HashMap();
        this.styleAllSheetValues = new HashMap();
        this.fillSynthese();
    }

    private void fillSynthese() {
        final SQLTable tableVF = Configuration.getInstance().getRoot().findTable("SAISIE_VENTE_FACTURE");
        SQLTable tableVFElt = Configuration.getInstance().getRoot().findTable("SAISIE_VENTE_FACTURE_ELEMENT");
        SQLRowValues rowvalsVF = new SQLRowValues(tableVF);
        rowvalsVF.put("NUMERO", null);
        rowvalsVF.put("DATE", null);
        SQLRowValues rowvalsVFElt = new SQLRowValues(tableVFElt);
        rowvalsVFElt.put("ID_SAISIE_VENTE_FACTURE", (Object)rowvalsVF);
        rowvalsVFElt.put("T_PV_HT", null);
        rowvalsVFElt.put("QTE", null);
        rowvalsVFElt.put("QTE_UNITAIRE", null);
        rowvalsVFElt.putRowValues("ID_ARTICLE").putRowValues("ID_TAXE_COMPLEMENTAIRE").putNulls("CODE", "NOM", "POURCENT");
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowvalsVFElt);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                Where w = new Where(input.getAlias(tableVF).getField("DATE"), ReportingTaxeComplementaireSheetXML.this.dateD, (Object)ReportingTaxeComplementaireSheetXML.this.dateF);
                input.setWhere(w);
                return input;
            }
        });
        HashMap<Integer, TaxeComplRecap> recap = new HashMap<Integer, TaxeComplRecap>();
        List<SQLRowValues> results = fetcher.fetch();
        for (SQLRowValues sqlRowValues : results) {
            TaxeComplRecap r;
            SQLRowAccessor foreignArt;
            if (sqlRowValues.getForeign("ID_ARTICLE") == null || sqlRowValues.isForeignEmpty("ID_ARTICLE") || (foreignArt = sqlRowValues.getForeign("ID_ARTICLE")).getForeign("ID_TAXE_COMPLEMENTAIRE") == null || foreignArt.isForeignEmpty("ID_TAXE_COMPLEMENTAIRE")) continue;
            SQLRowAccessor foreignTaxeCompl = foreignArt.getForeign("ID_TAXE_COMPLEMENTAIRE");
            if (recap.containsKey(foreignTaxeCompl.getID())) {
                r = (TaxeComplRecap)recap.get(foreignTaxeCompl.getID());
            } else {
                r = new TaxeComplRecap(foreignTaxeCompl.getString("CODE"), foreignTaxeCompl.getString("NOM"), foreignTaxeCompl.getBigDecimal("POURCENT"));
                recap.put(foreignTaxeCompl.getID(), r);
            }
            r.cumul(sqlRowValues.getBigDecimal("QTE_UNITAIRE").multiply(new BigDecimal(sqlRowValues.getInt("QTE"))), sqlRowValues.getBigDecimal("T_PV_HT"));
        }
        ArrayList values = new ArrayList();
        this.listAllSheetValues.put(0, values);
        HashMap<Integer, String> style = new HashMap<Integer, String>();
        this.styleAllSheetValues.put(0, style);
        BigDecimal totalBaseHT = BigDecimal.ZERO;
        BigDecimal totalTaxe = BigDecimal.ZERO;
        BigDecimal qteTotal = BigDecimal.ZERO;
        for (TaxeComplRecap item : recap.values()) {
            HashMap<String, Object> vals = new HashMap<String, Object>();
            vals.put("CODE", item.getCode());
            vals.put("NOM", item.getNom());
            vals.put("QTE", item.getQte());
            vals.put("POURCENT", item.getPercentTaxe());
            vals.put("TOTAL_BASE", item.getTotalBaseHT());
            vals.put("TOTAL_TAXE", item.getTotalTaxe());
            style.put(values.size(), "Normal");
            totalBaseHT = totalBaseHT.add(item.getTotalBaseHT());
            totalTaxe = totalTaxe.add(item.getTotalTaxe());
            qteTotal = qteTotal.add(item.getQte());
            values.add(vals);
        }
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
        HashMap<String, Object> vals = new HashMap<String, Object>();
        vals.put("DATE_DEB", this.dateD);
        vals.put("DATE_FIN", this.dateF);
        vals.put("PERIODE", "P\u00e9riode du " + format.format(this.dateD) + " au " + format.format(this.dateF));
        vals.put("TOTAL_TAXE", totalTaxe);
        vals.put("TOTAL_BASE", totalBaseHT);
        vals.put("TOTAL_QTE", qteTotal);
        this.mapAllSheetValues.put(0, vals);
    }

    class TaxeComplRecap {
        private final String code;
        private final String nom;
        private BigDecimal percentTaxe;
        private BigDecimal totalBase;
        private BigDecimal qte;

        public TaxeComplRecap(String code, String nom, BigDecimal percentTaxe) {
            this.code = code;
            this.nom = nom;
            this.qte = BigDecimal.ZERO;
            this.percentTaxe = percentTaxe;
            this.totalBase = BigDecimal.ZERO;
        }

        public void cumul(BigDecimal qte, BigDecimal total) {
            this.qte = qte.add(this.qte);
            this.totalBase = total.add(this.totalBase);
        }

        public String getCode() {
            return this.code;
        }

        public String getNom() {
            return this.nom;
        }

        public BigDecimal getQte() {
            return this.qte;
        }

        public BigDecimal getPercentTaxe() {
            return this.percentTaxe;
        }

        public BigDecimal getTotalBase() {
            return this.totalBase;
        }

        public BigDecimal getTotalTaxe() {
            return this.totalBase.multiply(this.percentTaxe.movePointLeft(2)).setScale(2, RoundingMode.HALF_UP);
        }

        public BigDecimal getTotalBaseHT() {
            return this.totalBase.subtract(this.getTotalTaxe());
        }
    }
}

