/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.supplier.component;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.customerrelationship.customer.element.ContactItemTable;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.model.ISQLCompteSelector;
import org.openconcerto.erp.preferences.ModeReglementDefautPrefPanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.ui.component.InteractionMode;

public class FournisseurSQLComponent
extends BaseSQLComponent {
    JCheckBox checkEnlevement;
    ElementSQLObject comp2;
    TitledSeparator sep2;
    private ContactItemTable table;
    private SQLTable contactTable = Configuration.getInstance().getDirectory().getElement("CONTACT_FOURNISSEUR").getTable();
    private SQLRowValues defaultContactRowVals = new SQLRowValues(UndefinedRowValuesCache.getInstance().getDefaultRowValues(this.contactTable));

    public FournisseurSQLComponent(SQLElement elt) {
        super(elt);
    }

    @Override
    public void addViews() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        JLabel labelCode = new JLabel("Code", 4);
        JTextField textCode = new JTextField();
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.add((Component)labelCode, c);
        ++c.gridx;
        c.weightx = 0.5;
        this.add((Component)textCode, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        JLabel labelRS = new JLabel("Forme juridique", 4);
        SQLTextCombo textType = new SQLTextCombo();
        JTextField textNom = new JTextField();
        this.add((Component)labelRS, c);
        ++c.gridx;
        c.weightx = 0.5;
        this.add((Component)textType, c);
        JLabel labelTel = new JLabel(this.getLabelFor("TEL"), 4);
        JTextField textTel = new JTextField(15);
        ++c.gridx;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.add((Component)labelTel, c);
        ++c.gridx;
        c.weightx = 0.5;
        this.add((Component)textTel, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        String fieldNom = "NOM";
        if (this.getTable().contains("NOM_SOCIETE")) {
            fieldNom = "NOM_SOCIETE";
        }
        this.add((Component)new JLabel(this.getLabelFor(fieldNom), 4), c);
        ++c.gridx;
        c.weightx = 0.5;
        this.add((Component)textNom, c);
        this.addRequiredSQLObject(textNom, fieldNom);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)new JLabel(this.getLabelFor("FAX"), 4), c);
        ++c.gridx;
        c.weightx = 0.5;
        JTextField textFax = new JTextField();
        this.add((Component)textFax, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.add((Component)new JLabel(this.getLabelFor("MAIL"), 4), c);
        ++c.gridx;
        c.weightx = 0.5;
        JTextField textMail = new JTextField();
        this.add((Component)textMail, c);
        this.addView(textMail, "MAIL");
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)new JLabel(this.getLabelFor("TEL_P"), 4), c);
        ++c.gridx;
        c.weightx = 0.5;
        JTextField textTelP = new JTextField();
        this.add((Component)textTelP, c);
        this.addView(textTelP, "TEL_P");
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel(this.getLabelFor("ID_LANGUE"), 4), c);
        ++c.gridx;
        c.weightx = 0.5;
        ElementComboBox langue = new ElementComboBox(true, 35);
        this.add((Component)langue, c);
        this.addView(langue, "ID_LANGUE");
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)new JLabel(this.getLabelFor("RESPONSABLE"), 4), c);
        ++c.gridx;
        c.weightx = 0.5;
        JTextField textResp = new JTextField();
        this.add((Component)textResp, c);
        this.addView(textResp, "RESPONSABLE");
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel(this.getLabelFor("SIRET"), 4), c);
        ++c.gridx;
        c.weightx = 0.5;
        JTextField textSiret = new JTextField();
        this.add((Component)textSiret, c);
        this.addView(textSiret, "SIRET");
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)new JLabel(this.getLabelFor("NUMERO_TVA"), 4), c);
        ++c.gridx;
        c.weightx = 0.5;
        JTextField textNumeroTVA = new JTextField();
        this.add((Component)textNumeroTVA, c);
        this.addView(textNumeroTVA, "NUMERO_TVA");
        c.gridx = 1;
        ++c.gridy;
        JCheckBox boxUE = new JCheckBox(this.getLabelFor("UE"));
        this.add((Component)boxUE, c);
        if (this.getTable().contains("ID_DEVISE")) {
            ++c.gridx;
            c.weightx = 0.0;
            this.add((Component)new JLabel(this.getLabelFor("ID_DEVISE"), 4), c);
            ++c.gridx;
            c.weightx = 0.5;
            ElementComboBox devise = new ElementComboBox(true, 35);
            this.add((Component)devise, c);
            this.addView(devise, "ID_DEVISE");
        }
        if (this.getTable().contains("ALG_REGISTRE")) {
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            this.add((Component)new JLabel(this.getLabelFor("ALG_REGISTRE"), 4), c);
            ++c.gridx;
            c.weightx = 1.0;
            JTextField fieldRegistre = new JTextField(20);
            this.add((Component)fieldRegistre, c);
            this.addView(fieldRegistre, "ALG_REGISTRE");
            ++c.gridx;
            c.weightx = 0.0;
            this.add((Component)new JLabel(this.getLabelFor("ALG_MATRICULE"), 4), c);
            ++c.gridx;
            c.weightx = 1.0;
            JTextField fieldMatricule = new JTextField(20);
            this.add((Component)fieldMatricule, c);
            this.addView(fieldMatricule, "ALG_MATRICULE");
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            this.add((Component)new JLabel(this.getLabelFor("ALG_ARTICLE"), 4), c);
            ++c.gridx;
            c.weightx = 1.0;
            JTextField fieldArticle = new JTextField(20);
            this.add((Component)fieldArticle, c);
            this.addView(fieldArticle, "ALG_ARTICLE");
        }
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        JPanel addP = ComptaSQLConfElement.createAdditionalPanel();
        this.setAdditionalFieldsPanel(new FormLayouter(addP, 2));
        this.add((Component)addP, c);
        JTabbedPane tabbedPane = new JTabbedPane();
        JPanel panelAdresse = new JPanel(new GridBagLayout());
        panelAdresse.setOpaque(false);
        DefaultGridBagConstraints cAdr = new DefaultGridBagConstraints();
        TitledSeparator sep = new TitledSeparator("Adresse");
        sep.setOpaque(false);
        panelAdresse.add((Component)sep, cAdr);
        this.sep2 = new TitledSeparator("Adresse d'enl\u00e9vement");
        this.sep2.setOpaque(false);
        cAdr.gridx = -1;
        panelAdresse.add((Component)this.sep2, cAdr);
        this.addView("ID_ADRESSE", "required;notdecorated;noseparator");
        ++cAdr.gridy;
        cAdr.fill = 2;
        cAdr.weightx = 1.0;
        ElementSQLObject view = (ElementSQLObject)this.getView("ID_ADRESSE");
        view.setOpaque(false);
        panelAdresse.add((Component)view, cAdr);
        this.addView("ID_ADRESSE_E", "notdecorated");
        cAdr.gridx = -1;
        this.comp2 = (ElementSQLObject)this.getView("ID_ADRESSE_E");
        this.comp2.setCreated(true);
        this.comp2.setOpaque(false);
        panelAdresse.add((Component)this.comp2, cAdr);
        this.checkEnlevement = new JCheckBox("Adresse d'enl\u00e8vement identique");
        this.checkEnlevement.setOpaque(false);
        cAdr.gridx = 0;
        ++cAdr.gridy;
        cAdr.gridwidth = 0;
        panelAdresse.add((Component)this.checkEnlevement, cAdr);
        tabbedPane.add("Adresses", panelAdresse);
        this.checkEnlevement.setSelected(true);
        this.sep2.setVisible(false);
        this.checkEnlevement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Click");
                if (FournisseurSQLComponent.this.checkEnlevement.isSelected()) {
                    System.out.println("Mode 1");
                    FournisseurSQLComponent.this.comp2.setEditable(InteractionMode.DISABLED);
                    FournisseurSQLComponent.this.comp2.setCreated(false);
                    FournisseurSQLComponent.this.sep2.setVisible(false);
                } else {
                    System.out.println("Mode 2");
                    FournisseurSQLComponent.this.comp2.setEditable(InteractionMode.READ_WRITE);
                    FournisseurSQLComponent.this.comp2.setCreated(true);
                    FournisseurSQLComponent.this.sep2.setVisible(true);
                }
            }
        });
        JPanel panelContact = new JPanel(new GridBagLayout());
        panelContact.setOpaque(false);
        this.table = new ContactItemTable(this.defaultContactRowVals);
        this.table.setOpaque(false);
        this.table.setPreferredSize(new Dimension(this.table.getSize().width, 150));
        DefaultGridBagConstraints cContact = new DefaultGridBagConstraints();
        cContact.fill = 1;
        cContact.weightx = 1.0;
        cContact.weighty = 1.0;
        panelContact.add((Component)this.table, cContact);
        tabbedPane.add("Contacts", panelContact);
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 18;
        c.fill = 1;
        c.gridwidth = 0;
        this.add((Component)tabbedPane, c);
        TitledSeparator reglSep = new TitledSeparator(this.getLabelFor("ID_MODE_REGLEMENT"));
        c.gridwidth = 2;
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)reglSep, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        this.addView("ID_MODE_REGLEMENT", "required;notdecorated;noseparator");
        ElementSQLObject eltModeRegl = (ElementSQLObject)this.getView("ID_MODE_REGLEMENT");
        this.add((Component)eltModeRegl, c);
        c.gridx = 2;
        --c.gridy;
        c.gridwidth = 2;
        c.fill = 1;
        TitledSeparator ribSep = new TitledSeparator("Coordonn\u00e9es bancaires");
        this.add((Component)ribSep, c);
        JPanel pCoordonneesBancaires = new JPanel();
        pCoordonneesBancaires.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c2 = new DefaultGridBagConstraints();
        ++c2.gridy;
        JLabel labelIBAN = new JLabel("IBAN", 4);
        JTextField textIBAN = new JTextField(40);
        c2.weightx = 0.0;
        pCoordonneesBancaires.add((Component)labelIBAN, c2);
        ++c2.gridx;
        c2.weightx = 1.0;
        pCoordonneesBancaires.add((Component)textIBAN, c2);
        JLabel labelBIC = new JLabel("BIC", 4);
        JTextField textBIC = new JTextField(12);
        c2.gridx = 0;
        ++c2.gridy;
        c2.weightx = 0.0;
        pCoordonneesBancaires.add((Component)labelBIC, c2);
        ++c2.gridx;
        c2.weightx = 1.0;
        c2.fill = 0;
        pCoordonneesBancaires.add((Component)textBIC, c2);
        ++c.gridy;
        c.fill = 2;
        this.add((Component)pCoordonneesBancaires, c);
        this.addView(textIBAN, "IBAN");
        this.addView(textBIC, "BIC");
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.gridwidth = 0;
        TitledSeparator sepCompteCharge = new TitledSeparator("Comptes associ\u00e9s");
        this.add((Component)sepCompteCharge, c);
        JPanel panel = new JPanel(new GridBagLayout());
        c2 = new DefaultGridBagConstraints();
        panel.add((Component)new JLabel("Compte fournisseur associ\u00e9", 4), c2);
        ISQLCompteSelector compteSel = new ISQLCompteSelector(true);
        ++c2.gridx;
        c2.weightx = 1.0;
        panel.add((Component)compteSel, c2);
        c2.gridx = 0;
        ++c2.gridy;
        c2.weightx = 0.0;
        panel.add((Component)new JLabel(this.getLabelFor("ID_COMPTE_PCE_CHARGE"), 4), c2);
        ISQLCompteSelector compteSelCharge = new ISQLCompteSelector(true);
        ++c2.gridx;
        c2.weightx = 1.0;
        panel.add((Component)compteSelCharge, c2);
        this.addView(compteSelCharge, "ID_COMPTE_PCE_CHARGE");
        c.gridwidth = 0;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.anchor = 18;
        this.add((Component)panel, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.anchor = 18;
        c.gridx = 0;
        ++c.gridy;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 17;
        c.gridwidth = 0;
        this.add((Component)new TitledSeparator(this.getLabelFor("INFOS")), c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        ITextArea infos = new ITextArea();
        JScrollPane scrollPane = new JScrollPane(infos);
        scrollPane.setBorder(null);
        this.add((Component)scrollPane, c);
        this.addView(infos, "INFOS");
        this.addSQLObject(textType, "TYPE");
        this.addSQLObject(textCode, "CODE");
        this.addSQLObject(textTel, "TEL");
        this.addSQLObject(textFax, "FAX");
        this.addSQLObject(boxUE, "UE");
        this.addRequiredSQLObject(compteSel, "ID_COMPTE_PCE");
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
        SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);
        int idCompteFourn = rowPrefsCompte.getInt("ID_COMPTE_PCE_FOURNISSEUR");
        if (idCompteFourn <= 1) {
            try {
                idCompteFourn = ComptePCESQLElement.getIdComptePceDefault("Fournisseurs");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        compteSel.setValue(idCompteFourn);
    }

    @Override
    public void select(SQLRowAccessor r) {
        if (r != null && r.isForeignEmpty("ID_ADRESSE_E")) {
            this.checkEnlevement.setSelected(true);
            this.comp2.setEditable(InteractionMode.DISABLED);
            this.comp2.setCreated(false);
            this.sep2.setVisible(false);
        } else {
            this.checkEnlevement.setSelected(false);
            this.comp2.setEditable(InteractionMode.READ_WRITE);
            this.comp2.setCreated(true);
            this.sep2.setVisible(true);
        }
        if (r != null) {
            this.table.insertFrom("ID_" + this.getTable().getName(), r.asRowValues());
            this.defaultContactRowVals.put("TEL_DIRECT", r.getString("TEL"));
            this.defaultContactRowVals.put("FAX", r.getString("FAX"));
        }
        super.select(r);
    }

    @Override
    public void update() {
        super.update();
        this.table.updateField("ID_" + this.getTable().getName(), this.getSelectedID());
    }

    @Override
    public int insert(SQLRow order) {
        int id = super.insert(order);
        this.table.updateField("ID_" + this.getTable().getName(), id);
        return id;
    }

    @Override
    protected SQLRowValues createDefaults() {
        SQLRowValues vals = new SQLRowValues(this.getTable());
        this.checkEnlevement.setSelected(true);
        this.sep2.setVisible(false);
        try {
            SQLRow r = ModeReglementDefautPrefPanel.getDefaultRow(false);
            SQLElement eltModeReglement = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT");
            if (((SQLRowAccessor)r).getID() > 1) {
                SQLRowValues rowVals = eltModeReglement.createCopy(((SQLRowAccessor)r).getID());
                System.err.println(rowVals.getInt("ID_TYPE_REGLEMENT"));
                vals.put("ID_MODE_REGLEMENT", (Object)rowVals);
            }
        }
        catch (SQLException e) {
            System.err.println("Impossible de s\u00e9lectionner le mode de r\u00e8glement par d\u00e9faut du client.");
            e.printStackTrace();
        }
        SQLTable tablePrefCompte = this.getTable().getTable("PREFS_COMPTE");
        SQLRow rowPrefsCompte = SQLBackgroundTableCache.getInstance().getCacheForTable(tablePrefCompte).getRowFromId(2);
        int idCompteAchat = rowPrefsCompte.getInt("ID_COMPTE_PCE_ACHAT");
        if (idCompteAchat <= 1) {
            try {
                idCompteAchat = ComptePCESQLElement.getIdComptePceDefault("Achats");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        vals.put("ID_COMPTE_PCE_CHARGE", idCompteAchat);
        return vals;
    }
}

