/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.erp.core.supplychain.stock.element.MouvementStockSQLElement;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class ListeDesMouvementsStockAction
extends CreateFrameAbstractAction {
    public ListeDesMouvementsStockAction() {
        this.putValue("Name", "Liste des mouvements de stock");
    }

    @Override
    public JFrame createFrame() {
        SQLElement element = Configuration.getInstance().getDirectory().getElement("MOUVEMENT_STOCK");
        final IListFrame frame = new IListFrame(new ListeAddPanel(element));
        JTable table = frame.getPanel().getListe().getJTable();
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    JPopupMenu menuDroit = new JPopupMenu();
                    menuDroit.add(new AbstractAction("Voir la source"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            MouvementStockSQLElement.showSource(frame.getPanel().getListe().getSelectedId());
                        }
                    });
                    menuDroit.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
                }
            }
        });
        IListFilterDatePanel datePanel = new IListFilterDatePanel(frame.getPanel().getListe(), element.getTable().getField("DATE"), IListFilterDatePanel.getDefaultMap());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 0;
        c.fill = 0;
        c.weightx = 0.0;
        ++c.gridy;
        ++c.gridy;
        c.anchor = 10;
        datePanel.setFilterOnDefault();
        frame.getPanel().add((Component)datePanel, c);
        return frame;
    }
}

