/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.order.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.sql.SQLException;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.core.common.component.TransfertBaseSQLComponent;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.supplychain.order.element.DemandeAchatItemSQLElement;
import org.openconcerto.erp.core.supplychain.order.element.DemandePrixItemTable;
import org.openconcerto.erp.core.supplychain.order.element.DemandePrixSQLElement;
import org.openconcerto.erp.core.supplychain.order.element.DemandePrixSheetXML;
import org.openconcerto.erp.panel.PanelOOSQLComponent;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.JUniqueTextField;
import org.openconcerto.sql.ui.RadioButtons;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.VFlowLayout;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.ui.component.InteractionMode;
import org.openconcerto.utils.ExceptionHandler;

public class DemandePrixSQLComponent
extends TransfertBaseSQLComponent {
    JUniqueTextField field = new JUniqueTextField();
    DemandePrixItemTable table = new DemandePrixItemTable();
    PanelOOSQLComponent panelOO;
    private ElementSQLObject componentPrincipaleAdr;

    public DemandePrixSQLComponent(SQLElement elt) {
        super(elt);
    }

    @Override
    protected void addViews() {
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.setLayout(new GridBagLayout());
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        JPanel addP = ComptaSQLConfElement.createAdditionalPanel();
        this.setAdditionalFieldsPanel(new FormLayouter(addP, 2));
        this.add((Component)addP, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel(this.getLabelFor("NUMERO"), 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.field, c);
        this.addView(this.field, "NUMERO", (Object)"required");
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)new JLabel(this.getLabelFor("DATE"), 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        JDate date = new JDate(true);
        this.add((Component)date, c);
        this.addView(date, "DATE", (Object)"required");
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)new JLabel(this.getLabelFor("ID_FOURNISSEUR"), 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        ElementComboBox boxFournisseur = new ElementComboBox();
        this.add((Component)boxFournisseur, c);
        this.addView(boxFournisseur, "ID_FOURNISSEUR", (Object)"required");
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)new JLabel(this.getLabelFor("DATE_BUTOIRE"), 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        JDate dateButoire = new JDate(false);
        this.add((Component)dateButoire, c);
        this.addView(dateButoire, "DATE_BUTOIRE");
        c.weightx = 0.0;
        c.gridheight = 1;
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 17;
        c.weightx = 0.0;
        JLabel labelObjet = new JLabel(this.getLabelFor("OBJET"), 4);
        this.add((Component)labelObjet, c);
        ++c.gridx;
        ITextArea area = new ITextArea();
        c.weightx = 1.0;
        this.add((Component)area, c);
        this.addView(area, "OBJET");
        RadioButtons radioEtat = new RadioButtons("NOM");
        radioEtat.setLayout(new VFlowLayout());
        radioEtat.setBorder(BorderFactory.createTitledBorder(this.getLabelFor("ID_ETAT_DEMANDE_PRIX")));
        c.gridx = 3;
        c.gridheight = 5;
        c.anchor = 18;
        this.add((Component)radioEtat, c);
        this.addView(radioEtat, "ID_ETAT_DEMANDE_PRIX", (Object)"required");
        c.gridwidth = 0;
        c.gridheight = 1;
        c.gridy += 6;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)this.table, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridheight = 1;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.anchor = 17;
        c.gridwidth = 3;
        c.fill = 2;
        this.add((Component)new TitledSeparator(this.getLabelFor("INFOS")), c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        ITextArea infos = new ITextArea();
        JScrollPane scrollPane = new JScrollPane(infos);
        scrollPane.setBorder(null);
        this.add((Component)scrollPane, c);
        this.addSQLObject(infos, "INFOS");
        this.panelOO = new PanelOOSQLComponent(this);
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 14;
        c.gridx += 3;
        c.weightx = 0.0;
        c.fill = 0;
        c.gridwidth = 0;
        this.add((Component)this.panelOO, c);
    }

    private SQLRowValues getLivraisonAdr(SQLRow rowAffaire) {
        if (rowAffaire != null) {
            SQLRow rowClient = rowAffaire.getForeignRow("ID_CLIENT");
            SQLRow rowAdrL = rowClient.getForeignRow("ID_ADRESSE_L");
            if (rowAdrL == null || rowAdrL.isUndefined()) {
                rowAdrL = rowClient.getForeignRow("ID_ADRESSE");
            }
            SQLRowValues rowVals = rowAdrL.asRowValues();
            rowVals.clearPrimaryKeys();
            return rowVals;
        }
        return new SQLRowValues(this.getTable().getTable("ADRESSE"));
    }

    @Override
    public void select(SQLRowAccessor r) {
        if (this.getTable().contains("LIVRAISON_F") && this.componentPrincipaleAdr != null) {
            boolean bLivraison = r != null && r.getFields().contains("ID_ADRESSE") && !r.isForeignEmpty("ID_ADRESSE");
            this.componentPrincipaleAdr.setEditable(bLivraison ? InteractionMode.READ_WRITE : InteractionMode.DISABLED);
        }
        if (r != null) {
            super.select(r);
            this.field.setIdSelected(r.getID());
            this.table.insertFrom("ID_DEMANDE_PRIX", r.getID());
        } else {
            super.select(r);
        }
    }

    @Override
    public int insert(SQLRow order) {
        int idCommande = this.getSelectedID();
        if (this.field.checkValidation()) {
            idCommande = super.insert(order);
            this.table.updateField("ID_DEMANDE_PRIX", idCommande);
            DemandePrixSheetXML sheet = new DemandePrixSheetXML(this.getTable().getRow(idCommande));
            sheet.createDocumentAsynchronous();
            sheet.showPrintAndExportAsynchronous(true, false, true);
            if (NumerotationAutoSQLElement.getNextNumero(DemandePrixSQLElement.class).equalsIgnoreCase(this.field.getText().trim())) {
                SQLTable tableNum = Configuration.getInstance().getRoot().findTable("NUMEROTATION_AUTO");
                SQLRowValues rowVals = new SQLRowValues(tableNum);
                int val = tableNum.getRow(2).getInt("DMD_PRIX_START");
                rowVals.put("DMD_PRIX_START", new Integer(++val));
                try {
                    rowVals.update(2);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            DemandeAchatItemSQLElement elt = this.getElement().getDirectory().getElement(DemandeAchatItemSQLElement.class);
            elt.updateStatus(this.getTable(), this.getTable().getTable("DEMANDE_PRIX_ELEMENT"), idCommande);
        } else {
            ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de demande existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
        }
        return idCommande;
    }

    @Override
    public void update() {
        if (!this.field.checkValidation()) {
            ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de demande existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
            return;
        }
        super.update();
        this.table.updateField("ID_DEMANDE_PRIX", this.getSelectedID());
        DemandeAchatItemSQLElement elt = this.getElement().getDirectory().getElement(DemandeAchatItemSQLElement.class);
        elt.updateStatus(this.getTable(), this.getTable().getTable("DEMANDE_PRIX_ELEMENT"), this.getSelectedID());
        DemandePrixSheetXML sheet = new DemandePrixSheetXML(this.getTable().getRow(this.getSelectedID()));
        sheet.createDocumentAsynchronous();
        sheet.showPrintAndExportAsynchronous(true, false, true);
    }

    @Override
    protected SQLRowValues createDefaults() {
        SQLRowValues rowVals = new SQLRowValues(this.getTable());
        rowVals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(DemandePrixSQLElement.class));
        if (this.getTable().getUndefinedID() == -1) {
            rowVals.put("ID_ETAT_DEMANDE_PRIX", 2);
        } else {
            SQLRow rowUndef = this.getTable().getRow(this.getTable().getUndefinedID());
            SQLRow foreign = rowUndef.getForeign("ID_ETAT_DEMANDE_PRIX");
            if (foreign != null && !foreign.isUndefined()) {
                rowVals.put("ID_ETAT_DEMANDE_PRIX", foreign.getID());
            } else {
                rowVals.put("ID_ETAT_DEMANDE_PRIX", 2);
            }
        }
        if (this.getTable().contains("LIVRAISON_F") && this.componentPrincipaleAdr != null) {
            this.componentPrincipaleAdr.setEditable(InteractionMode.DISABLED);
        }
        return rowVals;
    }

    public void loadDemandeExistant(int idDemande) {
        Collection myListItem;
        SQLElement demande = Configuration.getInstance().getDirectory().getElement("DEMANDE_PRIX");
        SQLElement demandeElt = Configuration.getInstance().getDirectory().getElement("DEMANDE_PRIX_ELEMENT");
        if (idDemande > 1) {
            SQLRow row = demande.getTable().getRow(idDemande);
            SQLRowValues rowVals = new SQLRowValues(demande.getTable());
            rowVals.put("ID_AFFAIRE", row.getInt("ID_AFFAIRE"));
            rowVals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(DemandePrixSQLElement.class));
            rowVals.put("ID_ETAT_DEMANDE_PRIX", 2);
            rowVals.put("OBJET", row.getObject("OBJET"));
            rowVals.put("ID_COMMERCIAL", row.getObject("ID_COMMERCIAL"));
            this.select(rowVals);
        }
        if ((myListItem = demande.getTable().getRow(idDemande).getReferentRows(demandeElt.getTable())).size() != 0) {
            this.table.getModel().clearRows();
            for (SQLRow rowElt : myListItem) {
                SQLRowValues rowVals = rowElt.createUpdateRow();
                rowVals.clearPrimaryKeys();
                this.table.getModel().addRow(rowVals);
                int rowIndex = this.table.getModel().getRowCount() - 1;
                this.table.getModel().fireTableModelModified(rowIndex);
            }
        } else {
            this.table.getModel().clearRows();
        }
        this.table.getModel().fireTableDataChanged();
        this.table.repaint();
    }

    @Override
    protected RowValuesTable getRowValuesTable() {
        return this.table.getRowValuesTable();
    }

    @Override
    protected void refreshAfterSelect(SQLRowAccessor rSource) {
    }
}

