/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.order.element;

import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.core.common.component.TransfertBaseSQLComponent;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.supplychain.order.component.CommandeSQLComponent;
import org.openconcerto.erp.core.supplychain.order.component.SaisieAchatSQLComponent;
import org.openconcerto.erp.core.supplychain.receipt.component.BonReceptionSQLComponent;
import org.openconcerto.erp.generationDoc.gestcomm.CommandeXmlSheet;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.TreesOfSQLRows;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSelectJoin;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.cc.ITransformer;

public class CommandeSQLElement
extends ComptaSQLConfElement {
    public CommandeSQLElement() {
        super("COMMANDE", "une commande fournisseur", "commandes fournisseur");
        this.getRowActions().addAll(new MouseSheetXmlListeListener(CommandeXmlSheet.class).getRowActions());
        RowAction.PredicateRowAction bonAction = new RowAction.PredicateRowAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<SQLRowValues> selectedRows = IListe.get(e).getSelectedRows();
                CommandeSQLElement.this.transfertBR(selectedRows);
            }
        }, false, "supplychain.order.create.receipt");
        bonAction.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(bonAction);
        RowAction.PredicateRowAction factureAction = new RowAction.PredicateRowAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommandeSQLElement.this.transfertFacture(IListe.get(e).getSelectedRow().getID());
            }
        }, false, "supplychain.order.create.purchase");
        factureAction.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(factureAction);
        RowAction.PredicateRowAction tagValidAction = new RowAction.PredicateRowAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRowValues asRowValues = IListe.get(e).getSelectedRow().asRow().createEmptyUpdateRow();
                asRowValues.put("EN_COURS", Boolean.FALSE);
                try {
                    asRowValues.commit();
                }
                catch (SQLException e1) {
                    ExceptionHandler.handle("Une erreur est survenue pour notifier la commande valider", e1);
                }
            }
        }, false, "supplychain.order.valid");
        tagValidAction.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(tagValidAction);
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        l.add("NOM");
        l.add("DATE");
        l.add("ID_FOURNISSEUR");
        l.add("T_HT");
        l.add("T_TTC");
        l.add("EN_COURS");
        l.add("INFOS");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        l.add("NOM");
        l.add("DATE");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new CommandeSQLComponent();
    }

    public void transfertBR(final List<SQLRowValues> selectedRows) {
        EditFrame f = TransfertBaseSQLComponent.openTransfertFrame(selectedRows, "BON_RECEPTION");
        BonReceptionSQLComponent comp = (BonReceptionSQLComponent)f.getSQLComponent();
        final SQLTable tableElt = comp.getElement().getTable().getTable("BON_RECEPTION_ELEMENT");
        SQLRowValues rowVals = new SQLRowValues(tableElt);
        rowVals.put("QTE_UNITAIRE", null);
        rowVals.put("QTE", null);
        rowVals.put("ID_ARTICLE", null);
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowVals);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                ArrayList<Integer> ids = new ArrayList<Integer>(selectedRows.size());
                for (SQLRowValues sqlRowValues : selectedRows) {
                    ids.add(sqlRowValues.getID());
                }
                SQLSelectJoin joinBR = input.addJoin("RIGHT", tableElt.getTable("BON_RECEPTION_ELEMENT").getField("ID_BON_RECEPTION"));
                SQLSelectJoin joinTR = input.addBackwardJoin("RIGHT", tableElt.getTable("TR_COMMANDE").getField("ID_BON_RECEPTION"), joinBR.getJoinedTable().getAlias());
                joinTR.setWhere(new Where(joinTR.getJoinedTable().getField("ID_COMMANDE"), ids));
                System.err.println(input.asString());
                return input;
            }
        });
        comp.loadQuantity(fetcher.fetch());
    }

    public void transfertFacture(int commandeID) {
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("SAISIE_ACHAT");
        EditFrame editFactureFrame = new EditFrame(elt);
        editFactureFrame.setIconImage(new ImageIcon(Gestion.class.getResource("frameicon.png")).getImage());
        SaisieAchatSQLComponent comp = (SaisieAchatSQLComponent)editFactureFrame.getSQLComponent();
        comp.loadCommande(commandeID);
        editFactureFrame.pack();
        editFactureFrame.setState(0);
        editFactureFrame.setVisible(true);
    }

    @Override
    protected void archive(TreesOfSQLRows trees, boolean cutLinks) throws SQLException {
        for (SQLRow row : trees.getRows()) {
            SQLElement eltMvtStock = Configuration.getInstance().getDirectory().getElement("MOUVEMENT_STOCK");
            SQLSelect sel = new SQLSelect();
            sel.addSelect(eltMvtStock.getTable().getField("ID"));
            Where w = new Where((FieldRef)eltMvtStock.getTable().getField("IDSOURCE"), "=", row.getID());
            Where w2 = new Where((FieldRef)eltMvtStock.getTable().getField("SOURCE"), "=", (Object)this.getTable().getName());
            sel.setWhere(w.and(w2));
            List l = (List)eltMvtStock.getTable().getBase().getDataSource().execute(sel.asString(), new ArrayListHandler());
            if (l == null) continue;
            int i = 0;
            while (i < l.size()) {
                Object[] tmp = (Object[])l.get(i);
                eltMvtStock.archive(((Number)tmp[0]).intValue());
                ++i;
            }
        }
        super.archive(trees, cutLinks);
    }
}

