/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.quote.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.jopendocument.link.OOConnexion;
import org.openconcerto.erp.action.CreateListFrameAbstractAction;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.PanelFrame;
import org.openconcerto.erp.core.sales.quote.element.DevisSQLElement;
import org.openconcerto.erp.core.sales.quote.report.DevisTextSheet;
import org.openconcerto.erp.core.sales.quote.ui.ListeDesDevisPanel;
import org.openconcerto.erp.generationDoc.DocumentLocalStorageManager;
import org.openconcerto.erp.generationDoc.SheetUtils;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.utils.ExceptionHandler;

public class ListeDesDevisAction
extends CreateListFrameAbstractAction
implements MouseListener {
    DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm");
    IListFrame frame = null;
    final DevisSQLElement element = (DevisSQLElement)Configuration.getInstance().getDirectory().getElement("DEVIS");

    public ListeDesDevisAction() {
        String pluralName = this.element.getPluralName();
        this.putValue("Name", "Liste des " + pluralName);
    }

    @Override
    public String getTableName() {
        return "DEVIS";
    }

    @Override
    public JFrame createFrame() {
        String pluralName = this.element.getPluralName();
        PanelFrame frame2 = new PanelFrame(new ListeDesDevisPanel(), "Liste des " + pluralName);
        return frame2;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int selectedId = this.frame.getPanel().getListe().getSelectedId();
        if (selectedId > 1 && e.getButton() == 3) {
            final SQLRow row = this.frame.getPanel().getListe().fetchSelectedRow();
            JPopupMenu menu = new JPopupMenu();
            final DevisTextSheet s = new DevisTextSheet(row);
            AbstractAction actionOpen = new AbstractAction("Voir le document"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    s.generate(false, false, "");
                    s.showDocument();
                }
            };
            JMenuItem openItem = new JMenuItem(actionOpen);
            openItem.setFont(openItem.getFont().deriveFont(1));
            menu.add(openItem);
            File outpuDirectory = DocumentLocalStorageManager.getInstance().getDocumentOutputDirectory(s.getTemplateId());
            List<File> files = SheetUtils.getHistorique(s.getFileName(), outpuDirectory);
            if (files.size() > 0) {
                JMenu item = new JMenu("Historique");
                int i = 0;
                for (final File file : files) {
                    JMenuItem subItem = new JMenuItem("Version " + i + " du " + this.dateFormat.format(new Date(file.lastModified())));
                    subItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (file.exists()) {
                                try {
                                    OOConnexion ooConnexion = ComptaPropsConfiguration.getOOConnexion();
                                    if (ooConnexion == null) {
                                        return;
                                    }
                                    ooConnexion.loadDocument(file, false);
                                }
                                catch (LinkageError ex) {
                                    JOptionPane.showMessageDialog(new JFrame(), "Merci d'installer OpenOffice ou LibreOffice");
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    ExceptionHandler.handle("Impossible de charger le document OpenOffice", ex);
                                }
                            }
                        }
                    });
                    ++i;
                    item.add(subItem);
                }
                menu.add(item);
            }
            AbstractAction actionAcc = new AbstractAction("Marquer comme accept\u00e9"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SQLRowValues rowVals = IListe.get(e).fetchSelectedRow().createEmptyUpdateRow();
                    rowVals.put("ID_ETAT_DEVIS", 4);
                    try {
                        rowVals.update();
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                    IListe.get(e).fetchSelectedRow().getTable().fireTableModified(IListe.get(e).getSelectedId());
                }
            };
            menu.add(actionAcc);
            AbstractAction actionRefus = new AbstractAction("Marquer comme refus\u00e9"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SQLRowValues rowVals = IListe.get(e).fetchSelectedRow().createEmptyUpdateRow();
                    rowVals.put("ID_ETAT_DEVIS", 3);
                    try {
                        rowVals.update();
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                    IListe.get(e).fetchSelectedRow().getTable().fireTableModified(IListe.get(e).getSelectedId());
                }
            };
            menu.add(actionRefus);
            AbstractAction actionTransfert = new AbstractAction("Transf\u00e9rer en facture"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ListeDesDevisAction.this.element.transfertFacture(row.getID());
                }
            };
            menu.add(actionTransfert);
            AbstractAction actionPrint = new AbstractAction("Imprimer"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    s.fastPrintDocument();
                }
            };
            menu.add(actionPrint);
            menu.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

