/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.ui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import org.openconcerto.erp.core.common.ui.DeviseNiceTableCellRenderer;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.ui.table.AlternateTableCellRenderer;
import org.openconcerto.utils.CollectionUtils;

public class QtyToDeliverRowValuesRenderer
extends DeviseNiceTableCellRenderer {
    public static final Color red = new Color(255, 31, 52);
    public static final Color redLightGrey = new Color(240, 65, 85);
    public static final Color orange = new Color(243, 125, 75);
    public static final Color orangeGrey = new Color(222, 107, 47);
    public static final Color light = new Color(232, 238, 250);
    public static final Color lightGrey = new Color(211, 220, 222);
    public static final Color lightBlack = new Color(192, 192, 192);
    public static final Color lightBlackGrey = new Color(155, 155, 155);

    public QtyToDeliverRowValuesRenderer() {
        AlternateTableCellRenderer.setBGColorMap(this, CollectionUtils.createMap(lightBlack, lightBlackGrey, red, redLightGrey, orange, orangeGrey));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (table instanceof RowValuesTable) {
            ((JLabel)comp).setHorizontalAlignment(4);
            RowValuesTableModel model = ((RowValuesTable)table).getRowValuesTableModel();
            SQLRowValues rowVals = model.getRowValuesAt(row);
            Number qte = (Number)rowVals.getObject("QTE");
            Number qteL = (Number)rowVals.getObject("QTE_LIVREE");
            if (qte != null && qteL != null && qte.intValue() <= 0) {
                comp.setBackground(red);
            }
        }
        return comp;
    }
}

