/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.openconcerto.erp.core.sales.product.model.PriceByQty;
import org.openconcerto.erp.core.sales.product.model.ProductHelper;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.DecimalUtils;

public class ProductComponent {
    private final SQLRowAccessor product;
    private BigDecimal qty;
    private final ProductHelper helper;

    public ProductComponent(SQLRowAccessor product, BigDecimal qty) {
        this.product = product;
        this.qty = qty;
        this.helper = new ProductHelper(product.getTable().getDBRoot());
    }

    public SQLRowAccessor getProduct() {
        return this.product;
    }

    public BigDecimal getQty() {
        return this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public void addQty(BigDecimal b) {
        this.qty = this.qty.add(b);
    }

    public BigDecimal getPRC(Date d) {
        if (this.product.getTable().getDBRoot().contains("ARTICLE_PRIX_REVIENT")) {
            Calendar date;
            BigDecimal result = null;
            SQLTable table = this.product.getTable().getDBRoot().getTable("ARTICLE_PRIX_REVIENT");
            Collection prcs = this.product.asRow().getReferentRows(table);
            Date lastDate = null;
            ArrayList<PriceByQty> prices = new ArrayList<PriceByQty>();
            for (SQLRow row : prcs) {
                date = Calendar.getInstance();
                if (row.getObject("DATE") != null) {
                    date = row.getDate("DATE");
                    lastDate = date.getTime();
                }
                prices.add(new PriceByQty(row.getLong("QTE"), row.getBigDecimal("PRIX"), date.getTime()));
            }
            result = PriceByQty.getPriceForQty(this.qty.setScale(0, RoundingMode.HALF_UP).intValue(), prices, d);
            if (result == null) {
                result = PriceByQty.getPriceForQty(this.qty.setScale(0, RoundingMode.HALF_UP).intValue(), prices, lastDate);
            }
            if (result == null) {
                SQLTable tableATF = this.product.getTable().getDBRoot().getTable("ARTICLE_TARIF_FOURNISSEUR");
                Collection atfs = this.product.asRow().getReferentRows(tableATF);
                Date lastDateATF = null;
                ArrayList<PriceByQty> pricesATF = new ArrayList<PriceByQty>();
                for (SQLRow row : atfs) {
                    date = Calendar.getInstance();
                    if (row.getObject("DATE_PRIX") != null) {
                        date = row.getDate("DATE_PRIX");
                        lastDateATF = date.getTime();
                    }
                    pricesATF.add(new PriceByQty(row.getLong("QTE"), this.helper.getEnumPrice(row, ProductHelper.SupplierPriceField.COEF_TRANSPORT_SIEGE), date.getTime()));
                }
                result = PriceByQty.getPriceForQty(this.qty.setScale(0, RoundingMode.HALF_UP).intValue(), pricesATF, d);
                if (result == null && (result = PriceByQty.getPriceForQty(this.qty.setScale(0, RoundingMode.HALF_UP).intValue(), pricesATF, lastDateATF)) == null) {
                    result = BigDecimal.ZERO;
                }
            }
            return result;
        }
        return null;
    }

    public static ProductComponent createFrom(SQLRowAccessor rowVals) {
        return ProductComponent.createFrom(rowVals, 1);
    }

    public static ProductComponent createFrom(SQLRowAccessor rowVals, int qteMultiple) {
        int qteMult = rowVals.getTable().getName().equalsIgnoreCase("BON_DE_LIVRAISON_ELEMENT") ? rowVals.getInt("QTE_LIVREE") : rowVals.getInt("QTE");
        int qte = qteMult * qteMultiple;
        BigDecimal qteUV = rowVals.getBigDecimal("QTE_UNITAIRE");
        BigDecimal qteFinal = qteUV.multiply(new BigDecimal(qte), DecimalUtils.HIGH_PRECISION);
        return new ProductComponent(rowVals.getForeign("ID_ARTICLE"), qteFinal);
    }
}

