/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openconcerto.erp.core.sales.pos.POSConfiguration;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.RegisterState;
import org.openconcerto.erp.core.sales.pos.ui.CaisseControler;
import org.openconcerto.erp.core.sales.pos.ui.CaisseListener;
import org.openconcerto.erp.core.sales.pos.ui.TicketCellRenderer;
import org.openconcerto.ui.touch.ScrollableList;
import org.openconcerto.utils.Pair;

public class TicketPanel
extends JPanel
implements CaisseListener {
    private static final DateFormat DF = new SimpleDateFormat("' le' EEEE d MMMM \u00e0 H:mm:ss");
    private final Image bg;
    private final ListModel dataModel;
    private final List<ListDataListener> listeners = new ArrayList<ListDataListener>();
    JLabel lTotal = new JLabel("", 4);
    JLabel lNumero = new JLabel("", 2);
    private final CaisseControler controler;
    private final ScrollableList list;

    TicketPanel(final CaisseControler controler) {
        this.controler = controler;
        this.controler.addCaisseListener(this);
        this.setOpaque(false);
        this.bg = new ImageIcon(TicketPanel.class.getResource("ticket.png")).getImage();
        this.setLayout(null);
        this.dataModel = new ListModel(){

            @Override
            public void addListDataListener(ListDataListener l) {
                TicketPanel.this.listeners.add(l);
            }

            public Object getElementAt(int index) {
                return controler.getItems().get(index);
            }

            @Override
            public int getSize() {
                return controler.getItems().size();
            }

            @Override
            public void removeListDataListener(ListDataListener l) {
                TicketPanel.this.listeners.remove(l);
            }
        };
        this.list = new ScrollableList(this.dataModel){
            private final TicketCellRenderer renderer;
            {
                this.renderer = new TicketCellRenderer();
            }

            @Override
            public void paintCell(Graphics g, Object value, int index, boolean isSelected, int posY) {
                g.translate(0, posY);
                this.renderer.paint(g, TicketPanel.this.list, value, index, isSelected);
                g.translate(0, -posY);
            }
        };
        this.list.setOpaque(false);
        this.list.setSize(276, 450);
        this.list.setFixedCellHeight(40);
        this.list.setLocation(68, 18);
        this.add(this.list);
        this.lTotal.setSize(266, 32);
        this.lTotal.setLocation(68, 468);
        this.lTotal.setFont(new Font("Arial", 1, 18));
        this.add(this.lTotal);
        this.lNumero.setSize(266, 32);
        this.lNumero.setLocation(68, 500);
        this.lNumero.setForeground(Color.DARK_GRAY);
        this.lNumero.setFont(new Font("Arial", 1, 12));
        this.add(this.lNumero);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Object selectedValue;
                if (!e.getValueIsAdjusting() && (selectedValue = TicketPanel.this.list.getSelectedValue()) != null) {
                    Article a = (Article)((Pair)selectedValue).getFirst();
                    controler.setArticleSelected(a);
                    controler.setArticleSelected(a);
                }
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.drawImage(this.bg, 0, 0, null);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        try {
            String InfoCaisseVendeur = "Caisse " + POSConfiguration.getInstance().getPosID() + "  Vendeur " + POSConfiguration.getInstance().getUserID();
            g.setColor(new Color(230, 230, 230));
            g.setFont(this.getFont().deriveFont(28.0f));
            g.drawString(InfoCaisseVendeur, 20, this.getHeight() - 50);
            g.setColor(Color.LIGHT_GRAY);
            g.setFont(this.getFont().deriveFont(18.0f));
            RegisterState registerState = this.controler.getCaisseFrame().getFiles().getLastLog().getRegisterState();
            g.drawString("Caisse " + (registerState.getStatus() == RegisterState.Status.OPEN ? "ouverte" : "ferm\u00e9e") + registerState.formatDate(DF), 20, this.getHeight() - 25);
        }
        catch (Exception e) {
            POSConfiguration.getLogger().log(Level.WARNING, "Couldn't find register state", e);
        }
        super.paintComponent(g);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(480, 550);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(480, 707);
    }

    public void fire() {
        for (ListDataListener l : this.listeners) {
            l.contentsChanged(new ListDataEvent(this, 0, 0, this.listeners.size()));
        }
    }

    @Override
    public void caisseStateChanged() {
        Article articleSelected = this.controler.getArticleSelected();
        for (ListDataListener l : this.listeners) {
            l.contentsChanged(new ListDataEvent(this, 0, 0, this.listeners.size()));
        }
        this.lTotal.setText("TOTAL:  " + TicketCellRenderer.centsToString(this.controler.getTotal()) + " \u20ac");
        this.lNumero.setText("Ticket " + this.controler.getTicketNumber());
        if (articleSelected == null) {
            this.list.clearSelection();
            return;
        }
        try {
            if (this.list.getSelectedValue() != null && articleSelected != null && articleSelected.equals(((Pair)this.list.getSelectedValue()).getFirst())) {
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (articleSelected != null) {
            int i = 0;
            while (i < this.dataModel.getSize()) {
                Pair item = (Pair)this.dataModel.getElementAt(i);
                if (((Article)item.getFirst()).equals(articleSelected)) {
                    this.list.setSelectedValue(item, true);
                    break;
                }
                ++i;
            }
        }
    }
}

