/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.pos.POSConfiguration;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.Categorie;
import org.openconcerto.erp.core.sales.pos.model.Paiement;
import org.openconcerto.erp.core.sales.pos.model.ReceiptCode;
import org.openconcerto.erp.core.sales.pos.model.Ticket;
import org.openconcerto.erp.core.sales.pos.ui.TextAreaTicketPrinter;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.DecimalUtils;

public class TextAreaTicketPanel
extends JPanel {
    public TextAreaTicketPanel(SQLRow row) {
        super(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        final Ticket ticket = this.createTicket(row);
        JButton button = new JButton("Imprimer");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                POSConfiguration.getInstance().print(ticket);
            }
        });
        c.fill = 0;
        c.anchor = 10;
        this.add((Component)button, c);
        c.anchor = 17;
        c.fill = 2;
        JSeparator sep = new JSeparator();
        ++c.gridy;
        c.weightx = 1.0;
        this.add((Component)sep, c);
        TextAreaTicketPrinter comp = new TextAreaTicketPrinter();
        ++c.gridy;
        c.weighty = 1.0;
        this.add((Component)comp, c);
        ticket.print(comp, POSConfiguration.getInstance().getTicketPrinterConfiguration1().getTicketWidth());
    }

    private Ticket createTicket(SQLRow row) {
        Ticket t;
        try {
            t = new Ticket(new ReceiptCode(row.getString("NUMERO")), row.getDate("DATE"), row.getString("FILE_HASH_PREVIOUS"));
        }
        catch (ParseException e) {
            throw new IllegalStateException("Couldn't parse " + row, e);
        }
        SQLElement eltEncaisser = Configuration.getInstance().getDirectory().getElement("ENCAISSER_MONTANT");
        Collection l = row.getReferentRows(eltEncaisser.getTable());
        for (SQLRow row2 : l) {
            long montant = row2.getLong("MONTANT");
            SQLRow rowMode = row2.getForeign("ID_MODE_REGLEMENT");
            int type = 3;
            if (rowMode.getInt("ID_TYPE_REGLEMENT") == 3) {
                type = 3;
            } else if (rowMode.getInt("ID_TYPE_REGLEMENT") == 2) {
                type = 2;
            } else if (rowMode.getInt("ID_TYPE_REGLEMENT") == 4) {
                type = 1;
            }
            Paiement p = new Paiement(type);
            p.setMontantInCents((int)montant);
            t.addPaiement(p);
        }
        SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE_ELEMENT");
        Collection l2 = row.getReferentRows(eltArticle.getTable());
        Categorie c = new Categorie("");
        for (SQLRow row2 : l2) {
            Article a = new Article(c, row2.getString("NOM"), row2.getInt("ID_ARTICLE"));
            BigDecimal ht = (BigDecimal)row2.getObject("PV_HT");
            a.setPriceWithoutTax(ht);
            int idTaxe = row2.getInt("ID_TAXE");
            float tva = TaxeCache.getCache().getTauxFromId(idTaxe).floatValue();
            a.setPriceWithTax(ht.multiply(new BigDecimal(1.0 + (double)tva / 100.0), DecimalUtils.HIGH_PRECISION));
            a.setIdTaxe(idTaxe);
            t.addArticle(a);
            t.setArticleCount(a, row2.getInt("QTE"));
        }
        return t;
    }
}

