/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import org.openconcerto.erp.core.sales.pos.POSConfiguration;
import org.openconcerto.erp.core.sales.pos.io.DefaultTicketPrinter;
import org.openconcerto.erp.core.sales.pos.io.Printable;
import org.openconcerto.erp.core.sales.pos.io.TicketPrinter;
import org.openconcerto.erp.core.sales.pos.model.Paiement;
import org.openconcerto.erp.core.sales.pos.model.RegisterLog;
import org.openconcerto.erp.core.sales.pos.model.RegisterState;
import org.openconcerto.erp.core.sales.pos.model.Ticket;

abstract class RegisterSummary
implements Printable {
    private final String name;
    private final RegisterLog log;

    protected RegisterSummary(String name, RegisterLog log) {
        this.name = name;
        this.log = log;
    }

    public boolean isPrintingTicketsList() {
        return true;
    }

    public final RegisterLog getLog() {
        return this.log;
    }

    public abstract String getLabel();

    protected abstract List<Ticket> getReceipts() throws ParseException;

    @Override
    public void print(TicketPrinter prt, int ticketWidth) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/YYYY \u00e0 HH:mm:ss");
        String title = String.valueOf(this.name) + " de la caisse " + this.getLog().getRegisterID();
        prt.clearBuffer(title);
        try {
            List<Ticket> receipts = this.getReceipts();
            LinkedHashMap typesByReceipt = new LinkedHashMap();
            LinkedHashMap<Ticket, BigDecimal> paidByReceipt = new LinkedHashMap<Ticket, BigDecimal>();
            LinkedHashMap<Ticket, BigDecimal> valueByReceipt = new LinkedHashMap<Ticket, BigDecimal>();
            TreeMap totalByType = new TreeMap();
            BigDecimal total = BigDecimal.ZERO;
            BigDecimal totalPaid = BigDecimal.ZERO;
            for (Ticket t : receipts) {
                int receiptInCents = t.getTotalInCents();
                BigDecimal receiptValue = BigDecimal.valueOf(receiptInCents).movePointLeft(2);
                BigDecimal receiptPaid = BigDecimal.ZERO;
                TreeMap byType = new TreeMap();
                for (Paiement p : t.getPaiements()) {
                    BigDecimal paid = BigDecimal.valueOf(p.getMontantInCents()).movePointLeft(2);
                    receiptPaid = receiptPaid.add(paid);
                    RegisterSummary.addInMap(byType, p.getTypeAsString(), paid);
                    RegisterSummary.addInMap(totalByType, p.getTypeAsString(), paid);
                }
                typesByReceipt.put(t, byType);
                valueByReceipt.put(t, receiptValue);
                paidByReceipt.put(t, receiptPaid);
                total = total.add(receiptValue);
                totalPaid = totalPaid.add(receiptPaid);
            }
            BigDecimal rendu = totalPaid.subtract(total);
            prt.addToBuffer(title, 2);
            prt.addToBuffer("");
            prt.addToBuffer("Edit\u00e9 le " + dateFormat.format(new Date()));
            RegisterState registerState = this.getLog().getRegisterState();
            prt.addToBuffer(String.valueOf(registerState.getStatus() == RegisterState.Status.OPEN ? "Ouvert" : "Ferm\u00e9") + " le " + registerState.formatDate(dateFormat));
            prt.addToBuffer("");
            prt.addToBuffer("");
            prt.addToBuffer("Tickets de caisse", 2);
            prt.addToBuffer("");
            Paiement espece = new Paiement(1);
            prt.addToBuffer(DefaultTicketPrinter.formatSides(ticketWidth, "Total des ventes", total.toPlainString()), 1);
            for (Map.Entry e2 : totalByType.entrySet()) {
                String typePayment = (String)e2.getKey();
                if (typePayment.equals(espece.getTypeAsString())) {
                    BigDecimal value = (BigDecimal)e2.getValue();
                    value = value.subtract(rendu);
                    prt.addToBuffer(DefaultTicketPrinter.formatSides(ticketWidth, "      " + typePayment, value.toPlainString()));
                    continue;
                }
                prt.addToBuffer(DefaultTicketPrinter.formatSides(ticketWidth, "      " + typePayment, ((BigDecimal)e2.getValue()).toPlainString()));
            }
            prt.addToBuffer(DefaultTicketPrinter.formatSides(ticketWidth, "Total des paiements", totalPaid.toPlainString()), 1);
            for (Map.Entry e2 : totalByType.entrySet()) {
                prt.addToBuffer(DefaultTicketPrinter.formatSides(ticketWidth, "      " + (String)e2.getKey(), ((BigDecimal)e2.getValue()).toPlainString()));
            }
            prt.addToBuffer("");
            prt.addToBuffer(DefaultTicketPrinter.formatSides(ticketWidth, "Total rendu", rendu.toPlainString()), 1);
            prt.addToBuffer("");
            prt.addToBuffer(DefaultTicketPrinter.formatSides(ticketWidth, "Total TTC (Euros)", total.toPlainString()), 1);
            prt.addToBuffer(DefaultTicketPrinter.formatSides(ticketWidth, "Nombre de tickets", "" + receipts.size()));
            long avg = receipts.isEmpty() ? 0L : total.movePointRight(2).longValueExact() / (long)receipts.size();
            prt.addToBuffer(DefaultTicketPrinter.formatSides(ticketWidth, "Panier moyen (Euros)", BigDecimal.valueOf(avg).movePointLeft(2).toPlainString()));
            prt.addToBuffer("");
            if (this.isPrintingTicketsList()) {
                prt.addToBuffer("");
                prt.addToBuffer("Liste des tickets", 2);
                prt.addToBuffer("");
                for (Map.Entry e : typesByReceipt.entrySet()) {
                    Ticket t = (Ticket)e.getKey();
                    BigDecimal receiptValue = (BigDecimal)valueByReceipt.get(t);
                    prt.addToBuffer(DefaultTicketPrinter.formatSides(ticketWidth, t.getCode(), receiptValue.toPlainString()), 1);
                    for (Map.Entry e2 : ((Map)e.getValue()).entrySet()) {
                        prt.addToBuffer(DefaultTicketPrinter.formatSides(ticketWidth, " " + (String)e2.getKey(), ((BigDecimal)e2.getValue()).toPlainString()));
                    }
                    BigDecimal receiptChange = ((BigDecimal)paidByReceipt.get(t)).subtract(receiptValue);
                    if (receiptChange.signum() != 0) {
                        prt.addToBuffer(DefaultTicketPrinter.formatSides(ticketWidth, " rendu", receiptChange.toPlainString()));
                    }
                    prt.addToBuffer("");
                }
            }
        }
        catch (Exception e) {
            POSConfiguration.getLogger().log(Level.WARNING, "Couldn't fill " + this.name, e);
            prt.addToBuffer("Erreur");
        }
        try {
            prt.printBuffer();
        }
        catch (Exception e) {
            POSConfiguration.getLogger().log(Level.WARNING, "Couldn't print " + this.name, e);
        }
    }

    private static final <K> void addInMap(Map<K, BigDecimal> m, K key, BigDecimal val) {
        BigDecimal prev = m.get(key);
        m.put(key, prev == null ? val : prev.add(val));
    }
}

