/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.model;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.TotalCalculator;
import org.openconcerto.erp.core.customerrelationship.customer.element.CompteClientTransactionSQLELement;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.pos.POSConfiguration;
import org.openconcerto.erp.core.sales.pos.io.DefaultTicketPrinter;
import org.openconcerto.erp.core.sales.pos.io.Printable;
import org.openconcerto.erp.core.sales.pos.io.TicketPrinter;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.Categorie;
import org.openconcerto.erp.core.sales.pos.model.Client;
import org.openconcerto.erp.core.sales.pos.model.Paiement;
import org.openconcerto.erp.core.sales.pos.model.ReceiptCode;
import org.openconcerto.erp.core.sales.pos.model.RegisterFiles;
import org.openconcerto.erp.core.sales.pos.model.TicketLine;
import org.openconcerto.erp.core.sales.pos.ui.TicketCellRenderer;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.generationEcritures.GenerationMvtVirement;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.Pair;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.XMLDateFormat;

public class Ticket
implements Printable {
    private static final XMLDateFormat DATE_FMT = new XMLDateFormat();
    private final List<Paiement> paiements = new ArrayList<Paiement>();
    private final List<Pair<Article, Integer>> items = new ArrayList<Pair<Article, Integer>>();
    private Calendar creationCal;
    private Client client = Client.NONE;
    private final int number;
    private final String previousHash;
    private boolean additionnalCopyRequested = false;
    private final int caisseNumber;
    private static final SQLTable tableArticle = Configuration.getInstance().getRoot().findTable("ARTICLE");

    public static Ticket getTicketFromCode(String code, RegisterFiles registerFiles) {
        try {
            ReceiptCode receiptCode = new ReceiptCode(code);
            Path receiptFile = registerFiles.getReceiptFile(receiptCode);
            if (receiptFile != null && Files.exists(receiptFile, new LinkOption[0])) {
                return Ticket.parseFile(receiptFile.toFile());
            }
            return Ticket.parseFile(receiptCode.getFile());
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public Client getClient() {
        return this.client;
    }

    public static Ticket parseFile(File file) {
        return Ticket.parseFile(file, RegisterFiles.HashMode.REQUIRED);
    }

    public static Ticket parseFile(File file, RegisterFiles.HashMode hashMode) {
        if (!file.exists()) {
            return null;
        }
        try {
            Document document = RegisterFiles.parse(file.toPath(), hashMode);
            Element root = document.getRootElement();
            ReceiptCode receiptCode = new ReceiptCode(root.getAttributeValue("code"));
            String creationDateAttr = root.getAttributeValue("creationDate");
            Calendar c = (Calendar)receiptCode.getDay().clone();
            if (creationDateAttr == null) {
                String h = root.getAttributeValue("hour");
                String m = root.getAttributeValue("minute");
                c.set(11, Integer.parseInt(h));
                c.set(12, Integer.parseInt(m));
            } else {
                c.setTime((Date)DATE_FMT.parseObject(creationDateAttr));
            }
            String client = root.getAttributeValue("clientID", "1");
            Ticket t = new Ticket(receiptCode, c, root.getAttributeValue("previousHash"));
            t.setClient(new Client(Integer.parseInt(client), "", BigDecimal.ZERO));
            List<Element> children = root.getChildren("article");
            for (Element element : children) {
                int qte = Integer.parseInt(element.getAttributeValue("qte"));
                BigDecimal prix_unitaire_cents_ht = new BigDecimal(element.getAttributeValue("prixHT"));
                int idTaxe = Integer.parseInt(element.getAttributeValue("idTaxe"));
                BigDecimal prix_unitaire_cents = new BigDecimal(element.getAttributeValue("prix"));
                String categorie = element.getAttributeValue("categorie");
                String name = element.getValue();
                String codebarre = element.getAttributeValue("codebarre");
                String codeArt = element.getAttributeValue("code");
                Categorie cat = new Categorie(categorie);
                String valueID = element.getAttributeValue("id");
                int id = valueID == null || valueID.trim().length() == 0 ? tableArticle.getUndefinedID() : Integer.parseInt(valueID);
                Article art = new Article(cat, name, id);
                art.setPriceWithTax(prix_unitaire_cents);
                art.setCode(codeArt);
                art.setPriceWithoutTax(prix_unitaire_cents_ht);
                art.setIdTaxe(idTaxe);
                art.setBarCode(codebarre);
                Pair<Article, Integer> line = new Pair<Article, Integer>(art, qte);
                t.items.add(line);
            }
            List<Element> payChildren = root.getChildren("paiement");
            for (Element element : payChildren) {
                String type = element.getAttributeValue("type");
                int montant_cents = Integer.parseInt(element.getAttributeValue("montant"));
                if (montant_cents == 0) continue;
                int tp = 1;
                if (type.equals("CB")) {
                    tp = 3;
                } else if (type.equals("CHEQUE")) {
                    tp = 2;
                } else if (type.equals("ESPECES")) {
                    tp = 1;
                } else if (type.equals("SOLDE")) {
                    tp = 4;
                }
                Paiement p = new Paiement(tp);
                p.setMontantInCents(montant_cents);
                t.paiements.add(p);
            }
            return t;
        }
        catch (Exception e) {
            System.err.println("Error with ticket : " + file + " : " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public Ticket(int caisse, int number, String previousHash) {
        this(new ReceiptCode(caisse, Calendar.getInstance(), number), null, previousHash);
    }

    public Ticket(ReceiptCode code, Calendar creationDate, String previousHash) {
        this.caisseNumber = code.getCaisseNb();
        this.number = code.getDayIndex();
        this.previousHash = previousHash;
        this.setCreationCal(creationDate);
    }

    public final String getPreviousHash() {
        return this.previousHash;
    }

    public final ReceiptCode getReceiptCode() {
        return new ReceiptCode(this.getCaisseNumber(), this.getCreationCal(), this.getNumber());
    }

    public String getCode() {
        return this.getReceiptCode().getCode();
    }

    public int getNumber() {
        return this.number;
    }

    final int getCaisseNumber() {
        return this.caisseNumber;
    }

    public String save(RegisterFiles files, SQLElementDirectory dir) throws IOException, SQLException {
        String fileHash = files.save(this);
        this.handleSolde(dir);
        return fileHash;
    }

    final byte[] saveToFile(Path f) throws IOException {
        Calendar c = this.getCreationCal();
        Element topLevel = new Element("ticket");
        topLevel.setAttribute(new Attribute("code", this.getCode()));
        if (this.getPreviousHash() != null) {
            topLevel.setAttribute("previousHash", this.getPreviousHash());
        }
        topLevel.setAttribute("creationDate", DATE_FMT.format(c.getTime()));
        topLevel.setAttribute("clientID", String.valueOf(this.client.getId()));
        for (Pair<Article, Integer> item : this.items) {
            Element e = new Element("article");
            e.setAttribute("qte", String.valueOf(item.getSecond()));
            e.setAttribute("prix", String.valueOf(item.getFirst().getPriceWithTax()));
            e.setAttribute("prixHT", String.valueOf(item.getFirst().getPriceWithoutTax()));
            e.setAttribute("idTaxe", String.valueOf(item.getFirst().getIdTaxe()));
            e.setAttribute("categorie", item.getFirst().getCategorie().getName());
            e.setAttribute("codebarre", item.getFirst().getBarCode());
            e.setAttribute("code", item.getFirst().getCode());
            e.setAttribute("id", String.valueOf(item.getFirst().getId()));
            e.setText(item.getFirst().getName());
            topLevel.addContent(e);
        }
        for (Paiement paiement : this.paiements) {
            int montantInCents = paiement.getMontantInCents();
            if (montantInCents == 0) continue;
            Element e = new Element("paiement");
            String type = "";
            if (paiement.getType() == 3) {
                type = "CB";
            } else if (paiement.getType() == 2) {
                type = "CHEQUE";
            } else if (paiement.getType() == 1) {
                type = "ESPECES";
            } else if (paiement.getType() == 4) {
                type = "SOLDE";
            }
            e.setAttribute("type", type);
            e.setAttribute("montant", String.valueOf(montantInCents));
            topLevel.addContent(e);
        }
        return RegisterFiles.save(new Document(topLevel), f);
    }

    private final void handleSolde(SQLElementDirectory dir) throws SQLException {
        final SQLTable table = dir.getElement(CompteClientTransactionSQLELement.class).getTable();
        SQLTable tablePrefCompte = table.getDBRoot().findTable("PREFS_COMPTE");
        final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);
        final Calendar c = this.getCreationCal();
        SQLUtils.executeAtomic(table.getDBSystemRoot().getDataSource(), new SQLUtils.SQLFactory<Object>(){

            @Override
            public Object create() throws SQLException {
                for (Paiement paiement : Ticket.this.paiements) {
                    int montantInCents = paiement.getMontantInCents();
                    if (montantInCents <= 0 || paiement.getType() != 4) continue;
                    SQLRowValues rowValsTransact = new SQLRowValues(table);
                    rowValsTransact.put("ID_CLIENT", Ticket.this.client.getId());
                    rowValsTransact.put("DATE", c.getTime());
                    BigDecimal amountTransaction = new BigDecimal(montantInCents).movePointLeft(2);
                    rowValsTransact.put("MONTANT", amountTransaction.negate());
                    SQLRow rowTransact = rowValsTransact.commit();
                    GenerationEcritures ecr = new GenerationEcritures();
                    int idMvt = ecr.getNewMouvement(table.getName(), rowTransact.getID(), 1, "Transact. " + Ticket.this.client.getFullName() + " Ticket " + Ticket.this.getCode());
                    rowTransact = rowTransact.createEmptyUpdateRow().put("ID_MOUVEMENT", idMvt).commit();
                    SQLTable tableClient = table.getForeignTable("ID_CLIENT");
                    SQLRow row = tableClient.getRow(Ticket.this.client.getId());
                    BigDecimal solde = row.getBigDecimal("SOLDE_COMPTE");
                    BigDecimal nouveauSolde = solde.subtract(amountTransaction);
                    row.createEmptyUpdateRow().put("SOLDE_COMPTE", nouveauSolde).commit();
                    int idCompteAvanceClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_AVANCE_CLIENT");
                    int idCompteClient = row.getInt("ID_COMPTE_PCE");
                    if (idCompteAvanceClient <= 1) {
                        idCompteAvanceClient = ComptePCESQLElement.getIdComptePceDefault("AvanceClients");
                    }
                    if (idCompteClient <= 1 && (idCompteClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_CLIENT")) <= 1) {
                        idCompteClient = ComptePCESQLElement.getIdComptePceDefault("Clients");
                    }
                    new GenerationMvtVirement(idCompteAvanceClient, idCompteClient, 0L, montantInCents, "Utilisation compte client", c.getTime(), 3, "Ticket N\u00b0" + Ticket.this.getCode()).genereMouvement();
                }
                return null;
            }
        });
    }

    @Override
    public void print(TicketPrinter prt, int ticketWidth) {
        int maxWidth = ticketWidth;
        int MAX_PRICE_WIDTH = 8;
        int MAX_QTE_WIDTH = 5;
        prt.clearBuffer("receipt " + this.getCode());
        List<TicketLine> headers = POSConfiguration.getInstance().getHeaderLines();
        for (TicketLine line : headers) {
            prt.addToBuffer(line);
        }
        prt.addToBuffer("");
        SimpleDateFormat df = new SimpleDateFormat("EEEE d MMMM yyyy \u00e0 HH:mm", Locale.FRENCH);
        prt.addToBuffer(DefaultTicketPrinter.formatCenter(maxWidth, "Le " + df.format(this.getCreationDate())));
        prt.addToBuffer("");
        ArrayList<Pair<Article, Integer>> itemsToPrint = new ArrayList<Pair<Article, Integer>>(this.items);
        Collections.sort(itemsToPrint, new Comparator<Pair<Article, Integer>>(){

            @Override
            public int compare(Pair<Article, Integer> o1, Pair<Article, Integer> o2) {
                Categorie c2;
                Article p1 = o1.getFirst();
                Article p2 = o2.getFirst();
                Categorie c1 = p1.getCategorie();
                if (c1.equals(c2 = p2.getCategorie())) {
                    return p1.getName().compareTo(p2.getName());
                }
                if (c1.isUnknown()) {
                    return -1;
                }
                if (c2.isUnknown()) {
                    return 1;
                }
                return c1.getName().compareTo(c2.getName());
            }
        });
        Categorie currentCategorie = null;
        for (Pair<Article, Integer> item : this.items) {
            Article article = item.getFirst();
            if (!(currentCategorie != null && currentCategorie.getName().equals(article.getCategorie().getName()) || (currentCategorie = article.getCategorie()).isUnknown())) {
                prt.addToBuffer(currentCategorie.getName(), 1);
            }
            Integer nb = item.getSecond();
            Float tauxFromId = TaxeCache.getCache().getTauxFromId(article.getIdTaxe());
            Iterator<Paiement> tauxTVA = new BigDecimal(tauxFromId.floatValue()).movePointLeft(2).add(BigDecimal.ONE);
            BigDecimal unitPrice = article.getPriceWithoutTax().multiply((BigDecimal)((Object)tauxTVA), DecimalUtils.HIGH_PRECISION);
            BigDecimal multiply = article.getPriceWithoutTax().multiply(new BigDecimal(nb), DecimalUtils.HIGH_PRECISION).multiply((BigDecimal)((Object)tauxTVA), DecimalUtils.HIGH_PRECISION);
            String qtyString = DefaultTicketPrinter.formatRight(5, String.valueOf(nb));
            String priceString = DefaultTicketPrinter.formatRight(8, TicketCellRenderer.centsToString(multiply.movePointRight(2).setScale(0, RoundingMode.HALF_UP).intValue()));
            String unitPriceString = "";
            if (nb != 1) {
                unitPriceString = DefaultTicketPrinter.formatRight(8, TicketCellRenderer.centsToString(unitPrice.movePointRight(2).setScale(0, RoundingMode.HALF_UP).intValue()));
            }
            if (article.getCode() != null && !article.getCode().isEmpty()) {
                String codeString = DefaultTicketPrinter.formatLeft(maxWidth - 2 - 8 - 5 - 1 - unitPriceString.length(), article.getCode());
                prt.addToBuffer(String.valueOf(qtyString) + " " + codeString + " " + unitPriceString + " " + priceString);
                String nameString = DefaultTicketPrinter.formatLeft(maxWidth - 5 - 1, article.getName());
                prt.addToBuffer("      " + nameString);
                continue;
            }
            String nameString = DefaultTicketPrinter.formatLeft(maxWidth - 2 - 8 - 5 - 1 - unitPriceString.length(), article.getName());
            prt.addToBuffer(String.valueOf(qtyString) + " " + nameString + " " + unitPriceString + " " + priceString);
        }
        StringBuilder spacer = new StringBuilder();
        int i = 0;
        while (i <= 5) {
            spacer.append(' ');
            ++i;
        }
        i = 0;
        while (i < maxWidth - 5 - 1) {
            spacer.append('=');
            ++i;
        }
        prt.addToBuffer(spacer.toString());
        TotalCalculator calc = this.getTotalCalculator();
        int totalTTCInCents = calc.getTotalTTC().movePointRight(2).setScale(0, RoundingMode.HALF_UP).intValue();
        prt.addToBuffer(String.valueOf(DefaultTicketPrinter.formatRight(maxWidth - 8, "MONTANT TOTAL TTC (Euros) : ")) + DefaultTicketPrinter.formatRight(8, TicketCellRenderer.centsToString(totalTTCInCents)), 1);
        Map<SQLRowAccessor, Tuple2<BigDecimal, BigDecimal>> mapHtTVARowTaux = calc.getMapHtTVARowTaux();
        for (SQLRowAccessor row : mapHtTVARowTaux.keySet()) {
            Tuple2<BigDecimal, BigDecimal> htTVA = mapHtTVARowTaux.get(row);
            float tvaTaux = TaxeCache.getCache().getTauxFromId(row.getID()).floatValue();
            BigDecimal montantTVA = htTVA.get1();
            if (montantTVA == null || montantTVA.signum() == 0) continue;
            prt.addToBuffer(String.valueOf(DefaultTicketPrinter.formatRight(maxWidth - 8, "Dont TVA " + tvaTaux + "% : ")) + DefaultTicketPrinter.formatRight(8, TicketCellRenderer.centsToString(montantTVA.movePointRight(2).setScale(0, RoundingMode.HALF_UP).intValue())), 0);
        }
        prt.addToBuffer("");
        for (Paiement paiement : this.paiements) {
            String type = "";
            int montantInCents = paiement.getMontantInCents();
            if (montantInCents == 0) continue;
            type = montantInCents > 0 ? "Paiement " : "Remboursement ";
            if (paiement.getType() == 3) {
                type = "CB";
            } else if (paiement.getType() == 2) {
                type = "par ch\u00e8que";
            } else if (paiement.getType() == 1) {
                type = "en esp\u00e8ces";
            } else if (paiement.getType() == 4) {
                type = "depuis solde";
            }
            type = String.valueOf(type) + " de " + TicketCellRenderer.centsToString(montantInCents);
            type = montantInCents > 100 ? String.valueOf(type) + " euros" : String.valueOf(type) + " euro";
            prt.addToBuffer(type);
        }
        if (this.getTotalInCents() < this.getPaidTotal()) {
            int montantInCents = this.getPaidTotal() - this.getTotalInCents();
            String type = "Rendu : " + TicketCellRenderer.centsToString(montantInCents);
            type = montantInCents > 100 ? String.valueOf(type) + " euros" : String.valueOf(type) + " euro";
            prt.addToBuffer(type);
        }
        prt.addToBuffer("");
        List<TicketLine> footers = POSConfiguration.getInstance().getFooterLines();
        for (TicketLine line : footers) {
            prt.addToBuffer(line);
        }
        prt.addToBuffer("");
        prt.addToBuffer(this.getCode(), 10);
        prt.addToBuffer("");
        prt.addToBuffer("Ticket cr\u00e9\u00e9 par l'ERP OpenConcerto.");
        try {
            prt.printBuffer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Date getCreationDate() {
        return this.getCreationCal().getTime();
    }

    public Calendar getCreationCal() {
        return this.creationCal;
    }

    public void setCreationCal(Calendar cal) {
        this.creationCal = cal == null ? null : (Calendar)cal.clone();
    }

    public void addPaiement(Paiement p1) {
        this.paiements.add(p1);
    }

    public boolean isAdditionnalCopyRequested() {
        return this.additionnalCopyRequested;
    }

    public void addArticle(Article a) {
        boolean alreadyExist = false;
        if (a.isAdditionalCopyRequested()) {
            this.additionnalCopyRequested = true;
        }
        for (Pair<Article, Integer> line : this.items) {
            if (!line.getFirst().equals(a)) continue;
            alreadyExist = true;
            break;
        }
        if (!alreadyExist) {
            Pair<Article, Integer> line;
            line = new Pair<Article, Integer>(new Article(a), 1);
            this.items.add(line);
        }
    }

    public void incrementArticle(Article a) {
        boolean alreadyExist = false;
        for (Pair<Article, Integer> line : this.items) {
            if (!line.getFirst().equals(a)) continue;
            alreadyExist = true;
            line.setSecond(line.getSecond() + 1);
            break;
        }
        if (!alreadyExist) {
            Pair<Article, Integer> line;
            line = new Pair<Article, Integer>(a, 1);
            this.items.add(line);
        }
    }

    public List<Paiement> getPaiements() {
        return this.paiements;
    }

    public int getTotalInCents() {
        TotalCalculator calc = this.getTotalCalculator();
        BigDecimal totalTTC = calc.getTotalTTC();
        return totalTTC.movePointRight(2).setScale(0, RoundingMode.HALF_UP).intValue();
    }

    public TotalCalculator getTotalCalculator() {
        SQLTable tableElt = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().findTable("SAISIE_VENTE_FACTURE_ELEMENT");
        TotalCalculator calc = new TotalCalculator("T_PA_HT", "T_PV_HT", null);
        String val = DefaultNXProps.getInstance().getStringProperty("ArticleService");
        Boolean bServiceActive = Boolean.valueOf(val);
        calc.setServiceActive(bServiceActive != null && bServiceActive != false);
        int size = this.items.size();
        int i = 0;
        while (i < size) {
            Pair<Article, Integer> line = this.items.get(i);
            int count = line.getSecond();
            Article art = line.getFirst();
            SQLRowValues rowVals = new SQLRowValues(tableElt);
            rowVals.put("T_PV_HT", art.getPriceWithoutTax().multiply(new BigDecimal(count)));
            rowVals.put("QTE", count);
            rowVals.put("ID_TAXE", art.getIdTaxe());
            calc.addLine(rowVals, tableArticle.getRow(art.getId()), i, false);
            ++i;
        }
        calc.checkResult();
        return calc;
    }

    public List<Pair<Article, Integer>> getArticles() {
        return this.items;
    }

    public void clearArticle(Article article) {
        Pair<Article, Integer> toRemove = null;
        for (Pair<Article, Integer> line : this.items) {
            if (!line.getFirst().equals(article)) continue;
            toRemove = line;
            break;
        }
        if (toRemove != null) {
            this.items.remove(toRemove);
        }
    }

    public void setArticleCount(Article article, int count) {
        Pair<Article, Integer> toModify = null;
        for (Pair<Article, Integer> line : this.items) {
            if (!line.getFirst().equals(article)) continue;
            toModify = line;
            break;
        }
        if (toModify != null) {
            toModify.setSecond(count);
        }
    }

    public int getItemCount(Article article) {
        for (Pair<Article, Integer> line : this.items) {
            if (!line.getFirst().equals(article)) continue;
            return line.getSecond();
        }
        return 0;
    }

    public int getPaidTotal() {
        int paid = 0;
        for (Paiement p : this.paiements) {
            paid += p.getMontantInCents();
        }
        return paid;
    }

    public void removeArticle(Article a) {
        Pair<Article, Integer> lineToDelete = null;
        for (Pair<Article, Integer> line : this.items) {
            if (!line.getFirst().equals(a)) continue;
            int count = line.getSecond() + 1;
            if (count <= 0) {
                lineToDelete = line;
            }
            line.setSecond(count);
            break;
        }
        if (lineToDelete != null) {
            this.items.remove(lineToDelete);
        }
    }

    public String toString() {
        return "Ticket " + this.getCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Ticket) {
            Ticket t = (Ticket)obj;
            return t.getCode().equals(this.getCode());
        }
        return false;
    }

    public int hashCode() {
        return this.getCode().hashCode();
    }

    public void deleteTicket(SQLElementDirectory dir) throws IOException {
        final SQLTable table = dir.getElement(CompteClientTransactionSQLELement.class).getTable();
        for (Paiement paiement : this.paiements) {
            final int montantInCents = paiement.getMontantInCents();
            if (montantInCents <= 0 || paiement.getType() != 4) continue;
            try {
                SQLUtils.executeAtomic(table.getDBSystemRoot().getDataSource(), new SQLUtils.SQLFactory<Object>(){

                    @Override
                    public Object create() throws SQLException {
                        SQLTable tablePrefCompte = table.getDBRoot().findTable("PREFS_COMPTE");
                        SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);
                        SQLRowValues rowValsTransact = new SQLRowValues(table);
                        rowValsTransact.put("ID_CLIENT", Ticket.this.client.getId());
                        rowValsTransact.put("DATE", Ticket.this.getCreationCal().getTime());
                        BigDecimal amountTransaction = new BigDecimal(montantInCents).movePointLeft(2);
                        rowValsTransact.put("MONTANT", amountTransaction);
                        SQLRow rowTransact = rowValsTransact.commit();
                        GenerationEcritures ecr = new GenerationEcritures();
                        int idMvt = ecr.getNewMouvement(table.getName(), rowTransact.getID(), 1, "Annule Transact. " + Ticket.this.client.getFullName() + " Ticket " + Ticket.this.getCode());
                        rowTransact = rowTransact.createEmptyUpdateRow().put("ID_MOUVEMENT", idMvt).commit();
                        SQLTable tableClient = table.getForeignTable("ID_CLIENT");
                        SQLRow row = tableClient.getRow(Ticket.this.client.getId());
                        BigDecimal solde = row.getBigDecimal("SOLDE_COMPTE");
                        BigDecimal nouveauSolde = solde.add(amountTransaction);
                        row.createEmptyUpdateRow().put("SOLDE_COMPTE", nouveauSolde).commit();
                        int idCompteAvanceClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_AVANCE_CLIENT");
                        int idCompteClient = row.getInt("ID_COMPTE_PCE");
                        try {
                            if (idCompteAvanceClient <= 1) {
                                idCompteAvanceClient = ComptePCESQLElement.getIdComptePceDefault("AvanceClients");
                            }
                            if (idCompteClient <= 1 && (idCompteClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_CLIENT")) <= 1) {
                                idCompteClient = ComptePCESQLElement.getIdComptePceDefault("Clients");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new SQLException(e);
                        }
                        new GenerationMvtVirement(idCompteAvanceClient, idCompteClient, montantInCents, 0L, "Annulation transaction compte client", Ticket.this.getCreationCal().getTime(), 3, "Ticket N\u00b0" + Ticket.this.getCode()).genereMouvement();
                        return null;
                    }
                });
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        this.getReceiptCode().markDeleted();
    }
}

