/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.order.action;

import java.awt.Component;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JFrame;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.erp.core.common.ui.IListTotalPanel;
import org.openconcerto.erp.core.common.ui.ListeViewPanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.Tuple2;

public class ListeDesCommandesClientItemsAction
extends CreateFrameAbstractAction {
    public ListeDesCommandesClientItemsAction() {
        this.putValue("Name", "Liste des articles command\u00e9s");
    }

    @Override
    public JFrame createFrame() {
        final SQLElement element = Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT_ELEMENT");
        SQLTableModelSourceOnline tableSource = element.getTableSource(true);
        IListe liste = new IListe(tableSource);
        ListeViewPanel listeAddPanel = new ListeViewPanel(element, liste);
        listeAddPanel.getListe().getRequest().setWhere(new Where((FieldRef)element.getTable().getField("ID_COMMANDE_CLIENT"), ">", 1));
        BaseSQLTableModelColumn colStockR = new BaseSQLTableModelColumn("Qt\u00e9 restante \u00e0 livrer", BigDecimal.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                BigDecimal qteAlivrer = r.getBigDecimal("QTE_UNITAIRE").multiply(new BigDecimal(r.getInt("QTE")));
                BigDecimal qteLivree = BigDecimal.ZERO;
                if (r.getObject("QTE_LIVREE") != null) {
                    qteLivree = r.getBigDecimal("QTE_LIVREE");
                }
                return qteAlivrer.subtract(qteLivree);
            }

            @Override
            public Set<FieldPath> getPaths() {
                Path p = new Path(element.getTable());
                return CollectionUtils.createSet(new FieldPath(p, "QTE"), new FieldPath(p, "QTE_UNITAIRE"), new FieldPath(p, "QTE_LIVREE"));
            }
        };
        tableSource.getColumns().add(colStockR);
        ArrayList<Tuple2<? extends SQLTableModelColumn, IListTotalPanel.Type>> listField = new ArrayList<Tuple2<? extends SQLTableModelColumn, IListTotalPanel.Type>>();
        listField.add(Tuple2.create(tableSource.getColumn(element.getTable().getField("QTE")), IListTotalPanel.Type.SOMME_QTE));
        listField.add(Tuple2.create(colStockR, IListTotalPanel.Type.SOMME_QTE));
        listField.add(Tuple2.create(tableSource.getColumn(element.getTable().getField("T_PA_HT")), IListTotalPanel.Type.SOMME));
        listField.add(Tuple2.create(tableSource.getColumn(element.getTable().getField("T_PV_HT")), IListTotalPanel.Type.SOMME));
        listField.add(Tuple2.create(tableSource.getColumn(element.getTable().getField("T_PV_TTC")), IListTotalPanel.Type.SOMME));
        IListTotalPanel total = new IListTotalPanel(listeAddPanel.getListe(), listField, null, "Total");
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridy = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 13;
        c.fill = 0;
        listeAddPanel.add((Component)total, c);
        IListFrame frame = new IListFrame(listeAddPanel);
        frame.setTextTitle("Liste des articles command\u00e9s");
        frame.getPanel().getListe().setModificationAllowed(false);
        frame.getPanel().setAddVisible(false);
        frame.getPanel().setSearchFullMode(true);
        IListFilterDatePanel datePanel = new IListFilterDatePanel(frame.getPanel().getListe(), element.getTable().getTable("COMMANDE_CLIENT").getField("DATE"), IListFilterDatePanel.getDefaultMap());
        ++c.gridy;
        c.anchor = 10;
        frame.getPanel().add((Component)datePanel, c);
        return frame;
    }
}

