/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.ui;

import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.ui.table.AlternateTableCellRenderer;
import org.openconcerto.ui.table.TableCellRendererDecorator;
import org.openconcerto.ui.table.TableCellRendererUtils;

public class ListeFactureRenderer
extends TableCellRendererDecorator {
    public static final Color acompte = new Color(232, 238, 250);
    private static final Color acompteDark = new Color(222, 228, 240);
    private static final Color acompteGrey = acompte.darker();
    public static final Color complement = new Color(225, 254, 207);
    private static final Color complementDark = new Color(215, 244, 197);
    private static final Color complementGrey = complement.darker();
    public static final Color prev = new Color(253, 243, 204);
    private static final Color prevDark = new Color(243, 233, 194);
    private static final Color prevGrey = prev.darker();
    private static final SQLTable tableModeReglement = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT").getTable();
    private static final Map<Color, Color> COLORS = new HashMap<Color, Color>();
    public static final TableCellRendererDecorator.TableCellRendererDecoratorUtils<ListeFactureRenderer> UTILS;

    static {
        COLORS.put(acompte, acompteDark);
        COLORS.put(complement, complementDark);
        COLORS.put(prev, prevDark);
        UTILS = ListeFactureRenderer.createUtils(ListeFactureRenderer.class);
    }

    public ListeFactureRenderer() {
    }

    public ListeFactureRenderer(TableCellRenderer renderer) {
        super(renderer);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component comp = this.getRenderer(table, column).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        AlternateTableCellRenderer.setBGColorMap((JComponent)comp, COLORS);
        ListSQLLine line = ITableModel.getLine(table.getModel(), row);
        SQLRowValues rowAt = line.getRow();
        if (rowAt != null) {
            if (rowAt.getBoolean("ACOMPTE") == Boolean.TRUE) {
                comp.setBackground(isSelected ? acompteGrey : acompte);
            } else if (rowAt.getBoolean("COMPLEMENT") == Boolean.TRUE) {
                comp.setBackground(isSelected ? complementGrey : complement);
            } else if (rowAt.getBoolean("PREVISIONNELLE") == Boolean.TRUE) {
                comp.setBackground(isSelected ? prevGrey : prev);
            } else {
                TableCellRendererUtils.setBackgroundColor(comp, table, isSelected);
            }
            if (comp instanceof JLabel) {
                SQLRowAccessor foreignRow;
                JLabel label = (JLabel)comp;
                int realColIndex = table.getColumnModel().getColumn(column).getModelIndex();
                Set<SQLField> fields = line.getColumns().getAllColumns().get(realColIndex).getFields();
                if (fields.contains(tableModeReglement.getField("AJOURS")) && (foreignRow = rowAt.getForeign("ID_MODE_REGLEMENT")) != null && !foreignRow.isUndefined()) {
                    int njour;
                    int ajours = foreignRow.getObject("AJOURS") == null ? 0 : foreignRow.getInt("AJOURS");
                    int n = njour = foreignRow.getObject("LENJOUR") == null ? 0 : foreignRow.getInt("LENJOUR");
                    if (ajours == 0 && njour == 0) {
                        if (foreignRow.getBoolean("COMPTANT") == Boolean.FALSE) {
                            label.setText("Date de facture");
                        } else {
                            label.setText("Comptant");
                        }
                    } else {
                        StringBuffer s = new StringBuffer();
                        if (ajours != 0) {
                            s.append(String.valueOf(ajours) + (ajours > 1 ? " jours" : " jour"));
                        }
                        if (njour == 0) {
                            s.append(" date de facture");
                        } else if (njour == 31) {
                            s.append(" fin de mois");
                        } else {
                            s.append(" le " + njour);
                        }
                        label.setText(s.toString());
                    }
                }
            }
        }
        return comp;
    }
}

