/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.customerrelationship.customer.element.RelanceSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.sales.invoice.report.MailRelanceCreator;
import org.openconcerto.erp.core.sales.invoice.report.VenteFactureXmlSheet;
import org.openconcerto.erp.rights.ComptaUserRight;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.EmailComposer;
import org.openconcerto.ui.JDate;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.ListMap;

public class EcheanceClientSQLElement
extends ComptaSQLConfElement {
    SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMMM yyyy", Locale.ENGLISH);

    public EcheanceClientSQLElement() {
        super("ECHEANCE_CLIENT", "une \u00e9ch\u00e9ance client", "\u00e9ch\u00e9ances clients");
        RowAction.PredicateRowAction action = new RowAction.PredicateRowAction(new AbstractAction("D\u00e9tails client"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SQLElement eltClient = Configuration.getInstance().getDirectory().getElement(((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("CLIENT"));
                EditFrame edit = new EditFrame(eltClient, EditPanel.EditMode.MODIFICATION);
                edit.selectionId(IListe.get(arg0).getSelectedRow().asRow().getInt("ID_CLIENT"));
                edit.setVisible(true);
            }
        }, false);
        action.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(action);
        action = new RowAction.PredicateRowAction(new AbstractAction("Voir la source"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SQLRow row = IListe.get(arg0).fetchSelectedRow();
                MouvementSQLElement.showSource(row.getInt("ID_MOUVEMENT"));
            }
        }, false);
        action.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(action);
        action = new RowAction.PredicateRowAction(new AbstractAction("Envoyer un mail"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SQLRow row = IListe.get(arg0).fetchSelectedRow();
                EcheanceClientSQLElement.this.sendMail(row);
            }
        }, false);
        action.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(action);
        if (UserRightsManager.getCurrentUserRights().haveRight(ComptaUserRight.MENU)) {
            RowAction actionCancel = new RowAction(new AbstractAction("Annuler la r\u00e9gularisation en comptabilit\u00e9"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int answer = JOptionPane.showConfirmDialog(null, "Etes vous s\u00fbr de vouloir annuler la r\u00e9gularisation ?");
                    if (answer == 0) {
                        SQLRow row = IListe.get(e).getSelectedRow().asRow();
                        SQLRowValues rowVals = row.createEmptyUpdateRow();
                        rowVals.put("REG_COMPTA", Boolean.FALSE);
                        try {
                            rowVals.commit();
                        }
                        catch (SQLException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }, false){

                @Override
                public boolean enabledFor(List<SQLRowValues> selection) {
                    if (selection != null && selection.size() == 1) {
                        SQLRowAccessor row = selection.get(0);
                        return row.getBoolean("REG_COMPTA");
                    }
                    return true;
                }
            };
            this.getRowActions().add(actionCancel);
            RowAction actionRegul = new RowAction(new AbstractAction("R\u00e9gularisation en comptabilit\u00e9"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int answer;
                    SQLRow row = IListe.get(e).fetchSelectedRow();
                    String price = GestionDevise.currencyToString(row.getLong("MONTANT"));
                    SQLRow rowClient = row.getForeignRow("ID_CLIENT");
                    String nomClient = rowClient.getString("NOM");
                    String piece = "";
                    SQLRow rowMvt = row.getForeignRow("ID_MOUVEMENT");
                    if (rowMvt != null) {
                        SQLRow rowPiece = rowMvt.getForeignRow("ID_PIECE");
                        piece = rowPiece.getString("NOM");
                    }
                    if ((answer = JOptionPane.showConfirmDialog(null, "Etes vous s\u00fbr de vouloir r\u00e9gulariser l'\u00e9ch\u00e9ance de " + nomClient + " d'un montant de " + price + "\u20ac avec une saisie au kilometre?\nNom de la pi\u00e9ce : " + piece + ".")) == 0) {
                        SQLRowValues rowVals = row.createEmptyUpdateRow();
                        rowVals.put("REG_COMPTA", Boolean.TRUE);
                        try {
                            rowVals.commit();
                        }
                        catch (SQLException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }, false){

                @Override
                public boolean enabledFor(List<SQLRowValues> selection) {
                    if (selection != null && selection.size() == 1) {
                        SQLRowAccessor row = selection.get(0);
                        return row.getBoolean("REG_COMPTA") == false;
                    }
                    return true;
                }
            };
            this.getRowActions().add(actionRegul);
        }
    }

    private void sendMail(final SQLRow row) {
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        if (row != null) {
            int idMvtSource = MouvementSQLElement.getSourceId(row.getInt("ID_MOUVEMENT"));
            SQLRow rowMvtSource = base.getTable("MOUVEMENT").getRow(idMvtSource);
            if (!rowMvtSource.getString("SOURCE").equalsIgnoreCase("SAISIE_VENTE_FACTURE")) {
                return;
            }
            int idFact = rowMvtSource.getInt("IDSOURCE");
            SQLRow rowFacture = base.getTable("SAISIE_VENTE_FACTURE").getRow(idFact);
            final VenteFactureXmlSheet sheet = new VenteFactureXmlSheet(rowFacture);
            Set<SQLField> setContact = null;
            SQLTable tableContact = Configuration.getInstance().getRoot().findTable("CONTACT");
            setContact = row.getTable().getForeignKeys(tableContact);
            Set<SQLField> setClient = null;
            SQLTable tableClient = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("CLIENT");
            setClient = row.getTable().getForeignKeys(tableClient);
            String mail = "";
            for (SQLField field : setContact) {
                if (mail != null && mail.trim().length() != 0) continue;
                mail = row.getForeignRow(field.getName()).getString("EMAIL");
            }
            for (SQLField field : setClient) {
                SQLRow rowCli = row.getForeignRow(field.getName());
                if (mail != null && mail.trim().length() != 0) continue;
                mail = rowCli.getString("MAIL");
            }
            final String adresseMail = mail;
            MailRelanceCreator creator = new MailRelanceCreator();
            final String references = creator.getObject(row);
            final String text = creator.getValue(row);
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        File f = sheet.getOrCreatePDFDocumentFile(true);
                        EmailComposer.getInstance().compose(adresseMail, references, text, f.getAbsoluteFile());
                        String numero = NumerotationAutoSQLElement.getNextNumero(RelanceSQLElement.class);
                        SQLRowValues rowValsR = new SQLRowValues(row.getTable().getTable("RELANCE"));
                        rowValsR.put("DATE", new Date());
                        rowValsR.put("NUMERO", numero);
                        rowValsR.put("ID_CLIENT", row.getForeignID("ID_CLIENT"));
                        rowValsR.put("ID_SAISIE_VENTE_FACTURE", row.getForeignID("ID_SAISIE_VENTE_FACTURE"));
                        rowValsR.put("MONTANT", row.getObject("MONTANT"));
                        rowValsR.put("INFOS", "Email");
                        rowValsR.put("ID_ECHEANCE_CLIENT", row.getID());
                        try {
                            rowValsR.insert();
                            SQLTable tableNum = EcheanceClientSQLElement.this.getTable().getBase().getTable("NUMEROTATION_AUTO");
                            SQLRowValues rowVals = new SQLRowValues(tableNum);
                            int val = tableNum.getRow(2).getInt("RELANCE_START");
                            rowVals.put("RELANCE_START", (Object)(++val));
                            rowVals.update(2);
                            int nbRelance = row.getInt("NOMBRE_RELANCE");
                            SQLRowValues rowValsEch = new SQLRowValues(row.getTable());
                            rowValsEch.put("NOMBRE_RELANCE", ++nbRelance);
                            rowValsEch.put("DATE_LAST_RELANCE", new Date());
                            rowValsEch.update(row.getID());
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    catch (IOException exn) {
                        exn.printStackTrace();
                    }
                    catch (InterruptedException exn) {
                        exn.printStackTrace();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            };
            t.start();
        }
    }

    @Override
    public ListMap<String, String> getShowAs() {
        ListMap<String, String> map = new ListMap<String, String>();
        return map;
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_SAISIE_VENTE_FACTURE");
        l.add("DATE");
        l.add("ID_CLIENT");
        l.add("MONTANT");
        l.add("ID_MOUVEMENT");
        l.add("NOMBRE_RELANCE");
        l.add("INFOS");
        l.add("DATE_LAST_RELANCE");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE");
        l.add("ID_CLIENT");
        l.add("MONTANT");
        return l;
    }

    @Override
    protected void _initListRequest(ListSQLRequest req) {
        super._initListRequest(req);
        req.addToGraphToFetch("REG_COMPTA", "REGLE");
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            private DeviseField montant;
            private JTextField nbRelance;
            private JDate date;
            private JTextField idMouvement;
            private ElementComboBox comboClient;

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                this.montant = new DeviseField();
                this.nbRelance = new JTextField();
                this.date = new JDate();
                this.idMouvement = new JTextField();
                this.comboClient = new ElementComboBox();
                JLabel labelMouvement = new JLabel("Mouvement");
                this.add((Component)labelMouvement, c);
                c.weightx = 1.0;
                ++c.gridx;
                this.add((Component)this.idMouvement, c);
                JLabel labelDate = new JLabel("Date");
                ++c.gridx;
                this.add((Component)labelDate, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.date, c);
                JLabel labelClient = new JLabel("Client");
                ++c.gridy;
                c.gridx = 0;
                this.add((Component)labelClient, c);
                ++c.gridx;
                c.weightx = 1.0;
                c.gridwidth = 0;
                this.add((Component)this.comboClient, c);
                JLabel labelRelance = new JLabel("Nombre de relance");
                ++c.gridy;
                c.gridx = 0;
                c.gridwidth = 1;
                this.add((Component)labelRelance, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.nbRelance, c);
                c.gridwidth = 1;
                JLabel labelMontant = new JLabel("Montant");
                ++c.gridx;
                this.add((Component)labelMontant, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.montant, c);
                this.addSQLObject(this.montant, "MONTANT");
                this.addRequiredSQLObject(this.date, "DATE");
                this.addSQLObject(this.nbRelance, "NOMBRE_RELANCE");
                this.addRequiredSQLObject(this.comboClient, "ID_CLIENT");
                this.addSQLObject(this.idMouvement, "ID_MOUVEMENT");
            }
        };
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeFromPackage()) + ".commitment";
    }
}

