/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Color;
import java.awt.Component;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.openconcerto.utils.GestionDevise;

public class EtatChargeRenderer
extends DefaultTableCellRenderer {
    private static final Color couleurCot = new Color(253, 243, 204);
    private static final NumberFormat numberFormat = new DecimalFormat("0.00");

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (!isSelected) {
            if (value != null && value.getClass() == String.class) {
                this.setBackground(couleurCot);
            } else {
                this.setBackground(Color.WHITE);
            }
        }
        if (value == null) {
            this.setText("");
        } else if (value instanceof Float) {
            float f = ((Float)value).floatValue();
            this.setText(numberFormat.format(f));
            this.setHorizontalAlignment(4);
        } else if (value instanceof Long) {
            this.setText(GestionDevise.currencyToString((Long)value));
            this.setHorizontalAlignment(4);
        } else {
            this.setHorizontalAlignment(2);
            this.setText(value.toString());
        }
        return this;
    }
}

