/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.core.finance.accounting.report.Map2033A;
import org.openconcerto.erp.core.finance.accounting.ui.ResultatPanel;
import org.openconcerto.erp.preferences.TemplateNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;

public class BilanPanel
extends JPanel {
    public BilanPanel() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.add((Component)new JLabel("Vous allez g\u00e9n\u00e9rer le fichier result_2033A.pdf contenant le bilan simplifi\u00e9."), c);
        ++c.gridy;
        try {
            this.add((Component)new JLabel("Il se trouvera dans le dossier " + new File(TemplateNXProps.getInstance().getStringProperty("Location2033APDF")).getCanonicalPath()), c);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        JButton buttonFermer = new JButton("Fermer");
        buttonFermer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JFrame)SwingUtilities.getRoot(BilanPanel.this)).dispose();
            }
        });
        JButton buttonOuvrirDossier = new JButton("Ouvrir dossier");
        buttonOuvrirDossier.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String file = TemplateNXProps.getInstance().getStringProperty("Location2033APDF");
                File f = new File(file);
                try {
                    FileUtils.browseFile(f);
                }
                catch (Exception ex) {
                    ExceptionHandler.handle("Impossible de trouver le dossier " + f.getAbsolutePath(), ex);
                }
            }
        });
        JButton buttonGenerer = new JButton("G\u00e9n\u00e9rer");
        buttonGenerer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Map2033A map = new Map2033A(new JProgressBar());
                map.generateMap2033A();
            }
        });
        c.gridx = -1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        this.add((Component)buttonOuvrirDossier, c);
        ++c.gridy;
        c.anchor = 13;
        c.weightx = 1.0;
        buttonGenerer.setHorizontalAlignment(4);
        this.add((Component)buttonGenerer, c);
        c.weightx = 0.0;
        this.add((Component)buttonFermer, c);
    }

    public void getBilan() {
        List myListFourn;
        List myListBanq;
        long soldeClient = 0L;
        long soldeBanq = 0L;
        long soldeFourn = 0L;
        SQLBase base = Configuration.getInstance().getBase();
        SQLTable compteTable = base.getTable("COMPTE_PCE");
        SQLTable ecritureTable = base.getTable("ECRITURE");
        SQLSelect selClient = new SQLSelect(base);
        SQLSelect selFourn = new SQLSelect(base);
        SQLSelect selBanq = new SQLSelect(base);
        selClient.addSelect(ecritureTable.getField("DEBIT"), "SUM");
        selClient.addSelect(ecritureTable.getField("CREDIT"), "SUM");
        selFourn.addSelect(ecritureTable.getField("DEBIT"), "SUM");
        selFourn.addSelect(ecritureTable.getField("CREDIT"), "SUM");
        selBanq.addSelect(ecritureTable.getField("DEBIT"), "SUM");
        selBanq.addSelect(ecritureTable.getField("CREDIT"), "SUM");
        Where w = new Where((FieldRef)ecritureTable.getField("ID_COMPTE_PCE"), "=", compteTable.getField("ID"));
        Where wClient = new Where((FieldRef)compteTable.getField("NUMERO"), "LIKE", (Object)"41%");
        Where wFourn = new Where((FieldRef)compteTable.getField("NUMERO"), "LIKE", (Object)"40%");
        Where wBanq = new Where((FieldRef)compteTable.getField("NUMERO"), "LIKE", (Object)"5%");
        selBanq.setWhere(w.and(wBanq));
        selFourn.setWhere(w.and(wFourn));
        selClient.setWhere(w.and(wClient));
        String reqClient = selClient.asString();
        String reqFourn = selFourn.asString();
        String reqBanq = selBanq.asString();
        System.out.println(reqClient);
        System.out.println(reqFourn);
        System.out.println(reqBanq);
        Object obClient = base.getDataSource().execute(reqClient, new ArrayListHandler());
        Object obFourn = base.getDataSource().execute(reqFourn, new ArrayListHandler());
        Object obBanq = base.getDataSource().execute(reqBanq, new ArrayListHandler());
        List myListClient = (List)obClient;
        if (myListClient.size() != 0) {
            int i = 0;
            while (i < myListClient.size()) {
                Object[] objTmp = (Object[])myListClient.get(i);
                soldeClient = (Long)objTmp[0] - (Long)objTmp[1];
                ++i;
            }
        }
        if ((myListBanq = (List)obBanq).size() != 0) {
            int i = 0;
            while (i < myListBanq.size()) {
                Object[] objTmp = (Object[])myListBanq.get(i);
                soldeBanq = (Long)objTmp[0] - (Long)objTmp[1];
                ++i;
            }
        }
        if ((myListFourn = (List)obFourn).size() != 0) {
            int i = 0;
            while (i < myListFourn.size()) {
                Object[] objTmp = (Object[])myListFourn.get(i);
                soldeFourn = -((Long)objTmp[0]).longValue() + (Long)objTmp[1];
                ++i;
            }
        }
        this.add(new JLabel("Clients : " + soldeClient + " Banque : " + soldeBanq + " solde Fourn : " + soldeFourn + " R\u00e9sultat " + ResultatPanel.getResultatValue() + " Bilan = " + (soldeClient + soldeBanq) + " <<>> " + (soldeFourn - ResultatPanel.getResultatValue())));
    }
}

