/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.openconcerto.erp.core.finance.accounting.action.ImpressionBalanceAction;
import org.openconcerto.erp.core.finance.accounting.model.BalanceModel;
import org.openconcerto.erp.core.finance.accounting.ui.BalanceCellRenderer;
import org.openconcerto.sql.Configuration;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FontUtils;
import org.openconcerto.ui.state.JTableStateManager;
import org.openconcerto.utils.GestionDevise;

public class BalancePanel
extends JPanel {
    private long totalDebit;
    private long totalCredit;
    private JLabel labelTotalDebit;
    private JLabel labelTotalCredit;

    public BalancePanel() {
        this.setLayout(new GridBagLayout());
        this.totalDebit = 0L;
        this.totalCredit = 0L;
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        final BalanceModel model = new BalanceModel();
        JTable table = new JTable(model);
        table.setRowHeight(FontUtils.getPreferredRowHeight(table));
        new SwingWorker<String, Object>(){

            @Override
            protected String doInBackground() throws Exception {
                model.getBalance();
                return null;
            }

            @Override
            protected void done() {
                Component c = SwingUtilities.getRoot(BalancePanel.this);
                if (c != null) {
                    ((JFrame)c).setTitle("Balance");
                }
                BalancePanel.this.totalCredit = model.getTotalCredit();
                BalancePanel.this.totalDebit = model.getTotalDebit();
                BalancePanel.this.labelTotalCredit.setText(GestionDevise.currencyToString(BalancePanel.this.totalCredit));
                BalancePanel.this.labelTotalDebit.setText(GestionDevise.currencyToString(BalancePanel.this.totalDebit));
                model.fireTableDataChanged();
            }
        }.execute();
        JTableStateManager s = new JTableStateManager(table, new File(Configuration.getInstance().getConfDir(), "state-" + this.getClass().getSimpleName() + ".xml"), true);
        s.loadState();
        table.getTableHeader().setReorderingAllowed(false);
        this.add((Component)new JScrollPane(table), c);
        BalanceCellRenderer rend = new BalanceCellRenderer(0);
        int i = 0;
        while (i < table.getColumnCount()) {
            table.getColumnModel().getColumn(i).setCellRenderer(rend);
            ++i;
        }
        JPanel panelTotal = new JPanel();
        panelTotal.setLayout(new GridBagLayout());
        panelTotal.setBorder(BorderFactory.createTitledBorder("Totaux"));
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        this.totalCredit = model.getTotalCredit();
        this.totalDebit = model.getTotalDebit();
        this.labelTotalCredit = new JLabel(GestionDevise.currencyToString(this.totalCredit));
        this.labelTotalDebit = new JLabel(GestionDevise.currencyToString(this.totalDebit));
        panelTotal.add((Component)new JLabel("D\u00e9bit"), c);
        ++c.gridx;
        panelTotal.add((Component)this.labelTotalDebit, c);
        c.gridx = 0;
        ++c.gridy;
        panelTotal.add((Component)new JLabel("Cr\u00e9dit"), c);
        ++c.gridx;
        panelTotal.add((Component)this.labelTotalCredit, c);
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 13;
        c.gridwidth = 2;
        this.add((Component)panelTotal, c);
        JButton buttonImpression = new JButton("Impression");
        JButton buttonClose = new JButton("Fermer");
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 13;
        this.add((Component)buttonImpression, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)buttonClose, c);
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JFrame)SwingUtilities.getRoot(BalancePanel.this)).dispose();
            }
        });
        buttonImpression.addActionListener(new ImpressionBalanceAction());
    }
}

