/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.model;

import java.util.List;
import javax.swing.SwingWorker;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class LettrageModel
extends AbstractTableModel {
    private String[] titresCol;
    private String[] titresRow;
    private long debitLettre = 0L;
    private long creditLettre = 0L;
    private long debitNonLettre = 0L;
    private long creditNonLettre = 0L;
    private long creditSelection = 0L;
    private long debitSelection = 0L;
    private static final SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
    private static final SQLTable tableEcr = base.getTable("ECRITURE");
    int idCpt;

    public LettrageModel(int idCpt) {
        this.idCpt = idCpt;
        this.titresCol = new String[6];
        this.titresCol[0] = "Totaux";
        this.titresCol[1] = "Lettr\u00e9e";
        this.titresCol[2] = "Non Lettr\u00e9e";
        this.titresCol[3] = "Total";
        this.titresCol[4] = "S\u00e9lection";
        this.titresCol[5] = "Lettr\u00e9e + s\u00e9lection";
        this.titresRow = new String[3];
        this.titresRow[0] = "D\u00e9bit";
        this.titresRow[1] = "Cr\u00e9dit";
        this.titresRow[2] = "Solde";
        this.updateTotauxCompte();
    }

    public void setIdCompte(int id) {
        this.idCpt = id;
        this.updateTotauxCompte();
        this.updateSelection(null);
    }

    public void updateSelection(int[] rowIndex) {
        System.err.println("Update Selection");
        this.creditSelection = 0L;
        this.debitSelection = 0L;
        if (rowIndex != null) {
            int i = 0;
            while (i < rowIndex.length) {
                SQLRow row = tableEcr.getRow(rowIndex[i]);
                if (row != null) {
                    this.debitSelection += ((Long)row.getObject("DEBIT")).longValue();
                    this.creditSelection += ((Long)row.getObject("CREDIT")).longValue();
                }
                ++i;
            }
        }
        this.fireTableDataChanged();
    }

    public void updateTotauxCompte() {
        new SwingWorker<String, Object>(){

            @Override
            protected String doInBackground() throws Exception {
                SQLSelect sel = new SQLSelect(base);
                sel.addSelect(tableEcr.getField("CREDIT"), "SUM");
                sel.addSelect(tableEcr.getField("DEBIT"), "SUM");
                Where w = new Where((FieldRef)tableEcr.getField("ID_COMPTE_PCE"), "=", LettrageModel.this.idCpt);
                sel.setWhere(w.and(new Where((FieldRef)tableEcr.getField("LETTRAGE"), "!=", (Object)"")));
                String reqLettree = sel.toString();
                Object obLettree = base.getDataSource().execute(reqLettree, new ArrayListHandler());
                List myListLettree = (List)obLettree;
                LettrageModel.this.creditLettre = 0L;
                LettrageModel.this.debitLettre = 0L;
                if (myListLettree.size() != 0) {
                    int i = 0;
                    while (i < myListLettree.size()) {
                        Object[] objTmp = (Object[])myListLettree.get(i);
                        if (objTmp[0] != null) {
                            LettrageModel lettrageModel = LettrageModel.this;
                            lettrageModel.creditLettre = lettrageModel.creditLettre + ((Number)objTmp[0]).longValue();
                        }
                        if (objTmp[1] != null) {
                            LettrageModel lettrageModel = LettrageModel.this;
                            lettrageModel.debitLettre = lettrageModel.debitLettre + ((Number)objTmp[1]).longValue();
                        }
                        ++i;
                    }
                }
                sel.setWhere(w.and(new Where((FieldRef)tableEcr.getField("LETTRAGE"), "=", (Object)"")));
                String reqNotLettree = sel.toString();
                Object obNotLettree = base.getDataSource().execute(reqNotLettree, new ArrayListHandler());
                List myListNotLettree = (List)obNotLettree;
                LettrageModel.this.creditNonLettre = 0L;
                LettrageModel.this.debitNonLettre = 0L;
                if (myListNotLettree.size() != 0) {
                    int i = 0;
                    while (i < myListNotLettree.size()) {
                        Object[] objTmp = (Object[])myListNotLettree.get(i);
                        if (objTmp[0] != null) {
                            LettrageModel lettrageModel = LettrageModel.this;
                            lettrageModel.creditNonLettre = lettrageModel.creditNonLettre + ((Number)objTmp[0]).longValue();
                        }
                        if (objTmp[1] != null) {
                            LettrageModel lettrageModel = LettrageModel.this;
                            lettrageModel.debitNonLettre = lettrageModel.debitNonLettre + ((Number)objTmp[1]).longValue();
                        }
                        ++i;
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                LettrageModel.this.fireTableDataChanged();
            }
        }.execute();
    }

    @Override
    public String getColumnName(int column) {
        return this.titresCol[column];
    }

    @Override
    public int getColumnCount() {
        return this.titresCol.length;
    }

    @Override
    public int getRowCount() {
        return this.titresRow.length;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        return Long.class;
    }

    public long getSoldeSelection() {
        return this.creditSelection - this.debitSelection;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.titresRow[rowIndex];
        }
        if (columnIndex == 1) {
            if (rowIndex == 0) {
                return new Long(this.debitLettre);
            }
            if (rowIndex == 1) {
                return new Long(this.creditLettre);
            }
            if (rowIndex == 2) {
                return new Long(this.debitLettre - this.creditLettre);
            }
        }
        if (columnIndex == 2) {
            if (rowIndex == 0) {
                return new Long(this.debitNonLettre);
            }
            if (rowIndex == 1) {
                return new Long(this.creditNonLettre);
            }
            if (rowIndex == 2) {
                return new Long(this.debitNonLettre - this.creditNonLettre);
            }
        }
        if (columnIndex == 3) {
            if (rowIndex == 0) {
                return new Long(this.debitNonLettre + this.debitLettre);
            }
            if (rowIndex == 1) {
                return new Long(this.creditNonLettre + this.creditLettre);
            }
            if (rowIndex == 2) {
                return new Long(this.debitNonLettre - this.creditNonLettre + (this.debitLettre - this.creditLettre));
            }
        }
        if (columnIndex == 4) {
            if (rowIndex == 0) {
                return new Long(this.debitSelection);
            }
            if (rowIndex == 1) {
                return new Long(this.creditSelection);
            }
            if (rowIndex == 2) {
                return new Long(this.debitSelection - this.creditSelection);
            }
        }
        if (columnIndex == 5) {
            if (rowIndex == 0) {
                return new Long(this.debitSelection + this.debitLettre);
            }
            if (rowIndex == 1) {
                return new Long(this.creditSelection + this.creditLettre);
            }
            if (rowIndex == 2) {
                return new Long(this.debitSelection - this.creditSelection + this.debitLettre - this.creditLettre);
            }
        }
        return null;
    }
}

