/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.action;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.erp.core.common.ui.IListTotalPanel;
import org.openconcerto.erp.core.common.ui.PanelFrame;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.finance.accounting.ui.AssociationAnalytiquePanel;
import org.openconcerto.erp.core.finance.accounting.ui.SuppressionEcrituresPanel;
import org.openconcerto.erp.rights.ComptaUserRight;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class ListeDesEcrituresAction
extends CreateFrameAbstractAction {
    public ListeDesEcrituresAction() {
        this.putValue("Name", "Liste des \u00e9critures");
    }

    @Override
    public JFrame createFrame() {
        SQLTableModelSourceOnline src;
        final long time = Calendar.getInstance().getTimeInMillis();
        final SQLElement element = Configuration.getInstance().getDirectory().getElement("ECRITURE");
        if (!UserRightsManager.getCurrentUserRights().haveRight(ComptaUserRight.ACCES_NOT_RESCTRICTED_TO_411)) {
            src = element.getTableSource(true);
            src.getReq().setWhere(new Where((FieldRef)element.getTable().getField("COMPTE_NUMERO"), "LIKE", (Object)"411%"));
        } else {
            src = element.getTableSource(true);
        }
        final IListFrame frame = new IListFrame(new ListeAddPanel(element, new IListe(src)){

            @Override
            protected GridBagConstraints createConstraints() {
                GridBagConstraints res = super.createConstraints();
                res.gridwidth = 0;
                res.gridy = 1;
                return res;
            }

            @Override
            protected void handleAction(JButton source, ActionEvent evt) {
                if (source == this.buttonEffacer && this.getListe().fetchSelectedRow() != null) {
                    System.err.println("Archivage des \u00e9critures");
                    PanelFrame frame = new PanelFrame(new SuppressionEcrituresPanel(this.getListe().fetchSelectedRow().getInt("ID_MOUVEMENT")), "Suppression d'ecritures");
                    frame.pack();
                    frame.setResizable(false);
                    frame.setLocationRelativeTo(null);
                    frame.setVisible(true);
                } else {
                    super.handleAction(source, evt);
                }
            }
        });
        frame.setDefaultCloseOperation(2);
        frame.getPanel().setSearchFullMode(true);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridy = 4;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        SQLRow rowExercice = Configuration.getInstance().getBase().getTable("EXERCICE_COMMON").getRow(ComptaPropsConfiguration.getInstanceCompta().getRowSociete().getInt("ID_EXERCICE_COMMON"));
        IListFilterDatePanel comp = new IListFilterDatePanel(frame.getPanel().getListe(), element.getTable().getField("DATE"), IListFilterDatePanel.getDefaultMap());
        comp.setDateDu((Date)rowExercice.getObject("DATE_DEB"));
        c.weightx = 1.0;
        frame.getPanel().add((Component)comp, c);
        ArrayList<SQLField> l = new ArrayList<SQLField>();
        l.add(element.getTable().getField("DEBIT"));
        l.add(element.getTable().getField("CREDIT"));
        IListTotalPanel comp2 = new IListTotalPanel(frame.getPanel().getListe(), l);
        ++c.gridx;
        c.weightx = 0.0;
        frame.getPanel().add((Component)comp2, c);
        JTable table = frame.getPanel().getListe().getJTable();
        frame.getPanel().setCloneVisible(false);
        frame.getPanel().setAddVisible(false);
        frame.getPanel().setModifyVisible(false);
        frame.getPanel().setReloadVisible(true);
        frame.getPanel().getListe().setModificationAllowed(false);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3) {
                    JPopupMenu menuDroit = new JPopupMenu();
                    menuDroit.add(new AbstractAction("Consultation du compte"){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            SQLRowValues row = frame.getPanel().getListe().getSelectedRow();
                            ((EcritureSQLElement)element).consultationCompte(ComptePCESQLElement.getRow(row.getString("COMPTE_NUMERO"), row.getString("COMPTE_NOM")));
                        }
                    });
                    menuDroit.add(new AbstractAction("Contrepassation"){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            EcritureSQLElement.contrePassationPiece(frame.getPanel().getListe().getSelectedId());
                        }
                    });
                    menuDroit.add(new AbstractAction("Dupliquer"){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            EcritureSQLElement.dupliquer(frame.getPanel().getListe().fetchSelectedRow());
                        }
                    });
                    menuDroit.add(new AbstractAction("G\u00e9rer l'analytique"){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            PanelFrame frameAssoc = new PanelFrame(new AssociationAnalytiquePanel(frame.getPanel().getListe().getSelectedRow().asRow()), "Association analytique");
                            frameAssoc.setVisible(true);
                        }
                    });
                    menuDroit.add(new AbstractAction("Voir la source"){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            SQLRow row = frame.getPanel().getListe().fetchSelectedRow();
                            MouvementSQLElement.showSource(row.getInt("ID_MOUVEMENT"));
                        }
                    });
                    if (e.getModifiersEx() == 128) {
                        menuDroit.add(new AbstractAction("Mettre \u00e0 jour les noms de pi\u00e9ces"){

                            @Override
                            public void actionPerformed(ActionEvent event) {
                                ListeDesEcrituresAction.this.correctNomPiece();
                            }
                        });
                    }
                    menuDroit.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
                }
            }
        });
        frame.getPanel().getListe().getModel().invokeLater(new Runnable(){

            @Override
            public void run() {
                int rowCount = frame.getPanel().getListe().getModel().getRowCount() - 1;
                if (rowCount > 0) {
                    frame.getPanel().getListe().getJTable().setRowSelectionInterval(rowCount, rowCount);
                }
                System.err.println("Load ecritures : " + (Calendar.getInstance().getTimeInMillis() - time) + " ms");
            }
        });
        return frame;
    }

    public void correctNomPiece() {
        SQLTable tableMvt = Configuration.getInstance().getRoot().findTable("MOUVEMENT");
        SQLTable tablePiece = Configuration.getInstance().getRoot().findTable("PIECE");
        SQLSelect sel = new SQLSelect();
        sel.addSelect(tableMvt.getKey());
        sel.addSelect(tableMvt.getField("SOURCE"));
        sel.addSelect(tableMvt.getField("IDSOURCE"));
        sel.addSelect(tableMvt.getField("ID_MOUVEMENT_PERE"));
        sel.addSelect(tableMvt.getField("ID_PIECE"));
        sel.addJoin("LEFT", tableMvt.getField("ID_PIECE"));
        sel.addSelect(sel.getAlias(tablePiece.getField("NOM")));
        Where w = new Where((FieldRef)tableMvt.getField("ID_MOUVEMENT_PERE"), "=", tableMvt.getUndefinedID());
        w = w.and(new Where((FieldRef)tableMvt.getField("SOURCE"), "=", (Object)"SAISIE_VENTE_FACTURE"));
        w = w.and(new Where(sel.getAlias(tablePiece.getField("NOM")), "LIKE", (Object)"%Saisie vente facture%"));
        sel.setWhere(w);
        System.err.println(sel.asString());
        List rows = (List)Configuration.getInstance().getBase().getDataSource().execute(sel.asString(), SQLRowListRSH.createFromSelect(sel, tableMvt));
        for (SQLRow sqlRow : rows) {
            SQLRow rowPiece = sqlRow.getForeignRow("ID_PIECE");
            String nom = rowPiece.getString("NOM");
            if (!nom.startsWith("Saisie vente facture")) continue;
            SQLRowValues rowVals = rowPiece.asRowValues();
            String nomNew = nom.replaceAll("Saisie vente facture", "Fact. vente");
            rowVals.put("NOM", nomNew);
            try {
                rowVals.update();
            }
            catch (SQLException exn) {
                exn.printStackTrace();
            }
        }
    }
}

