/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.edm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.openconcerto.erp.core.common.ui.ScrollablePanel;
import org.openconcerto.erp.core.edm.Attachment;
import org.openconcerto.erp.core.edm.AttachmentUtils;
import org.openconcerto.erp.core.edm.FilePanel;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.SwingThreadUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;

public class AttachmentPanel
extends JPanel {
    private final SQLRowAccessor rowSource;
    private List<ListDataListener> listeners = new ArrayList<ListDataListener>();
    private int idParent = 1;
    private List<Integer> parents = new ArrayList<Integer>();
    private List<String> parentsNames = new ArrayList<String>();
    private Set<Attachment> selectedAttachments = new HashSet<Attachment>();
    private List<FilePanel> filePanels = new ArrayList<FilePanel>();

    public AttachmentPanel(SQLRowAccessor rowSource) {
        this.rowSource = rowSource;
        this.setLayout(new GridBagLayout());
        this.parents.add(1);
        this.parentsNames.add("Racine");
        this.initUI();
        this.setFocusable(true);
    }

    public void addListener(ListDataListener l) {
        this.listeners.add(l);
    }

    public void removeListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    public void fireDataChanged() {
        for (ListDataListener listDataListener : this.listeners) {
            listDataListener.contentsChanged(new ListDataEvent(this, 0, 0, 0));
        }
    }

    public void initUI() {
        this.filePanels.clear();
        this.invalidate();
        this.removeAll();
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        SQLTable tableAttachment = this.rowSource.getTable().getTable("ATTACHMENT");
        SQLRowValues rowVals = new SQLRowValues(tableAttachment);
        rowVals.putNulls(tableAttachment.getFieldsName());
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowVals);
        Where where = new Where((FieldRef)tableAttachment.getField("SOURCE_TABLE"), "=", (Object)this.rowSource.getTable().getName());
        where = where.and(new Where((FieldRef)tableAttachment.getField("SOURCE_ID"), "=", this.rowSource.getID()));
        where = where.and(new Where((FieldRef)tableAttachment.getField("ID_PARENT"), "=", this.idParent));
        List<SQLRowValues> rAttachments = fetcher.fetch(where);
        c.fill = 1;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        if (this.parents.size() > 1) {
            JPanel navPanel = new JPanel();
            navPanel.setBackground(Color.WHITE);
            navPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            navPanel.setLayout(new FlowLayout(0, 8, 2));
            int i = 0;
            while (i < this.parents.size()) {
                JLabel b = new JLabel(" " + this.parentsNames.get(i) + " ");
                b.setOpaque(true);
                b.setBackground(new Color(230, 240, 255));
                navPanel.add(b);
                final int id = this.parents.get(i);
                final int index = i;
                if (i < this.parents.size() - 1) {
                    b.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mousePressed(MouseEvent e) {
                            AttachmentPanel.this.idParent = id;
                            int nb = AttachmentPanel.this.parents.size() - index - 1;
                            int n = 0;
                            while (n < nb) {
                                int pos = AttachmentPanel.this.parents.size() - 1;
                                AttachmentPanel.this.parents.remove(pos);
                                AttachmentPanel.this.parentsNames.remove(pos);
                                ++n;
                            }
                            AttachmentPanel.this.clearSelection();
                            AttachmentPanel.this.initUI();
                        }
                    });
                }
                if (i < this.parents.size() - 1) {
                    b.setDropTarget(new DropTarget(){

                        @Override
                        public synchronized void drop(DropTargetDropEvent dtde) {
                            dtde.acceptDrop(2);
                            Transferable t = dtde.getTransferable();
                            try {
                                int i = 0;
                                while (i < t.getTransferDataFlavors().length) {
                                    DataFlavor dataFlavor = t.getTransferDataFlavors()[i];
                                    if (dataFlavor.isMimeTypeEqual("application/x-java-serialized-object")) {
                                        List attachments = (List)t.getTransferData(dataFlavor);
                                        AttachmentUtils utils = new AttachmentUtils();
                                        for (Attachment a : attachments) {
                                            if (a.getParentId() == id) continue;
                                            utils.move(a, id);
                                        }
                                        AttachmentPanel.this.initUI();
                                        break;
                                    }
                                    ++i;
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                ++i;
            }
            this.add((Component)navPanel, c);
            ++c.gridy;
        }
        JPanel toolbar = new JPanel();
        toolbar.setLayout(new FlowLayout(0));
        JButton addFolderButton = new JButton("Nouveau dossier");
        toolbar.add(addFolderButton);
        JButton addFileButton = new JButton("Ajouter un fichier");
        toolbar.add(addFileButton);
        JProgressBar progressBar = new JProgressBar(0, 100);
        progressBar.setValue(100);
        progressBar.setStringPainted(true);
        progressBar.setVisible(false);
        toolbar.add(progressBar);
        this.add((Component)toolbar, c);
        ++c.gridy;
        addFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttachmentUtils utils = new AttachmentUtils();
                try {
                    utils.createFolder("Nouveau dossier", AttachmentPanel.this.rowSource, AttachmentPanel.this.idParent);
                }
                catch (SQLException e1) {
                    JOptionPane.showMessageDialog(null, "Impossible de cr\u00e9er le dossier.", "Erreur", 0);
                }
                AttachmentPanel.this.initUI();
            }
        });
        addFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Frame frame = SwingThreadUtils.getAncestorOrSelf(Frame.class, (Component)e.getSource());
                FileDialog fd = new FileDialog(frame, "Ajouter un fichier", 0);
                fd.setVisible(true);
                String fileName = fd.getFile();
                if (fileName != null) {
                    File inFile = new File(fd.getDirectory(), fileName);
                    AttachmentUtils utils = new AttachmentUtils();
                    utils.uploadFile(inFile, AttachmentPanel.this.rowSource, AttachmentPanel.this.idParent);
                    AttachmentPanel.this.initUI();
                }
            }
        });
        ScrollablePanel files = new ScrollablePanel(){

            @Override
            public Dimension getPreferredSize() {
                int nbRow;
                int w = this.getSize().width;
                int nbPerRow = (w - 5) / 133;
                if (nbPerRow < 1) {
                    nbPerRow = 1;
                }
                if ((nbRow = 1 + this.getComponentCount() / nbPerRow) < 1) {
                    nbRow = 1;
                }
                return new Dimension(w, 5 + nbRow * 79);
            }
        };
        files.setOpaque(true);
        files.setBackground(Color.WHITE);
        files.setScrollableWidth(ScrollablePanel.ScrollableSizeHint.FIT);
        files.setScrollableHeight(ScrollablePanel.ScrollableSizeHint.NONE);
        files.setLayout(new FlowLayout(0, 5, 5));
        ArrayList<Attachment> attachments = new ArrayList<Attachment>(rAttachments.size());
        for (SQLRowValues sqlRowValues : rAttachments) {
            Attachment a = new Attachment(sqlRowValues);
            attachments.add(a);
        }
        Collections.sort(attachments, new Comparator<Attachment>(){

            @Override
            public int compare(Attachment o1, Attachment o2) {
                if (o1.isFolder() && !o2.isFolder()) {
                    return -1;
                }
                if (!o1.isFolder() && o2.isFolder()) {
                    return 1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (final Attachment a : attachments) {
            FilePanel filePanel = new FilePanel(a, this);
            this.filePanels.add(filePanel);
            filePanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        if (a.isFolder()) {
                            AttachmentPanel.this.openFolder(a);
                        } else {
                            Thread t = new Thread(){

                                @Override
                                public void run() {
                                    AttachmentUtils utils = new AttachmentUtils();
                                    File f = utils.getFile(a);
                                    if (f == null) {
                                        SwingUtilities.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                JOptionPane.showMessageDialog(null, "Impossible de r\u00e9cup\u00e9rer le fichier.", "Erreur", 0);
                                            }
                                        });
                                    } else {
                                        try {
                                            FileUtils.openFile(f);
                                        }
                                        catch (IOException e1) {
                                            ExceptionHandler.handle("Erreur lors de l'ouverture du fichier.", e1);
                                        }
                                    }
                                }
                            };
                            t.start();
                        }
                    }
                }
            });
            files.add(filePanel);
        }
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        JScrollPane scroll = new JScrollPane(files);
        scroll.setHorizontalScrollBarPolicy(31);
        scroll.setVerticalScrollBarPolicy(22);
        scroll.setMinimumSize(new Dimension(647, 400));
        scroll.setPreferredSize(new Dimension(647, 400));
        scroll.setBackground(Color.WHITE);
        scroll.getViewport().setBackground(Color.WHITE);
        this.add((Component)scroll, c);
        scroll.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                AttachmentPanel.this.clearSelection();
                AttachmentPanel.this.updatePanels();
            }
        });
        this.validate();
        this.repaint();
        DropTarget dt = new DropTarget(){

            @Override
            public synchronized void drop(DropTargetDropEvent dtde) {
                dtde.acceptDrop(3);
                Transferable t = dtde.getTransferable();
                try {
                    if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        List fileList = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                        AttachmentUtils utils = new AttachmentUtils();
                        boolean cancelledByUser = false;
                        for (File f : fileList) {
                            if (cancelledByUser) break;
                            if (f.isDirectory()) continue;
                            utils.uploadFile(f, AttachmentPanel.this.rowSource, AttachmentPanel.this.idParent);
                        }
                        AttachmentPanel.this.initUI();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        files.setDropTarget(dt);
        scroll.getViewport().setDropTarget(dt);
        this.fireDataChanged();
    }

    public Set<Attachment> getSelectedAttachments() {
        return this.selectedAttachments;
    }

    public void select(Attachment a) {
        this.selectedAttachments.add(a);
    }

    public void deselect(Attachment a) {
        this.selectedAttachments.remove(a);
    }

    public boolean isSelected(Attachment a) {
        return this.selectedAttachments.contains(a);
    }

    public void clearSelection() {
        this.selectedAttachments.clear();
    }

    public void updatePanels() {
        for (FilePanel p : this.filePanels) {
            p.updateBackgroundFromState();
        }
    }

    public void openFolder(Attachment a) {
        if (!a.isFolder()) {
            throw new IllegalStateException(String.valueOf(a.getName()) + " is not a folder");
        }
        this.clearSelection();
        this.idParent = a.getId();
        this.parents.add(a.getId());
        this.parentsNames.add(a.getName());
        this.initUI();
    }
}

