/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.core.finance.accounting.model.Currency;
import org.openconcerto.erp.core.finance.accounting.model.CurrencyConverter;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.utils.Tuple2;

public class IListTotalPanel
extends JPanel {
    CurrencyConverter cc = new CurrencyConverter();
    DecimalFormat decimalFormat = new DecimalFormat("##,##0.00");
    EventListenerList loadingListener = new EventListenerList();
    private final IListe list;
    private final Map<SQLTableModelColumn, JLabel> map = new HashMap<SQLTableModelColumn, JLabel>();

    public IListTotalPanel(IListe l, List<SQLField> listField) {
        this(l, IListTotalPanel.initListe(l, listField), null, null);
    }

    public IListTotalPanel(IListe l, List<SQLField> listField, String title) {
        this(l, IListTotalPanel.initListe(l, listField), null, title);
    }

    public static List<Tuple2<? extends SQLTableModelColumn, Type>> initListe(IListe iL, List<SQLField> l) {
        ArrayList<Tuple2<? extends SQLTableModelColumn, Type>> lFinal = new ArrayList<Tuple2<? extends SQLTableModelColumn, Type>>();
        for (SQLField field : l) {
            lFinal.add(Tuple2.create(iL.getSource().getColumn(field), Type.SOMME));
        }
        return lFinal;
    }

    public IListTotalPanel(IListe l, List<Tuple2<? extends SQLTableModelColumn, Type>> listField, List<Tuple2<SQLField, ?>> filters, String title) {
        this(l, listField, filters, null, title);
    }

    public IListTotalPanel(IListe l, final List<Tuple2<? extends SQLTableModelColumn, Type>> listField, final List<Tuple2<SQLField, ?>> filters, final List<Tuple2<SQLField, ?>> filtersNot, String title) {
        super(new GridBagLayout());
        this.list = l;
        this.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = -1;
        c.weightx = 0.0;
        if (title != null && title.trim().length() > 0) {
            JLabel sep = new JLabel(title);
            c.weightx = 1.0;
            c.gridwidth = 0;
            this.add((Component)sep, c);
            ++c.gridy;
            c.gridwidth = 1;
        }
        for (Tuple2<? extends SQLTableModelColumn, Type> field2 : listField) {
            c.weightx = 0.0;
            SQLTableModelColumn col = field2.get0();
            if (col == null) {
                throw new IllegalStateException("null SQLTableModelColumn in " + listField);
            }
            JLabelBold comp = new JLabelBold(col.getName());
            comp.setHorizontalAlignment(4);
            this.add((Component)comp, c);
            JLabelBold textField = new JLabelBold("0");
            textField.setHorizontalAlignment(4);
            this.map.put(field2.get0(), textField);
            c.weightx = 1.0;
            this.add((Component)textField, c);
            c.weightx = 0.0;
            if (field2.get1() == Type.SOMME || field2.get1() == Type.MOYENNE_DEVISE || field2.get1() == Type.AVANCEMENT_TTC) {
                this.add((Component)new JLabelBold(Currency.getSymbol(this.cc.getCompanyCurrencyCode())), c);
            } else if (field2.get1() == Type.MOYENNE_POURCENT || field2.get1() == Type.MOYENNE_MARGE) {
                this.add((Component)new JLabelBold("%"), c);
            }
            ++c.gridy;
        }
        this.list.addListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                HashMap<SQLTableModelColumn, BigDecimal> mapTotal = new HashMap<SQLTableModelColumn, BigDecimal>();
                HashMap<SQLTableModelColumn, Double> mapPourcent = new HashMap<SQLTableModelColumn, Double>();
                HashMap<SQLTableModelColumn, Integer> mapPourcentSize = new HashMap<SQLTableModelColumn, Integer>();
                for (Tuple2 field : listField) {
                    if (field.get1() != Type.COUNT) continue;
                    ((JLabel)IListTotalPanel.this.map.get(field.get0())).setText(String.valueOf(IListTotalPanel.this.list.getRowCount()));
                }
                int i = 0;
                while (i < IListTotalPanel.this.list.getRowCount()) {
                    SQLRowValues rowAt = ITableModel.getLine(IListTotalPanel.this.list.getModel(), i).getRow();
                    for (Tuple2 field : listField) {
                        BigDecimal n;
                        if (field.get1() == Type.MOYENNE_POURCENT) {
                            Double n2 = (Double)IListTotalPanel.this.list.getModel().getValueAt(i, IListTotalPanel.this.list.getSource().getColumns().indexOf(field.get0()));
                            boolean in = true;
                            if (filters != null) {
                                for (Tuple2 tuple2 : filters) {
                                    boolean bl = in = in && rowAt.getObject(((SQLField)tuple2.get0()).getName()).equals(tuple2.get1());
                                }
                            }
                            if (filtersNot != null) {
                                for (Tuple2 tuple2 : filtersNot) {
                                    boolean bl = in = in && !rowAt.getObject(((SQLField)tuple2.get0()).getName()).equals(tuple2.get1());
                                }
                            }
                            if (!in) continue;
                            if (mapPourcent.get(field.get0()) == null) {
                                mapPourcent.put((SQLTableModelColumn)field.get0(), n2);
                            } else {
                                mapPourcent.put((SQLTableModelColumn)field.get0(), n2 + (Double)mapPourcent.get(field.get0()));
                            }
                            if (mapPourcentSize.get(field.get0()) == null) {
                                mapPourcentSize.put((SQLTableModelColumn)field.get0(), 1);
                                continue;
                            }
                            mapPourcentSize.put((SQLTableModelColumn)field.get0(), (Integer)mapPourcentSize.get(field.get0()) + 1);
                            continue;
                        }
                        if (field.get1() == Type.AVANCEMENT_TTC) {
                            n = (BigDecimal)mapTotal.get(field.get0());
                            SQLTableModelColumn columnTTC = IListTotalPanel.this.list.getSource().getColumn(IListTotalPanel.this.list.getSource().getPrimaryTable().getField("T_TTC"));
                            BigDecimal ttc = BigDecimal.valueOf(((Number)IListTotalPanel.this.list.getModel().getValueAt(i, IListTotalPanel.this.list.getSource().getColumns().indexOf(columnTTC))).doubleValue());
                            BigDecimal av = BigDecimal.valueOf(((Number)IListTotalPanel.this.list.getModel().getValueAt(i, IListTotalPanel.this.list.getSource().getColumns().indexOf(field.get0()))).doubleValue());
                            boolean in = true;
                            if (filters != null) {
                                for (Tuple2 tuple2 : filters) {
                                    boolean bl = in = in && rowAt.getObject(((SQLField)tuple2.get0()).getName()).equals(tuple2.get1());
                                }
                            }
                            if (filtersNot != null) {
                                for (Tuple2 tuple2 : filtersNot) {
                                    boolean bl = in = in && !rowAt.getObject(((SQLField)tuple2.get0()).getName()).equals(tuple2.get1());
                                }
                            }
                            if (!in) continue;
                            if (n == null) {
                                mapTotal.put((SQLTableModelColumn)field.get0(), ttc.multiply(av).movePointLeft(2));
                                continue;
                            }
                            mapTotal.put((SQLTableModelColumn)field.get0(), n.add(ttc.multiply(av).movePointLeft(2)));
                            continue;
                        }
                        if (field.get1() == Type.MOYENNE_MARGE || field.get1() == Type.COUNT) continue;
                        n = (BigDecimal)mapTotal.get(field.get0());
                        BigDecimal n2 = BigDecimal.valueOf(((Number)IListTotalPanel.this.list.getModel().getValueAt(i, IListTotalPanel.this.list.getSource().getColumns().indexOf(field.get0()))).doubleValue());
                        boolean in = true;
                        if (filters != null) {
                            for (Tuple2 tuple2 : filters) {
                                boolean bl = in = in && rowAt.getObject(((SQLField)tuple2.get0()).getName()).equals(tuple2.get1());
                            }
                        }
                        if (filtersNot != null) {
                            for (Tuple2 tuple2 : filtersNot) {
                                boolean bl = in = in && !rowAt.getObject(((SQLField)tuple2.get0()).getName()).equals(tuple2.get1());
                            }
                        }
                        if (!in) continue;
                        if (n == null) {
                            mapTotal.put((SQLTableModelColumn)field.get0(), n2);
                            continue;
                        }
                        mapTotal.put((SQLTableModelColumn)field.get0(), n.add(n2));
                    }
                    ++i;
                }
                for (Tuple2 field : listField) {
                    Number l;
                    if (field.get1() == Type.MOYENNE_MARGE) {
                        BigDecimal totalVT = (BigDecimal)mapTotal.get(((Tuple2)listField.get(0)).get0());
                        BigDecimal totalHA = (BigDecimal)mapTotal.get(((Tuple2)listField.get(1)).get0());
                        if (totalHA != null && totalVT != null && totalVT.longValue() != 0L) {
                            ((JLabel)IListTotalPanel.this.map.get(field.get0())).setText(IListTotalPanel.this.decimalFormat.format(totalVT.subtract(totalHA).divide(totalVT, MathContext.DECIMAL32).doubleValue() * 100.0));
                            continue;
                        }
                        ((JLabel)IListTotalPanel.this.map.get(field.get0())).setText(IListTotalPanel.this.decimalFormat.format(0L));
                        continue;
                    }
                    if (field.get1() == Type.MOYENNE_POURCENT) {
                        l = (Double)mapPourcent.get(field.get0());
                        Integer d = (Integer)mapPourcentSize.get(field.get0());
                        if (l != null && d != null && d != 0) {
                            ((JLabel)IListTotalPanel.this.map.get(field.get0())).setText(IListTotalPanel.this.decimalFormat.format((Double)l / (double)d.intValue()));
                            continue;
                        }
                        ((JLabel)IListTotalPanel.this.map.get(field.get0())).setText(IListTotalPanel.this.decimalFormat.format(0L));
                        continue;
                    }
                    if (field.get1() == Type.COUNT) continue;
                    l = (BigDecimal)mapTotal.get(field.get0());
                    if (l != null) {
                        ((JLabel)IListTotalPanel.this.map.get(field.get0())).setText(IListTotalPanel.this.decimalFormat.format(((BigDecimal)l).doubleValue()));
                        continue;
                    }
                    ((JLabel)IListTotalPanel.this.map.get(field.get0())).setText(IListTotalPanel.this.decimalFormat.format(0L));
                }
                IListTotalPanel.this.fireUpdated();
            }
        });
    }

    public void fireUpdated() {
        PropertyChangeListener[] propertyChangeListenerArray = (PropertyChangeListener[])this.loadingListener.getListeners(PropertyChangeListener.class);
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener l = propertyChangeListenerArray[n2];
            l.propertyChange(null);
            ++n2;
        }
    }

    public void addListener(PropertyChangeListener l) {
        this.loadingListener.add(PropertyChangeListener.class, l);
    }

    public static enum Type {
        MOYENNE_POURCENT,
        MOYENNE_DEVISE,
        SOMME,
        SOMME_QTE,
        MOYENNE_MARGE,
        AVANCEMENT_TTC,
        COUNT;

    }
}

