/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.Inserter;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.ReOrder;
import org.openconcerto.sql.utils.SQLCreateTable;

public class EcoContributionInstallationUtils {
    Map<Object, SQLRowValues> familleMap = new HashMap<Object, SQLRowValues>();

    private void insertUndef(SQLCreateTable ct) throws SQLException {
        if (ct.getPrimaryKey().size() != 1) {
            throw new IllegalStateException("Not one and only one field in the PK : " + ct.getPrimaryKey());
        }
        Inserter.Insertion<?> insertion = new Inserter(ct).insertReturnFirstField("(" + SQLBase.quoteIdentifier("ORDRE") + ") VALUES(" + ReOrder.MIN_ORDER + ")", false);
        assert (insertion.getCount() == 1);
        if (insertion.getRows().size() != 1) {
            throw new IllegalStateException("Missing ID " + insertion.getRows());
        }
        SQLTable.setUndefID(ct.getRoot().getSchema(), ct.getName(), ((Number)insertion.getRows().get(0)).intValue());
    }

    private void insertValues(List<EcoContribution> values, SQLTable table) throws SQLException {
        for (EcoContribution eco : values) {
            SQLRowValues rowVals = new SQLRowValues(table);
            rowVals.put("CODE", eco.getCode());
            rowVals.put("NOM", eco.getLibelle());
            rowVals.put("ID_FAMILLE_ECO_CONTRIBUTION", this.getFamille(eco.getFamille(), table));
            rowVals.put("TAUX", eco.getTaux());
            rowVals.commit();
        }
    }

    private Object getFamille(String famille, SQLTable table) {
        if (this.familleMap.containsKey(famille)) {
            return this.familleMap.get(famille);
        }
        SQLRowValues rowValues = new SQLRowValues(table.getTable("FAMILLE_ECO_CONTRIBUTION"));
        rowValues.put("NOM", famille);
        this.familleMap.put(famille, rowValues);
        return rowValues;
    }

    public void updateEcoCommonTable(DBRoot root) throws SQLException {
        if (!root.contains("ECO_CONTRIBUTION")) {
            SQLCreateTable createTableFamille = new SQLCreateTable(root, "FAMILLE_ECO_CONTRIBUTION");
            createTableFamille.addVarCharColumn("NOM", 512);
            root.getBase().getDataSource().execute(createTableFamille.asString());
            this.insertUndef(createTableFamille);
            root.refetchTable("FAMILLE_ECO_CONTRIBUTION");
            root.getSchema().updateVersion();
            SQLCreateTable createTableEco = new SQLCreateTable(root, "ECO_CONTRIBUTION");
            createTableEco.addVarCharColumn("CODE", 256);
            createTableEco.addVarCharColumn("NOM", 512);
            createTableEco.addForeignColumn("ID_FAMILLE_ECO_CONTRIBUTION", root.getTable("FAMILLE_ECO_CONTRIBUTION"));
            createTableEco.addDecimalColumn("TAUX", 16, 2, BigDecimal.ZERO, false);
            root.getBase().getDataSource().execute(createTableEco.asString());
            this.insertUndef(createTableEco);
            root.refetchTable("ECO_CONTRIBUTION");
            root.getSchema().updateVersion();
        }
    }

    public void updateEco(DBRoot root) throws SQLException {
        SQLTable table;
        AlterTable alterTable;
        List<String> tables = Arrays.asList("AVOIR_CLIENT", "DEVIS", "COMMANDE_CLIENT", "BON_DE_LIVRAISON", "SAISIE_VENTE_FACTURE", "COMMANDE", "BON_RECEPTION", "FACTURE_FOURNISSEUR");
        SQLTable tableArt = root.getTable("ARTICLE");
        if (!tableArt.contains("ID_ECO_CONTRIBUTION")) {
            AlterTable alter = new AlterTable(tableArt);
            alter.addForeignColumn("ID_ECO_CONTRIBUTION", root.findTable("ECO_CONTRIBUTION"));
            root.getBase().getDataSource().execute(alter.asString());
            root.refetchTable("ARTICLE");
            root.getSchema().updateVersion();
            for (String tableName : tables) {
                alterTable = new AlterTable(root.getTable(tableName));
                alterTable.addLongColumn("T_ECO_CONTRIBUTION", 0L, true);
                root.getBase().getDataSource().execute(alterTable.asString());
                root.refetchTable(tableName);
                root.getSchema().updateVersion();
            }
            for (String tableName : tables) {
                alterTable = new AlterTable(root.getTable(String.valueOf(tableName) + "_ELEMENT"));
                alterTable.addForeignColumn("ID_ECO_CONTRIBUTION", root.findTable("ECO_CONTRIBUTION"));
                alterTable.addDecimalColumn("ECO_CONTRIBUTION", 16, 2, BigDecimal.ZERO, true);
                alterTable.addDecimalColumn("T_ECO_CONTRIBUTION", 16, 2, BigDecimal.ZERO, true);
                root.getBase().getDataSource().execute(alterTable.asString());
                root.refetchTable(String.valueOf(tableName) + "_ELEMENT");
                root.getSchema().updateVersion();
            }
        }
        for (String tableName : tables) {
            table = root.getTable(tableName);
            if (table.contains("T_ECO_CONTRIBUTION")) continue;
            alterTable = new AlterTable(table);
            alterTable.addLongColumn("T_ECO_CONTRIBUTION", 0L, true);
            root.getBase().getDataSource().execute(alterTable.asString());
            root.refetchTable(tableName);
            root.getSchema().updateVersion();
        }
        for (String tableName : tables) {
            table = root.getTable(String.valueOf(tableName) + "_ELEMENT");
            if (table.contains("T_ECO_CONTRIBUTION")) continue;
            alterTable = new AlterTable(table);
            alterTable.addForeignColumn("ID_ECO_CONTRIBUTION", root.findTable("ECO_CONTRIBUTION"));
            alterTable.addDecimalColumn("ECO_CONTRIBUTION", 16, 2, BigDecimal.ZERO, true);
            alterTable.addDecimalColumn("T_ECO_CONTRIBUTION", 16, 2, BigDecimal.ZERO, true);
            root.getBase().getDataSource().execute(alterTable.asString());
            root.refetchTable(String.valueOf(tableName) + "_ELEMENT");
            root.getSchema().updateVersion();
        }
    }

    class EcoContribution {
        private final String code;
        private final String libelle;
        private final String famille;
        private final BigDecimal taux;

        public EcoContribution(String code, String libelle, String famille, double taux) {
            this.code = code;
            this.libelle = libelle;
            this.famille = famille;
            this.taux = new BigDecimal(taux);
        }

        public String getCode() {
            return this.code;
        }

        public String getFamille() {
            return this.famille;
        }

        public String getLibelle() {
            return this.libelle;
        }

        public BigDecimal getTaux() {
            return this.taux;
        }
    }
}

