/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.input.DOMBuilder;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.ui.light.LightUIFrameProvider;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.light.ActivationOnSelectionControler;
import org.openconcerto.ui.light.ColumnSpec;
import org.openconcerto.ui.light.ColumnsSpec;
import org.openconcerto.ui.light.CustomEditorProvider;
import org.openconcerto.ui.light.LightUIButtonWithContext;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUIFrame;
import org.openconcerto.ui.light.LightUILine;
import org.openconcerto.ui.light.LightUIPanel;
import org.openconcerto.ui.light.LightUITable;
import org.openconcerto.ui.light.ListToolbarLine;
import org.openconcerto.ui.light.RowSelectionSpec;
import org.openconcerto.ui.light.TableSpec;
import org.openconcerto.utils.i18n.TranslationManager;

public abstract class CreateListFrameAbstractAction
extends CreateFrameAbstractAction
implements LightUIFrameProvider {
    public abstract String getTableName();

    @Override
    public LightUIFrame getUIFrame(PropsConfiguration configuration) {
        SQLElement element = configuration.getDirectory().getElement(this.getTableName());
        String elementCode = element.getCode();
        String frameTitle = TranslationManager.getInstance().getTranslationForItem(String.valueOf(elementCode) + ".title");
        LightUIFrame frame = new LightUIFrame(elementCode);
        frame.createTitlePanel(frameTitle);
        String tableId = String.valueOf(element.getCode()) + ".table";
        LightUIElement table = CreateListFrameAbstractAction.getTableCustomEditorProvider(element).createUIElement(tableId);
        table.setFillWidth(true);
        Collection<IListeAction> actions = element.getRowActions();
        LightUIPanel panel = frame.getContentPanel();
        LightUILine l0 = new LightUILine();
        l0.setGridAlignment(1);
        for (RowAction rowAction : actions) {
            if (!rowAction.inHeader()) continue;
            LightUIButtonWithContext element2 = new LightUIButtonWithContext(rowAction.getID());
            element2.setValue(rowAction.getID());
            String label = TranslationManager.getInstance().getTranslationForAction(rowAction.getID());
            element2.setLabel(label);
            l0.addChild(element2);
            panel.addControler(new ActivationOnSelectionControler(tableId, element2.getId()));
        }
        panel.addChild(l0);
        LightUILine l1 = new LightUILine();
        l1.setFillHeight(true);
        l1.setWeightY(1);
        l1.addChild(table);
        panel.addChild(l1);
        panel.addChild(new ListToolbarLine());
        frame.dump(System.out, 0);
        return frame;
    }

    public static CustomEditorProvider getTableCustomEditorProvider(final SQLElement element) {
        return new CustomEditorProvider(){

            @Override
            public LightUIElement createUIElement(String id) {
                ArrayList<String> possibleColumnIds = new ArrayList<String>();
                ArrayList<String> sortedIds = new ArrayList<String>();
                SQLTableModelSourceOnline source = element.getTableSource();
                List<SQLTableModelColumn> columns = source.getColumns();
                ArrayList<ColumnSpec> columnsSpec = new ArrayList<ColumnSpec>(columns.size());
                long userId = UserManager.getUserID();
                Document columnsPrefs = null;
                try {
                    DOMBuilder in = new DOMBuilder();
                    org.w3c.dom.Document w3cDoc = Configuration.getInstance().getXMLConf(userId, id);
                    if (w3cDoc != null) {
                        columnsPrefs = in.build(w3cDoc);
                    }
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Failed to get ColumnPrefs for table " + id + " and for user " + userId + "\n" + ex.getMessage());
                }
                int sqlColumnsCount = columns.size();
                int i = 0;
                while (i < sqlColumnsCount) {
                    SQLTableModelColumn sqlColumn = columns.get(i);
                    String columnId = sqlColumn.getIdentifier();
                    possibleColumnIds.add(columnId);
                    columnsSpec.add(new ColumnSpec(columnId, sqlColumn.getValueClass(), sqlColumn.getName(), null, false, null));
                    ++i;
                }
                sortedIds.add(((ColumnSpec)columnsSpec.get(0)).getId());
                ColumnsSpec cSpec = new ColumnsSpec(element.getCode(), columnsSpec, possibleColumnIds, sortedIds);
                cSpec.setAllowMove(true);
                cSpec.setAllowResize(true);
                cSpec.setUserPrefs(columnsPrefs);
                RowSelectionSpec selectionSpec = new RowSelectionSpec(id);
                TableSpec tSpec = new TableSpec(id, selectionSpec, cSpec);
                LightUITable e = new LightUITable(id);
                e.setTableSpec(tSpec);
                return e;
            }
        };
    }
}

