/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.traverse;

import java.util.ArrayList;
import java.util.List;
import org.jgrapht.Graph;
import org.jgrapht.traverse.CrossComponentIterator;

public class DepthFirstIterator<V, E>
extends CrossComponentIterator<V, E, CrossComponentIterator.VisitColor> {
    private List<V> stack = new ArrayList<V>();

    public DepthFirstIterator(Graph<V, E> g) {
        this(g, null);
    }

    public DepthFirstIterator(Graph<V, E> g, V startVertex) {
        super(g, startVertex);
    }

    @Override
    protected boolean isConnectedComponentExhausted() {
        while (!this.stack.isEmpty()) {
            if (this.peekStack() != null) {
                return false;
            }
            this.popStack();
            this.recordFinish();
        }
        return true;
    }

    @Override
    protected void encounterVertex(V vertex, E edge) {
        this.putSeenData(vertex, CrossComponentIterator.VisitColor.WHITE);
        this.stack.add(vertex);
    }

    @Override
    protected void encounterVertexAgain(V vertex, E edge) {
        CrossComponentIterator.VisitColor color = (CrossComponentIterator.VisitColor)((Object)this.getSeenData(vertex));
        if (color != CrossComponentIterator.VisitColor.WHITE) {
            return;
        }
        int i = this.stack.indexOf(vertex);
        assert (i > -1);
        this.stack.remove(i);
        this.stack.add(vertex);
    }

    @Override
    protected V provideNextVertex() {
        V v;
        while ((v = this.popStack()) == null) {
            this.recordFinish();
        }
        this.stack.add(v);
        this.stack.add(null);
        this.putSeenData(v, CrossComponentIterator.VisitColor.GRAY);
        return v;
    }

    private V popStack() {
        return this.stack.remove(this.stack.size() - 1);
    }

    private V peekStack() {
        return this.stack.get(this.stack.size() - 1);
    }

    private void recordFinish() {
        V v = this.popStack();
        this.putSeenData(v, CrossComponentIterator.VisitColor.BLACK);
        this.finishVertex(v);
    }
}

