/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.ext;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graphs;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.ext.IntegerNameProvider;
import org.jgrapht.ext.VertexNameProvider;
import org.jgrapht.util.ModifiableInteger;

public class MatrixExporter<V, E> {
    private String delimiter = " ";
    private String prefix = "";
    private String suffix = "";

    private void println(PrintWriter out, String fromName, String toName, String value) {
        out.println(String.valueOf(this.prefix) + fromName + this.suffix + this.delimiter + this.prefix + toName + this.suffix + this.delimiter + this.prefix + value + this.suffix);
    }

    public void exportAdjacencyMatrix(Writer output, UndirectedGraph<V, E> g) {
        PrintWriter out = new PrintWriter(output);
        IntegerNameProvider nameProvider = new IntegerNameProvider();
        for (Object from : g.vertexSet()) {
            nameProvider.getVertexName(from);
        }
        for (Object from : g.vertexSet()) {
            this.exportAdjacencyMatrixVertex(out, nameProvider, from, Graphs.neighborListOf(g, from));
        }
        out.flush();
    }

    public void exportAdjacencyMatrix(Writer output, DirectedGraph<V, E> g) {
        PrintWriter out = new PrintWriter(output);
        IntegerNameProvider nameProvider = new IntegerNameProvider();
        for (Object from : g.vertexSet()) {
            nameProvider.getVertexName(from);
        }
        for (Object from : g.vertexSet()) {
            this.exportAdjacencyMatrixVertex(out, nameProvider, from, Graphs.successorListOf(g, from));
        }
        out.flush();
    }

    private void exportAdjacencyMatrixVertex(PrintWriter out, VertexNameProvider<V> nameProvider, V from, List<V> neighbors) {
        ModifiableInteger count;
        String toName;
        String fromName = nameProvider.getVertexName(from);
        LinkedHashMap<String, ModifiableInteger> counts = new LinkedHashMap<String, ModifiableInteger>();
        for (V v : neighbors) {
            toName = nameProvider.getVertexName(v);
            count = (ModifiableInteger)counts.get(toName);
            if (count == null) {
                count = new ModifiableInteger(0);
                counts.put(toName, count);
            }
            count.increment();
            if (!from.equals(v)) continue;
            count.increment();
        }
        for (Map.Entry entry : counts.entrySet()) {
            toName = (String)entry.getKey();
            count = (ModifiableInteger)entry.getValue();
            this.println(out, fromName, toName, count.toString());
        }
    }

    public void exportLaplacianMatrix(Writer output, UndirectedGraph<V, E> g) {
        PrintWriter out = new PrintWriter(output);
        IntegerNameProvider<V> nameProvider = new IntegerNameProvider<V>();
        for (Object from : g.vertexSet()) {
            nameProvider.getVertexName(from);
        }
        for (Object from : g.vertexSet()) {
            String fromName = nameProvider.getVertexName(from);
            List<V> neighbors = Graphs.neighborListOf(g, from);
            this.println(out, fromName, fromName, Integer.toString(neighbors.size()));
            for (V to : neighbors) {
                String toName = nameProvider.getVertexName(to);
                this.println(out, fromName, toName, "-1");
            }
        }
        out.flush();
    }

    public void exportNormalizedLaplacianMatrix(Writer output, UndirectedGraph<V, E> g) {
        PrintWriter out = new PrintWriter(output);
        IntegerNameProvider<Object> nameProvider = new IntegerNameProvider<Object>();
        for (Object from : g.vertexSet()) {
            nameProvider.getVertexName(from);
        }
        for (Object from : g.vertexSet()) {
            String fromName = nameProvider.getVertexName(from);
            LinkedHashSet neighbors = new LinkedHashSet(Graphs.neighborListOf(g, from));
            if (neighbors.isEmpty()) {
                this.println(out, fromName, fromName, "0");
                continue;
            }
            this.println(out, fromName, fromName, "1");
            for (Object to : neighbors) {
                String toName = nameProvider.getVertexName(to);
                double value = -1.0 / Math.sqrt(g.degreeOf(from) * g.degreeOf(to));
                this.println(out, fromName, toName, Double.toString(value));
            }
        }
        out.flush();
    }
}

