/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graphs;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DirectedSubgraph;

public class StrongConnectivityInspector<V, E> {
    private final DirectedGraph<V, E> graph;
    private LinkedList<VertexData<V>> orderedVertices;
    private List<Set<V>> stronglyConnectedSets;
    private List<DirectedSubgraph<V, E>> stronglyConnectedSubgraphs;
    private Map<V, VertexData<V>> vertexToVertexData;

    public StrongConnectivityInspector(DirectedGraph<V, E> directedGraph) {
        if (directedGraph == null) {
            throw new IllegalArgumentException("null not allowed for graph!");
        }
        this.graph = directedGraph;
        this.vertexToVertexData = null;
        this.orderedVertices = null;
        this.stronglyConnectedSets = null;
        this.stronglyConnectedSubgraphs = null;
    }

    public DirectedGraph<V, E> getGraph() {
        return this.graph;
    }

    public boolean isStronglyConnected() {
        return this.stronglyConnectedSets().size() == 1;
    }

    public List<Set<V>> stronglyConnectedSets() {
        if (this.stronglyConnectedSets == null) {
            this.orderedVertices = new LinkedList();
            this.stronglyConnectedSets = new Vector<Set<V>>();
            this.createVertexData();
            for (VertexData<V> data : this.vertexToVertexData.values()) {
                if (((VertexData)data).discovered) continue;
                this.dfsVisit(this.graph, data, null);
            }
            DefaultDirectedGraph inverseGraph = new DefaultDirectedGraph(this.graph.getEdgeFactory());
            Graphs.addGraphReversed(inverseGraph, this.graph);
            this.resetVertexData();
            for (VertexData<Object> vertexData : this.orderedVertices) {
                if (((VertexData)vertexData).discovered) continue;
                HashSet set = new HashSet();
                this.stronglyConnectedSets.add(set);
                this.dfsVisit(inverseGraph, vertexData, set);
            }
            this.orderedVertices = null;
            this.vertexToVertexData = null;
        }
        return this.stronglyConnectedSets;
    }

    public List<DirectedSubgraph<V, E>> stronglyConnectedSubgraphs() {
        if (this.stronglyConnectedSubgraphs == null) {
            List<Set<V>> sets = this.stronglyConnectedSets();
            this.stronglyConnectedSubgraphs = new Vector<DirectedSubgraph<V, E>>(sets.size());
            Iterator<Set<V>> iter = sets.iterator();
            while (iter.hasNext()) {
                this.stronglyConnectedSubgraphs.add(new DirectedSubgraph<V, E>(this.graph, iter.next(), null));
            }
        }
        return this.stronglyConnectedSubgraphs;
    }

    private void createVertexData() {
        this.vertexToVertexData = new HashMap<V, VertexData<V>>(this.graph.vertexSet().size());
        for (Object vertex : this.graph.vertexSet()) {
            this.vertexToVertexData.put(vertex, new VertexData(null, vertex, false, false));
        }
    }

    private void dfsVisit(DirectedGraph<V, E> visitedGraph, VertexData<V> vertexData, Set<V> vertices) {
        Stack<VertexData<V>> stack = new Stack<VertexData<V>>();
        stack.push(vertexData);
        while (!stack.isEmpty()) {
            VertexData data = (VertexData)stack.pop();
            if (!data.discovered) {
                data.discovered = true;
                if (vertices != null) {
                    vertices.add(data.vertex);
                }
                stack.push(new VertexData(data, null, true, true));
                for (E edge : visitedGraph.outgoingEdgesOf(data.vertex)) {
                    VertexData<V> targetData = this.vertexToVertexData.get(visitedGraph.getEdgeTarget(edge));
                    if (((VertexData)targetData).discovered) continue;
                    stack.push(targetData);
                }
                continue;
            }
            if (!data.finished || vertices != null) continue;
            this.orderedVertices.addFirst(data.finishedData);
        }
    }

    private void resetVertexData() {
        for (VertexData<V> data : this.vertexToVertexData.values()) {
            ((VertexData)data).discovered = false;
            ((VertexData)data).finished = false;
        }
    }

    private static final class VertexData<V> {
        private final VertexData<V> finishedData;
        private final V vertex;
        private boolean discovered;
        private boolean finished;

        private VertexData(VertexData<V> finishedData, V vertex, boolean discovered, boolean finished) {
            this.finishedData = finishedData;
            this.vertex = vertex;
            this.discovered = discovered;
            this.finished = finished;
        }
    }
}

