/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple.xml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import jpos.config.JposEntry;
import jpos.config.Version;
import jpos.config.simple.AbstractRegPopulator;
import jpos.config.simple.xml.XmlRegPopulator;
import jpos.util.JposEntryUtility;
import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public abstract class AbstractXercesRegPopulator
extends AbstractRegPopulator
implements XmlRegPopulator {
    protected String xmlFileName = "jpos.xml";
    protected DOMParser domParser = new DOMParser();
    private Tracer tracer = TracerFactory.getInstance().createTracer("AbstractXercesRegPopulator");
    public static final String DTD_FILE_PATH = "jpos" + File.separator + "res";
    public static final String DTD_FILE_NAME = DTD_FILE_PATH + File.separator + "jcl.dtd";

    public AbstractXercesRegPopulator(String string) {
        super(string);
    }

    public void save(Enumeration enumeration) throws Exception {
        if (this.isPopulatorFileDefined()) {
            this.convertJposEntriesToXml(enumeration, this.getPopulatorFileOS());
        } else {
            this.convertJposEntriesToXml(enumeration, new FileOutputStream(this.getDefaultXmlFileName()));
        }
    }

    public void save(Enumeration enumeration, String string) throws Exception {
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.convertJposEntriesToXml(enumeration, fileOutputStream);
        fileOutputStream.close();
    }

    public URL getEntriesURL() {
        URL uRL = null;
        if (this.getPopulatorFileURL() != null && !this.getPopulatorFileURL().equals("")) {
            try {
                uRL = new URL(this.getPopulatorFileURL());
            }
            catch (Exception exception) {
                this.tracer.println("getEntriesURL: Exception.message=" + exception.getMessage());
            }
        } else {
            uRL = this.createURLFromFile(new File(this.getPopulatorFileName()));
        }
        this.tracer.println("getPopulatorFileURL()=" + this.getPopulatorFileURL());
        this.tracer.println("getPopulatorFileName()=" + this.getPopulatorFileName());
        return uRL;
    }

    protected Tracer getTracer() {
        return this.tracer;
    }

    protected String getDefaultXmlFileName() {
        return this.xmlFileName;
    }

    protected void convertJposEntriesToXml(Enumeration enumeration, OutputStream outputStream) throws Exception {
        Document document = this.getParser().getDocument();
        this.serializeDocument(document, enumeration, outputStream);
    }

    protected DOMParser getParser() {
        return this.domParser;
    }

    protected void serializeDocument(Document document, Enumeration enumeration, OutputStream outputStream) throws Exception {
        Document document2 = this.createEmptyDocument();
        this.insertJposEntriesInDoc(document2, enumeration);
        this.insertDateSavedComment(document2);
        OutputFormat outputFormat = new OutputFormat("xml", "UTF-8", true);
        outputFormat.setStandalone(false);
        outputFormat.setIndenting(true);
        outputFormat.setIndent(4);
        outputFormat.setPreserveSpace(true);
        outputFormat.setLineWidth(0);
        this.insertDTDInfo(document2, outputFormat);
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.tracer.println("Error making PrintWriter: UnsupportedEncodingException.message = " + unsupportedEncodingException.getMessage());
        }
        if (printWriter != null) {
            XMLSerializer xMLSerializer = new XMLSerializer(printWriter, outputFormat);
            xMLSerializer.serialize(document2);
        }
    }

    protected String getDoctypeValue() {
        return "jpos/res/jcl.dtd";
    }

    protected void insertDTDInfo(Document document, OutputFormat outputFormat) throws Exception {
        String string = OutputFormat.whichDoctypePublic(document);
        String string2 = OutputFormat.whichDoctypeSystem(document);
        outputFormat.setDoctype("JposEntries", this.getDoctypeValue());
    }

    protected Document createEmptyDocument() {
        DOMImplementationImpl dOMImplementationImpl = (DOMImplementationImpl)DOMImplementationImpl.getDOMImplementation();
        DocumentType documentType = dOMImplementationImpl.createDocumentType("JposEntries", "-//JavaPOS//DTD//EN", this.getDoctypeValue());
        Document document = dOMImplementationImpl.createDocument(null, "JposEntries", documentType);
        return document;
    }

    protected void insertDateSavedComment(Document document) throws Exception {
        String string = DateFormat.getInstance().format(new Date(System.currentTimeMillis()));
        String string2 = "Saved by JavaPOS jpos.config/loader (JCL) version " + Version.getVersionString() + " on " + string;
        Comment comment = document.createComment(string2);
        document.getDocumentElement().insertBefore(comment, document.getDocumentElement().getFirstChild());
        document.getDocumentElement().insertBefore(document.createTextNode("\n"), comment);
        document.getDocumentElement().appendChild(document.createTextNode("\n"));
    }

    protected void appendCreationElement(Document document, Element element, JposEntry jposEntry) {
        element.appendChild(document.createTextNode("        "));
        Element element2 = document.createElement("creation");
        Attr attr = document.createAttribute("factoryClass");
        Attr attr2 = document.createAttribute("serviceClass");
        attr.setValue((String)jposEntry.getPropertyValue("serviceInstanceFactoryClass"));
        attr2.setValue((String)jposEntry.getPropertyValue("serviceClass"));
        element2.setAttributeNode(attr);
        element2.setAttributeNode(attr2);
        element.appendChild(element2);
        element.appendChild(document.createTextNode("\n"));
    }

    protected void appendVendorElement(Document document, Element element, JposEntry jposEntry) {
        element.appendChild(document.createTextNode("        "));
        Element element2 = document.createElement("vendor");
        Attr attr = document.createAttribute("name");
        Attr attr2 = document.createAttribute("url");
        attr.setValue((String)jposEntry.getPropertyValue("vendorName"));
        attr2.setValue((String)jposEntry.getPropertyValue("vendorURL"));
        element2.setAttributeNode(attr);
        element2.setAttributeNode(attr2);
        element.appendChild(element2);
        element.appendChild(document.createTextNode("\n"));
    }

    protected void appendJposElement(Document document, Element element, JposEntry jposEntry) {
        element.appendChild(document.createTextNode("        "));
        Element element2 = document.createElement("jpos");
        Attr attr = document.createAttribute("version");
        Attr attr2 = document.createAttribute("category");
        attr.setValue((String)jposEntry.getPropertyValue("jposVersion"));
        attr2.setValue((String)jposEntry.getPropertyValue("deviceCategory"));
        element2.setAttributeNode(attr);
        element2.setAttributeNode(attr2);
        element.appendChild(element2);
        element.appendChild(document.createTextNode("\n"));
    }

    protected void appendProductElement(Document document, Element element, JposEntry jposEntry) {
        element.appendChild(document.createTextNode("        "));
        Element element2 = document.createElement("product");
        Attr attr = document.createAttribute("name");
        Attr attr2 = document.createAttribute("description");
        Attr attr3 = document.createAttribute("url");
        attr.setValue((String)jposEntry.getPropertyValue("productName"));
        attr2.setValue((String)jposEntry.getPropertyValue("productDescription"));
        attr3.setValue((String)jposEntry.getPropertyValue("productURL"));
        element2.setAttributeNode(attr);
        element2.setAttributeNode(attr2);
        element2.setAttributeNode(attr3);
        element.appendChild(element2);
        element.appendChild(document.createTextNode("\n"));
    }

    protected void appendPropElement(Document document, Element element, String string, Object object) {
        element.appendChild(document.createTextNode("        "));
        Element element2 = document.createElement("prop");
        Attr attr = document.createAttribute("name");
        Attr attr2 = document.createAttribute("value");
        Attr attr3 = document.createAttribute("type");
        attr.setValue(string);
        attr2.setValue(object.toString());
        attr3.setValue(JposEntryUtility.shortClassName(object.getClass()));
        element2.setAttributeNode(attr);
        element2.setAttributeNode(attr2);
        element2.setAttributeNode(attr3);
        element.appendChild(element2);
        element.appendChild(document.createTextNode("\n"));
    }

    protected void appendPropElements(Document document, Element element, JposEntry jposEntry) {
        element.appendChild(document.createTextNode("\n        "));
        String string = "Other non JavaPOS required property (mostly vendor properties and bus specific properties i.e. RS232 )";
        element.appendChild(document.createComment(string));
        element.appendChild(document.createTextNode("\n"));
        Enumeration enumeration = jposEntry.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (JposEntryUtility.isRequiredPropName(string2)) continue;
            this.appendPropElement(document, element, string2, jposEntry.getPropertyValue(string2));
        }
    }

    protected void insertJposEntryInDoc(Document document, Element element, JposEntry jposEntry) {
        this.appendCreationElement(document, element, jposEntry);
        this.appendVendorElement(document, element, jposEntry);
        this.appendJposElement(document, element, jposEntry);
        this.appendProductElement(document, element, jposEntry);
        this.appendPropElements(document, element, jposEntry);
        document.getDocumentElement().appendChild(document.createTextNode("\n    "));
        document.getDocumentElement().appendChild(element);
        document.getDocumentElement().appendChild(document.createTextNode("\n    "));
    }

    protected void insertJposEntriesInDoc(Document document, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            JposEntry jposEntry = (JposEntry)enumeration.nextElement();
            if (!JposEntryUtility.isValidJposEntry(jposEntry)) continue;
            document.getDocumentElement().appendChild(document.createTextNode("\n    "));
            Element element = document.createElement("JposEntry");
            Attr attr = document.createAttribute("logicalName");
            attr.setValue((String)jposEntry.getPropertyValue("logicalName"));
            element.setAttributeNode(attr);
            element.appendChild(document.createTextNode("\n"));
            this.insertJposEntryInDoc(document, element, jposEntry);
        }
    }
}

