/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import jpos.config.JposEntry;
import jpos.config.simple.AbstractRegPopulator;
import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;

public class SimpleRegPopulator
extends AbstractRegPopulator {
    private File serFile = null;
    private ZipFile zipSerFile = null;
    private boolean serInZipFile = false;
    private String absoluteFileName = "";
    private String serFileName = "jpos.cfg";
    private Tracer tracer = TracerFactory.getInstance().createTracer("SimpleRegPopulator");
    public static final String DEFAULT_JPOS_SER_FILE_NAME = "jpos.cfg";
    public static final String TEMP_SER_FILE_NAME = "__jpos_temp.cfg";
    public static final String SIMPLE_REG_POPULATOR_NAME_STRING = "JCL Serialized Entries Populator";
    static /* synthetic */ Class class$jpos$config$simple$SimpleRegPopulator;

    public SimpleRegPopulator() {
        super((class$jpos$config$simple$SimpleRegPopulator == null ? (class$jpos$config$simple$SimpleRegPopulator = SimpleRegPopulator.class$("jpos.config.simple.SimpleRegPopulator")) : class$jpos$config$simple$SimpleRegPopulator).getName());
    }

    public SimpleRegPopulator(String string) {
        super(string);
    }

    public String getClassName() {
        return (class$jpos$config$simple$SimpleRegPopulator == null ? (class$jpos$config$simple$SimpleRegPopulator = SimpleRegPopulator.class$("jpos.config.simple.SimpleRegPopulator")) : class$jpos$config$simple$SimpleRegPopulator).getName();
    }

    public void save(Enumeration enumeration) throws Exception {
        this.saveJposEntries(enumeration);
    }

    public void save(Enumeration enumeration, String string) throws Exception {
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.saveJposEntries(enumeration, fileOutputStream);
        fileOutputStream.close();
    }

    public void load() {
        this.getJposEntries().clear();
        Enumeration enumeration = this.readJposEntries();
        while (enumeration.hasMoreElements()) {
            try {
                JposEntry jposEntry = (JposEntry)enumeration.nextElement();
                String string = (String)jposEntry.getPropertyValue("logicalName");
                if (string != null) {
                    this.getJposEntries().put(string, jposEntry);
                }
                this.lastLoadException = null;
            }
            catch (Exception exception) {
                this.lastLoadException = exception;
                this.tracer.println("Error loading serialized JposEntry file: Exception.message= " + exception.getMessage());
            }
        }
    }

    public void load(String string) {
        try {
            this.getJposEntries().clear();
            Enumeration enumeration = this.readJposEntries(new FileInputStream(string));
            while (enumeration.hasMoreElements()) {
                JposEntry jposEntry = (JposEntry)enumeration.nextElement();
                String string2 = (String)jposEntry.getPropertyValue("logicalName");
                if (string2 == null) continue;
                this.getJposEntries().put(string2, jposEntry);
            }
            this.lastLoadException = null;
        }
        catch (Exception exception) {
            this.lastLoadException = exception;
            this.tracer.println("Error loading serialized JposEntry file: Exception.message=" + exception.getMessage());
        }
    }

    public URL getEntriesURL() {
        URL uRL = null;
        uRL = this.serInZipFile ? this.createURLFromFile(this.zipSerFile) : this.createURLFromFile(this.serFile);
        return uRL;
    }

    public String getName() {
        return SIMPLE_REG_POPULATOR_NAME_STRING;
    }

    protected void saveSerInZipFile(Enumeration enumeration) throws Exception {
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(this.zipSerFile.getName() + ".temp.jar"));
        Enumeration<? extends ZipEntry> enumeration2 = this.zipSerFile.entries();
        while (enumeration2.hasMoreElements()) {
            Object object;
            Closeable closeable;
            ZipEntry zipEntry = enumeration2.nextElement();
            zipOutputStream.putNextEntry(zipEntry);
            if (zipEntry.getName() != this.serFileName) {
                closeable = this.zipSerFile.getInputStream(zipEntry);
                while (((InputStream)closeable).available() > 0) {
                    object = new byte[((InputStream)closeable).available()];
                    ((InputStream)closeable).read((byte[])object);
                    zipOutputStream.write((byte[])object);
                }
                zipOutputStream.closeEntry();
                continue;
            }
            closeable = new ObjectOutputStream(new FileOutputStream(TEMP_SER_FILE_NAME));
            while (enumeration.hasMoreElements()) {
                object = (JposEntry)enumeration.nextElement();
                ((ObjectOutputStream)closeable).writeObject(object);
            }
            ((ObjectOutputStream)closeable).flush();
            ((ObjectOutputStream)closeable).close();
            object = new FileInputStream(TEMP_SER_FILE_NAME);
            while (((FileInputStream)object).available() > 0) {
                byte[] byArray = new byte[((FileInputStream)object).available()];
                ((FileInputStream)object).read(byArray);
                zipOutputStream.write(byArray);
            }
            zipOutputStream.closeEntry();
        }
        ((FilterOutputStream)zipOutputStream).flush();
        zipOutputStream.close();
    }

    protected void saveSerFile(Enumeration enumeration) throws Exception {
        this.saveJposEntries(enumeration, new FileOutputStream(this.serFileName));
    }

    protected void saveJposEntries(Enumeration enumeration, OutputStream outputStream) throws Exception {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        while (enumeration.hasMoreElements()) {
            JposEntry jposEntry = (JposEntry)enumeration.nextElement();
            objectOutputStream.writeObject(jposEntry);
        }
        objectOutputStream.close();
    }

    protected ObjectInputStream findSerOIS() {
        Vector vector = new Vector();
        ObjectInputStream objectInputStream = this.findSerOISInClasspath(vector);
        if (objectInputStream == null) {
            objectInputStream = this.findSerOISInJar(vector);
        }
        return objectInputStream;
    }

    protected ObjectInputStream findSerOISInClasspath(Vector vector) {
        ObjectInputStream objectInputStream = null;
        String string = System.getProperty("java.class.path");
        String string2 = System.getProperty("path.separator");
        String string3 = System.getProperty("file.separator");
        String string4 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, false);
        while (stringTokenizer.hasMoreTokens()) {
            try {
                string4 = stringTokenizer.nextToken().trim();
                if (string4.equals("")) continue;
                if (string4.length() > 4 && (string4.endsWith(".zip") || string4.endsWith(".jar"))) {
                    vector.addElement(string4);
                    continue;
                }
                this.absoluteFileName = string4 + string3 + this.serFileName;
                objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.absoluteFileName)));
                this.serFile = new File(this.absoluteFileName);
                this.serInZipFile = false;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return objectInputStream;
    }

    protected ObjectInputStream findSerOISInJar(Vector vector) {
        ObjectInputStream objectInputStream = null;
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            try {
                ZipFile zipFile = new ZipFile(string);
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    String string2 = zipEntry.getName();
                    if (!string2.endsWith(this.serFileName)) continue;
                    objectInputStream = new ObjectInputStream(zipFile.getInputStream(zipEntry));
                    this.zipSerFile = zipFile;
                    this.serInZipFile = true;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (objectInputStream != null) break;
            ++n;
        }
        return objectInputStream;
    }

    protected Enumeration readJposEntries(InputStream inputStream) {
        Vector<Object> vector = new Vector<Object>();
        try {
            ObjectInputStream objectInputStream = null;
            if (inputStream instanceof ObjectInputStream) {
                objectInputStream = (ObjectInputStream)inputStream;
            } else if (inputStream != null) {
                objectInputStream = new ObjectInputStream(inputStream);
            }
            if (objectInputStream != null) {
                while (true) {
                    vector.addElement(objectInputStream.readObject());
                }
            }
            this.tracer.println("Can't find serialized JposEntry file: " + this.serFileName);
            this.serFileName = this.absoluteFileName;
        }
        catch (EOFException eOFException) {
        }
        catch (Exception exception) {
            this.tracer.println("ERROR while reading serialized JposEntry file: " + this.serFileName + " Exception.message=" + exception.getMessage());
        }
        return vector.elements();
    }

    protected Enumeration readJposEntries() {
        Enumeration enumeration = null;
        if (this.isPopulatorFileDefined()) {
            try {
                enumeration = this.readJposEntries(this.getPopulatorFileIS());
            }
            catch (Exception exception) {
                enumeration = new Vector().elements();
            }
        } else {
            enumeration = this.readJposEntries(this.findSerOIS());
        }
        return enumeration;
    }

    protected void saveJposEntries(Enumeration enumeration) throws Exception {
        if (this.isPopulatorFileDefined()) {
            this.saveJposEntries(enumeration, this.getPopulatorFileOS());
        } else if (this.serInZipFile) {
            this.saveSerInZipFile(enumeration);
        } else {
            this.saveSerFile(enumeration);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

