/*
 * Decompiled with CFR 0.152.
 */
package ds.desktop.notify;

import ds.desktop.notify.DesktopNotify;
import ds.desktop.notify.Utils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JDialog;

public final class DesktopNotifyDriver {
    static ArrayList<DesktopNotify> windows = new ArrayList();
    static DesktopLayoutFrame frame;
    static volatile Thread tredo;

    private DesktopNotifyDriver() {
    }

    protected static void postPane(DesktopNotify window) {
        if (frame == null) {
            boolean bool = JDialog.isDefaultLookAndFeelDecorated();
            JDialog.setDefaultLookAndFeelDecorated(false);
            frame = new DesktopLayoutFrame();
            JDialog.setDefaultLookAndFeelDecorated(bool);
        }
        if (!frame.isVisible()) {
            frame.setVisible(true);
        }
        window.setWidth(300);
        window.sortMessage();
        window.setVisible(true);
        windows.add(window);
        DesktopNotifyDriver.sparkControlThread();
    }

    private static void sparkControlThread() {
        if (tredo == null) {
            tredo = new Thread(new Runnable(){

                @Override
                public void run() {
                    System.out.println(Thread.currentThread().getName() + " started.");
                    DesktopNotifyDriver.frame.finished = false;
                    while (!DesktopNotifyDriver.frame.finished) {
                        frame.repaint();
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    frame.dispose();
                    tredo = null;
                    System.out.println(Thread.currentThread().getName() + " finished.");
                }
            }, "DesktopNotify Driver Thread");
            tredo.start();
        }
    }

    protected static FontMetrics getFontMetrics(Font font) {
        return frame.getGraphics().getFontMetrics(font);
    }

    private static class DesktopLayoutFrame
    extends JDialog {
        Image bg;
        boolean nativeTrans;
        boolean finished = true;
        boolean clicked = false;

        public DesktopLayoutFrame() {
            super((Frame)null, "DesktopLayoutFrame");
            this.setUndecorated(true);
            this.nativeTrans = Utils.isTranslucencySupported();
            this.setBackground(new Color(0, 0, 0, this.nativeTrans ? 0 : 255));
            this.setContentPane(new JComponent(){

                @Override
                public void paintComponent(Graphics g) {
                    DesktopLayoutFrame.this.render((Graphics2D)g);
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    DesktopLayoutFrame.this.clicked = true;
                }
            });
            this.setFocusableWindowState(false);
            this.setAlwaysOnTop(true);
            System.out.println("Desktop Notify Frame deployed.");
        }

        @Override
        public void setVisible(boolean visible) {
            boolean bool = this.isVisible();
            if (visible) {
                Rectangle screenSize = Utils.getScreenSize();
                this.setBounds(screenSize.x + screenSize.width - 305, screenSize.y, 300, screenSize.height - 5);
                if (!bool && !this.nativeTrans) {
                    this.bg = Utils.getBackgroundCap(this.getBounds());
                }
            }
            super.setVisible(visible);
        }

        public void render(Graphics2D rd) {
            this.finished = false;
            int x = 0;
            int y = this.getHeight();
            long l = System.currentTimeMillis();
            if (windows.isEmpty()) {
                this.finished = true;
            }
            int cur = 0;
            if (!this.nativeTrans) {
                rd.drawImage(this.bg, 0, 0, this);
            }
            for (int i = 0; i < windows.size(); ++i) {
                DesktopNotify window = windows.get(i);
                if (!window.isVisible()) continue;
                y -= window.h;
                if (window.popupStart == 0L) {
                    window.popupStart = System.currentTimeMillis();
                }
                if (y > 0) {
                    boolean hover = false;
                    Point p = this.getMousePosition();
                    if (p != null && p.y > y && p.y < y + window.h) {
                        hover = true;
                        if (window.getAction() != null) {
                            cur = 12;
                        }
                        if (this.clicked) {
                            if (window.getAction() != null) {
                                final DesktopNotify w = window;
                                final long lf = l;
                                EventQueue.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        w.getAction().actionPerformed(new ActionEvent(w, 1001, "fireAction", lf, 0));
                                    }
                                });
                            }
                            if (window.expTime() == Long.MAX_VALUE) {
                                window.timeOut = l - window.popupStart + 500L;
                            }
                        }
                    }
                    window.render(x, y, hover, rd, l);
                } else {
                    window.popupStart = l;
                }
                if (l > window.expTime()) {
                    window.setVisible(false);
                    windows.remove(window);
                    --i;
                }
                y -= 5;
            }
            this.clicked = false;
            this.setCursor(new Cursor(cur));
        }
    }
}

