/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.cc;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.openconcerto.utils.Value;
import org.openconcerto.utils.cc.ITransformerExn;
import org.openconcerto.utils.cc.ITransformerFuture;

public class TransformerFuture<E, T, X extends Exception>
implements ITransformerFuture<E, T, X> {
    private final AtomicReference<Value<E>> input;
    private final FutureTask<T> f;

    public TransformerFuture(final ITransformerExn<? super E, ? extends T, ? extends X> cl) {
        this.f = new FutureTask(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return cl.transformChecked(((Value)TransformerFuture.this.input.get()).getValue());
            }
        });
        this.input = new AtomicReference(Value.getNone());
    }

    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        return this.f.cancel(mayInterruptIfRunning);
    }

    @Override
    public final boolean isCancelled() {
        return this.f.isCancelled();
    }

    @Override
    public final boolean isDone() {
        return this.f.isDone();
    }

    @Override
    public final T get() throws InterruptedException, ExecutionException {
        return this.f.get();
    }

    @Override
    public final T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.f.get(timeout, unit);
    }

    @Override
    public final T transformChecked(E input) throws X {
        if (!this.input.compareAndSet(Value.getNone(), Value.getSome(input))) {
            throw new IllegalStateException("Already run");
        }
        this.f.run();
        assert (this.f.isDone());
        try {
            return this.f.get();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            Exception casted = (Exception)cause;
            throw casted;
        }
    }
}

