/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.URL;
import java.util.Enumeration;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;

public class NetUtils {
    public static final HostnameVerifier HostnameNonVerifier = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    public static int findFreePort(int preferred) {
        return NetUtils.findFreePort(null, preferred);
    }

    public static int findFreePort(String addr, int preferred) {
        if (NetUtils.isPortFree(addr, preferred)) {
            return preferred;
        }
        return NetUtils.findFreePort(addr);
    }

    public static int findFreePort() {
        return NetUtils.findFreePort(null);
    }

    public static int findFreePort(String addr) {
        return NetUtils.checkPort(addr, 0);
    }

    public static boolean isPortFree(String addr, int port) {
        if (port <= 0) {
            throw new IllegalArgumentException(String.valueOf(port) + " is negative");
        }
        return NetUtils.checkPort(addr, port) == port;
    }

    private static int checkPort(String addr, int port) {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(port, 0, InetAddress.getByName(addr));
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException iOException) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean isSelfAddr(String addr) {
        if (addr == null) {
            return false;
        }
        if (addr.startsWith("127.") || addr.startsWith("localhost")) {
            return true;
        }
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            block2: while (true) {
                InetAddress inetAddress;
                if (!en.hasMoreElements()) {
                    return false;
                }
                NetworkInterface ni = en.nextElement();
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                do {
                    if (!addresses.hasMoreElements()) continue block2;
                } while (!addr.startsWith((inetAddress = addresses.nextElement()).getHostAddress()));
                break;
            }
            return true;
        }
        catch (SocketException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static final String getHTTPContent(String address, boolean dontVerify) {
        String content = "";
        OutputStream out = null;
        HttpsURLConnection conn = null;
        InputStream in = null;
        try {
            try {
                int numRead;
                URL url = new URL(address);
                out = new ByteArrayOutputStream();
                conn = (HttpsURLConnection)url.openConnection();
                if (dontVerify) {
                    conn.setHostnameVerifier(HostnameNonVerifier);
                }
                in = conn.getInputStream();
                byte[] buffer = new byte[1024];
                while ((numRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, numRead);
                }
                content = out.toString();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
        return content;
    }
}

