/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.preferences;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.tree.DefaultMutableTreeNode;
import org.openconcerto.ui.TM;
import org.openconcerto.ui.preferences.MainPrefPanel;
import org.openconcerto.ui.preferences.PrefTree;
import org.openconcerto.ui.preferences.PreferencePanel;

public class PreferenceFrame
extends JFrame {
    MainPrefPanel mainPrefPanel;

    public PreferenceFrame(DefaultMutableTreeNode root) {
        this.setTitle(TM.tr("prefs.title", new Object[0]));
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.fill = 1;
        c.weightx = 0.0;
        c.weighty = 1.0;
        PrefTree prefTree = new PrefTree(root);
        prefTree.setMinimumSize(new Dimension(250, 200));
        prefTree.setPreferredSize(new Dimension(250, 200));
        this.getContentPane().add((Component)prefTree, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.getContentPane().add((Component)new JSeparator(1), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.mainPrefPanel = new MainPrefPanel(prefTree);
        this.getContentPane().add((Component)this.mainPrefPanel, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 3;
        this.getContentPane().add((Component)new JSeparator(0), c);
        JPanel p1 = new JPanel();
        JButton buttonClose = new JButton(TM.tr("toClose", new Object[0]));
        p1.setOpaque(true);
        p1.add(buttonClose);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 3;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 13;
        this.getContentPane().add((Component)p1, c);
        this.setBackground(p1.getBackground());
        this.getContentPane().setBackground(p1.getBackground());
        this.setMinimumSize(new Dimension(880, 680));
        this.setPreferredSize(new Dimension(880, 680));
        prefTree.addTreeSelectionListener(this.mainPrefPanel);
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferenceFrame.this.doOnClose();
                PreferenceFrame.this.dispose();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PreferenceFrame.this.doOnClose();
            }
        });
    }

    private void doOnClose() {
        PreferencePanel currentPanel = this.mainPrefPanel.getCurrentPanel();
        if (currentPanel.isModified() && JOptionPane.showConfirmDialog(null, TM.tr("prefs.applyModif", new Object[0]), TM.tr("prefs.applyModif.title", new Object[0]), 0) == 0) {
            currentPanel.apply();
        }
    }
}

