/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.preferences;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.TM;
import org.openconcerto.ui.preferences.DefaultPreferencePanel;
import org.openconcerto.ui.preferences.PrefTree;
import org.openconcerto.ui.preferences.PrefTreeNode;
import org.openconcerto.ui.preferences.PreferencePanel;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidObject;
import org.openconcerto.utils.checks.ValidState;

public class MainPrefPanel
extends JPanel
implements TreeSelectionListener,
ActionListener {
    private PreferencePanel currentPanel = new DefaultPreferencePanel(){

        @Override
        public void storeValues() {
        }

        @Override
        public void restoreToDefaults() {
        }

        @Override
        public String getTitleName() {
            return "";
        }
    };
    private JLabel titleLabel;
    private final Vector<PrefTreeNode> history = new Vector();
    private JButton buttonLeft;
    private JButton buttonRight;
    private PrefTree tree;
    private PrefTreeNode currentNode;
    private final JButton buttonApply = new JButton(TM.tr("toApply", new Object[0]));
    private final ValidListener validListener = new ValidListener(){

        @Override
        public void validChange(ValidObject src, ValidState newValue) {
            MainPrefPanel.this.buttonApply.setEnabled(newValue.isValid());
            MainPrefPanel.this.buttonApply.setToolTipText(newValue.getValidationText());
        }
    };

    public MainPrefPanel(PrefTree tree) {
        this.tree = tree;
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 1;
        c.gridwidth = 2;
        this.add((Component)this.getTopPanel(), c);
        ++c.gridy;
        this.add((Component)new JSeparator(0), c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)((DefaultPreferencePanel)this.currentPanel), c);
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.fill = 0;
        c.anchor = 13;
        c.gridwidth = 1;
        JButton reglDefault = new JButton(TM.tr("prefs.reset", new Object[0]));
        this.add((Component)reglDefault, c);
        reglDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPrefPanel.this.currentPanel.restoreToDefaults();
            }
        });
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.add((Component)this.buttonApply, c);
        this.buttonApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPrefPanel.this.currentPanel.apply();
            }
        });
        this.buttonLeft.addActionListener(this);
        this.buttonRight.addActionListener(this);
        this.addContainerListener(new ContainerAdapter(){

            @Override
            public void componentRemoved(ContainerEvent e) {
                if (DefaultPreferencePanel.class.isAssignableFrom(e.getChild().getClass())) {
                    final DefaultPreferencePanel panel = (DefaultPreferencePanel)e.getChild();
                    final Component root = e.getComponent();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (panel.isModified() && JOptionPane.showConfirmDialog(root, TM.tr("prefs.applyModif", new Object[0]), TM.tr("prefs.applyModif.title", new Object[0]), 0) == 0) {
                                panel.apply();
                            }
                        }
                    });
                }
            }
        });
    }

    private JPanel getTopPanel() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(1, 10, 2, 10);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.fill = 2;
        c.weightx = 1.0;
        this.titleLabel = new JLabel(TM.tr("prefs.main", new Object[0]));
        Font fontTitre = new Font("Arial Gras", 0, 12);
        this.titleLabel.setFont(fontTitre);
        p.add((Component)this.titleLabel, c);
        c.fill = 0;
        c.anchor = 13;
        c.insets = new Insets(1, 1, 2, 1);
        c.weightx = 0.0;
        c.gridx += 2;
        c.gridwidth = 1;
        this.buttonLeft = new JButton(new ImageIcon(MainPrefPanel.class.getResource("fleche_g.png")));
        this.buttonLeft.setBorderPainted(false);
        this.buttonLeft.setFocusPainted(false);
        this.buttonLeft.setContentAreaFilled(false);
        this.buttonLeft.setOpaque(false);
        this.buttonLeft.setMargin(new Insets(0, 0, 0, 0));
        this.buttonLeft.setEnabled(false);
        p.add((Component)this.buttonLeft, c);
        ++c.gridx;
        this.buttonRight = new JButton(new ImageIcon(MainPrefPanel.class.getResource("fleche_d.png")));
        this.buttonRight.setBorderPainted(false);
        this.buttonRight.setFocusPainted(false);
        this.buttonRight.setContentAreaFilled(false);
        this.buttonRight.setOpaque(false);
        this.buttonRight.setMargin(new Insets(0, 0, 0, 0));
        this.buttonRight.setEnabled(false);
        p.add((Component)this.buttonRight, c);
        return p;
    }

    public PreferencePanel getCurrentPanel() {
        return this.currentPanel;
    }

    public void setPanelFromTreeNode(PrefTreeNode n) {
        this.currentNode = n;
        PreferencePanel p = n.createPanel();
        if (p != null) {
            this.titleLabel.setText(p.getTitleName());
            if (this.currentPanel instanceof JComponent) {
                p.uiInit();
                this.replacePanel(p);
                this.addToHistory(n);
            }
        }
    }

    private void replacePanel(PreferencePanel p) {
        GridBagConstraints c = ((GridBagLayout)this.getLayout()).getConstraints((JComponent)((Object)this.currentPanel));
        if (this.currentPanel != null) {
            if (this.currentPanel.isModified() && JOptionPane.showConfirmDialog(this, TM.tr("prefs.applyModif", new Object[0]), TM.tr("prefs.applyModif.title", new Object[0]), 0) == 0) {
                this.currentPanel.apply();
            }
            this.currentPanel.removeValidListener(this.validListener);
            this.remove((JComponent)((Object)this.currentPanel));
            this.currentPanel = null;
        }
        c.anchor = 18;
        c.fill = 1;
        if (p instanceof JComponent) {
            this.currentPanel = p;
            this.currentPanel.addValidListener(this.validListener);
            this.validListener.validChange(this.currentPanel, this.currentPanel.getValidState());
            this.add((Component)((JComponent)((Object)this.currentPanel)), c);
            this.revalidate();
            this.repaint();
        }
    }

    private void addToHistory(PrefTreeNode p) {
        if (!this.history.contains(p)) {
            this.history.add(p);
        }
        this.updateNavigator();
    }

    private void updateNavigator() {
        if (this.history.size() <= 1) {
            this.buttonLeft.setEnabled(false);
            this.buttonRight.setEnabled(false);
        } else {
            if (!this.currentNode.equals(this.history.firstElement())) {
                this.buttonLeft.setEnabled(true);
            } else {
                this.buttonLeft.setEnabled(false);
            }
            if (!this.currentNode.equals(this.history.lastElement())) {
                this.buttonRight.setEnabled(true);
            } else {
                this.buttonRight.setEnabled(false);
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        Object obj = e.getPath().getLastPathComponent();
        if (obj instanceof PrefTreeNode) {
            final PrefTreeNode n = (PrefTreeNode)obj;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainPrefPanel.this.setPanelFromTreeNode(n);
                }
            });
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = this.history.indexOf(this.currentNode);
        if (e.getSource() == this.buttonLeft) {
            this.selectFromHistory(--index);
        } else if (e.getSource() == this.buttonRight) {
            this.selectFromHistory(++index);
        }
    }

    private void selectFromHistory(int index) {
        if (index >= 0 && index < this.history.size() && !this.tree.select(this.history.get(index))) {
            this.setPanelFromTreeNode(this.history.get(index));
        }
    }
}

