/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.JSONToLightUIConvertor;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUILine;
import org.openconcerto.ui.light.LightUIPanel;
import org.openconcerto.utils.io.HTMLable;
import org.openconcerto.utils.io.Transferable;

public class LightUIHTMLStrippedPanel
extends LightUIPanel
implements Transferable,
HTMLable {
    public LightUIHTMLStrippedPanel(String id) {
        super(id);
        this.setType(26);
    }

    public LightUIHTMLStrippedPanel(JSONObject json) {
        super(json);
    }

    public LightUIHTMLStrippedPanel(LightUIHTMLStrippedPanel panel) {
        super(panel);
    }

    @Override
    public JSONToLightUIConvertor getConvertor() {
        return new JSONToLightUIConvertor(){

            @Override
            public LightUIElement convert(JSONObject json) {
                return new LightUIHTMLStrippedPanel(json);
            }
        };
    }

    public LightUIElement clone() {
        return new LightUIHTMLStrippedPanel(this);
    }

    @Override
    public String getHTML() {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < this.getChildrenCount()) {
            LightUILine l = this.getChild(i, LightUILine.class);
            if (l instanceof HTMLable) {
                b.append(((HTMLable)((Object)l)).getHTML());
            }
            ++i;
        }
        return b.toString();
    }

    @Override
    public void addLine(LightUILine line) {
        if (!(line instanceof HTMLable)) {
            throw new IllegalArgumentException("line must be a subclass of be HTMLable");
        }
        super.addLine(line);
    }

    @Override
    public void addChild(LightUIElement e) {
        if (!(e instanceof LightUILine)) {
            throw new IllegalArgumentException("line must be a subclass of LightUILine");
        }
        super.addLine((LightUILine)e);
    }
}

