/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.InvalidClassException;
import org.openconcerto.ui.light.JSONToLightUIConvertor;
import org.openconcerto.ui.light.LightUIContainer;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUILabel;
import org.openconcerto.ui.light.LightUIPanel;
import org.openconcerto.utils.io.JSONConverter;

public class LightUIFrame
extends LightUIContainer {
    private static final String KEY_ACTIVE = "active";
    private static final String KEY_TITLE_PANEL = "title-panel";
    private static final String KEY_FOOTER_PANEL = "footer-panel";
    private static final String KEY_CHILDREN_FRAME = "children-frame";
    private Boolean active = false;
    private LightUIPanel titlePanel = null;
    private LightUIPanel contentPanel;
    private LightUIPanel footerPanel = new LightUIPanel(String.valueOf(this.getId()) + ".footer.panel");
    private List<LightUIFrame> childrenFrame;

    public LightUIFrame(JSONObject json) {
        super(json);
    }

    public LightUIFrame(LightUIFrame frame) {
        super(frame);
        this.active = frame.active;
        this.titlePanel = frame.titlePanel;
        this.childrenFrame = frame.childrenFrame;
        this.contentPanel = frame.contentPanel;
        this.setFooterPanel(frame.footerPanel);
    }

    public LightUIFrame(String id) {
        super(id);
        this.setType(13);
        this.childrenFrame = new ArrayList<LightUIFrame>();
        this.contentPanel = new LightUIPanel(String.valueOf(this.getId()) + ".main.panel");
        this.addChild(this.contentPanel);
        this.footerPanel.setParent(this);
        this.footerPanel.setFillHeight(false);
        this.footerPanel.setHeight(50);
        this.createTitlePanel();
    }

    public LightUIPanel getContentPanel() {
        return this.contentPanel;
    }

    public void setContentPanel(LightUIPanel contentPanel) {
        this.contentPanel = contentPanel;
        this.addChild(contentPanel);
    }

    public LightUIPanel createTitlePanel(String title) {
        this.createTitlePanel();
        LightUILabel titleLabel = new LightUILabel(String.valueOf(this.titlePanel.getId()) + ".label", title, true);
        titleLabel.setVerticalAlignement(1);
        this.titlePanel.getLastLine().addChild(titleLabel);
        return this.titlePanel;
    }

    public LightUIPanel createTitlePanel() {
        this.titlePanel = new LightUIPanel(String.valueOf(this.getId()) + ".title.panel");
        this.titlePanel.setFillHeight(false);
        this.titlePanel.setHeight(50);
        return this.titlePanel;
    }

    public LightUIPanel getTitlePanel() {
        return this.titlePanel;
    }

    public void setTitlePanel(LightUIPanel titlePanel) {
        titlePanel.setId(String.valueOf(this.getId()) + ".title.panel");
        this.titlePanel = titlePanel;
    }

    public LightUIPanel getFooterPanel() {
        return this.footerPanel;
    }

    public void setFooterPanel(LightUIPanel footerPanel) {
        footerPanel.setId(String.valueOf(this.getId()) + ".footer.panel");
        this.footerPanel = footerPanel;
        this.footerPanel.setFillHeight(false);
        this.footerPanel.setParent(this);
        this.footerPanel.setHeight(50);
    }

    public void updateFooterPanel(LightUIPanel footerPanel) {
        if (footerPanel != null) {
            this.footerPanel.copy(footerPanel);
        } else {
            this.footerPanel.clear();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getPanelId() {
        return String.valueOf(this.getId()) + ".main.panel";
    }

    public void removeChildFrame(LightUIFrame childFrame) {
        this.childrenFrame.remove(childFrame);
    }

    public void removeChildFrame(int index) {
        this.childrenFrame.remove(index);
    }

    public void clearChildrenFrame() {
        this.childrenFrame.clear();
    }

    @Override
    public void setParent(LightUIElement parent) {
        if (!(parent instanceof LightUIFrame)) {
            throw new InvalidClassException(LightUIFrame.class.getName(), parent.getClassName(), parent.getId());
        }
        super.setParent(parent);
        ((LightUIFrame)parent).childrenFrame.add(this);
    }

    @Override
    public <T extends LightUIElement> T findChildByID(String searchParam, Class<T> childClass) {
        T result = super.findChildByID(searchParam, childClass);
        if (result != null) {
            return result;
        }
        return this.footerPanel.findChildByID(searchParam, childClass);
    }

    @Override
    public <T extends LightUIElement> T findChildByUUID(String searchParam, Class<T> childClass) {
        T result = super.findChildByUUID(searchParam, childClass);
        if (result != null) {
            return result;
        }
        return this.footerPanel.findChildByUUID(searchParam, childClass);
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.footerPanel.setReadOnly(readOnly);
    }

    @Override
    public void addChild(LightUIElement child) {
        if (!(child instanceof LightUIPanel)) {
            throw new InvalidClassException(LightUIPanel.class.getName(), child.getClassName(), child.getId());
        }
        child.setId(this.getPanelId());
        this.clear();
        super.addChild(child);
    }

    @Override
    public void insertChild(int index, LightUIElement child) {
        if (!(child instanceof LightUIPanel)) {
            throw new InvalidClassException(LightUIPanel.class.getName(), child.getClassName(), child.getId());
        }
        child.setId(this.getPanelId());
        this.clear();
        super.insertChild(index, child);
    }

    @Override
    public JSONToLightUIConvertor getConvertor() {
        return new JSONToLightUIConvertor(){

            @Override
            public LightUIElement convert(JSONObject json) {
                return new LightUIFrame(json);
            }
        };
    }

    @Override
    public void dump(PrintStream out, int depth) {
        out.println("------------- LightUIFrame -------------");
        super.dump(out, 0);
        out.println("footer-panel: ");
        if (this.footerPanel != null) {
            this.footerPanel.dump(out, 0);
        } else {
            out.println("null");
        }
        out.println("--------------------------");
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        if (this.active.booleanValue()) {
            json.put(KEY_ACTIVE, true);
        }
        if (this.titlePanel != null) {
            json.put(KEY_TITLE_PANEL, this.titlePanel.toJSON());
        }
        json.put(KEY_FOOTER_PANEL, this.footerPanel.toJSON());
        return json;
    }

    @Override
    public void fromJSON(JSONObject json) {
        JSONObject jsonFooterPanel;
        super.fromJSON(json);
        this.active = JSONConverter.getParameterFromJSON(json, KEY_ACTIVE, Boolean.class, false);
        JSONObject jsonTitlePanel = JSONConverter.getParameterFromJSON(json, KEY_TITLE_PANEL, JSONObject.class);
        if (jsonTitlePanel != null) {
            this.titlePanel.fromJSON(jsonTitlePanel);
        }
        if ((jsonFooterPanel = (JSONObject)JSONConverter.getParameterFromJSON(json, KEY_FOOTER_PANEL, JSONObject.class, null)) != null) {
            this.footerPanel.fromJSON(jsonFooterPanel);
        }
        JSONArray jsonChildrenFrame = JSONConverter.getParameterFromJSON(json, KEY_CHILDREN_FRAME, JSONArray.class, null);
        this.childrenFrame = new ArrayList<LightUIFrame>();
        if (jsonChildrenFrame != null) {
            for (Object objJsonFrame : jsonChildrenFrame) {
                JSONObject jsonFrame = JSONConverter.getObjectFromJSON(objJsonFrame, JSONObject.class);
                LightUIFrame childFrame = new LightUIFrame(jsonFrame);
                this.childrenFrame.add(childFrame);
            }
        }
    }
}

