/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.InvalidClassException;
import org.openconcerto.ui.light.JSONToLightUIConvertor;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUIFileUpload;
import org.openconcerto.utils.io.JSONConverter;

public class LightUIFileUploadWithSelection
extends LightUIFileUpload {
    private static final String TABLE_ID_JSON_KEY = "table-id";
    private String tableId;

    public LightUIFileUploadWithSelection(JSONObject json) {
        super(json);
    }

    public LightUIFileUploadWithSelection(LightUIFileUploadWithSelection file) {
        super(file);
    }

    public LightUIFileUploadWithSelection(String id, String tableId, String sendFileUrl) {
        super(id, sendFileUrl);
        this.setType(15);
        this.setGridWidth(1);
        this.tableId = tableId;
    }

    @Override
    public JSONToLightUIConvertor getConvertor() {
        return new JSONToLightUIConvertor(){

            @Override
            public LightUIElement convert(JSONObject json) {
                return new LightUIFileUploadWithSelection(json);
            }
        };
    }

    public LightUIElement clone() {
        return new LightUIFileUploadWithSelection(this);
    }

    @Override
    protected void copy(LightUIElement element) {
        super.copy(element);
        if (!(element instanceof LightUIFileUploadWithSelection)) {
            throw new InvalidClassException(this.getClassName(), element.getClassName(), element.getId());
        }
        LightUIFileUploadWithSelection files = (LightUIFileUploadWithSelection)element;
        this.tableId = files.tableId;
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        this.tableId = JSONConverter.getParameterFromJSON(json, TABLE_ID_JSON_KEY, String.class);
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        json.put(TABLE_ID_JSON_KEY, this.tableId);
        return json;
    }
}

