/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.JSONToLightUIConvertor;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUserControl;
import org.openconcerto.utils.io.JSONConverter;

public class LightUIDate
extends LightUserControl {
    public LightUIDate(JSONObject json) {
        super(json);
    }

    public LightUIDate(String id) {
        super(id);
        this.setType(2);
        this.setValueType(2);
    }

    public LightUIDate(LightUIDate date) {
        super(date);
    }

    public Timestamp getValueAsDate() {
        if (this.getValue() != null && !this.getValue().isEmpty()) {
            SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S");
            try {
                return new Timestamp(df2.parse(this.getValue()).getTime());
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException(ex.getMessage(), ex);
            }
        }
        return null;
    }

    @Override
    public JSONToLightUIConvertor getConvertor() {
        return new JSONToLightUIConvertor(){

            @Override
            public LightUIElement convert(JSONObject json) {
                return new LightUIDate(json);
            }
        };
    }

    @Override
    public Object getValueForContext() {
        return this.getValueAsDate();
    }

    @Override
    public void _setValueFromContext(Object value) {
        String strValue = JSONConverter.getObjectFromJSON(value, String.class);
        this.setValue(strValue);
    }
}

