/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.InvalidClassException;
import org.openconcerto.ui.light.JSONToLightUIConvertor;
import org.openconcerto.ui.light.LightUIComboBoxElement;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUserControl;
import org.openconcerto.utils.i18n.TranslationManager;
import org.openconcerto.utils.io.JSONConverter;

public class LightUIComboBox
extends LightUserControl {
    private static final String KEY_HAS_NOT_SPECIFIED_LINE = "has-not-specified-line";
    private static final String KEY_VALUES = "values";
    private static final String KEY_SELECTED_VALUE = "selected-value";
    private static final String KEY_ALREADY_FILLED = "already-filled";
    private boolean alreadyFilled = false;
    private boolean hasNotSpecifedLine = false;
    private LightUIComboBoxElement selectedValue = null;
    private List<LightUIComboBoxElement> values = new ArrayList<LightUIComboBoxElement>();

    public LightUIComboBox(JSONObject json) {
        super(json);
    }

    public LightUIComboBox(LightUIComboBox combo) {
        super(combo);
    }

    public LightUIComboBox(String id) {
        super(id);
        this.setType(3);
    }

    public void addValue(LightUIComboBoxElement values) {
        this.values.add(values);
    }

    public void addValues(List<LightUIComboBoxElement> values) {
        this.values.addAll(values);
    }

    public static LightUIComboBoxElement getDefaultValue() {
        String defaultLabelKey = "not.specified.label";
        String defaultLabel = TranslationManager.getInstance().getTranslationForItem("not.specified.label");
        LightUIComboBoxElement defaultElement = new LightUIComboBoxElement(0);
        if (defaultLabel != null) {
            defaultElement.setValue1(defaultLabel);
        } else {
            defaultElement.setValue1("not.specified.label");
        }
        return defaultElement;
    }

    public List<LightUIComboBoxElement> getValues() {
        return this.values;
    }

    public boolean hasSelectedValue() {
        return this.selectedValue != null && (this.hasNotSpecifedLine && this.selectedValue.getId() != 0 || !this.hasNotSpecifedLine);
    }

    public LightUIComboBoxElement getSelectedValue() {
        return this.selectedValue;
    }

    public void setSelectedValue(LightUIComboBoxElement selectedValue) {
        this.selectedValue = selectedValue;
    }

    public void clearValues() {
        this.selectedValue = null;
        this.values.clear();
    }

    public void setAlreadyFilled(boolean alreadyFilled) {
        this.alreadyFilled = alreadyFilled;
    }

    public boolean isAlreadyFilled() {
        return this.alreadyFilled;
    }

    public void setHasNotSpecifedLine(boolean hasNotSpecifedLine) {
        this.hasNotSpecifedLine = hasNotSpecifedLine;
    }

    public boolean hasNotSpecifedLine() {
        return this.hasNotSpecifedLine;
    }

    public void setSelectedId(Integer id) {
        if (id == null) {
            this.setSelectedValue(null);
        } else {
            for (LightUIComboBoxElement value : this.values) {
                if (value.getId() != id.intValue()) continue;
                this.setSelectedValue(value);
                break;
            }
        }
    }

    @Override
    protected void copy(LightUIElement element) {
        super.copy(element);
        if (!(element instanceof LightUIComboBox)) {
            throw new InvalidClassException(this.getClassName(), element.getClassName(), element.getId());
        }
        LightUIComboBox combo = (LightUIComboBox)element;
        this.alreadyFilled = combo.alreadyFilled;
        this.values = combo.values;
        this.selectedValue = combo.selectedValue;
    }

    @Override
    public JSONToLightUIConvertor getConvertor() {
        return new JSONToLightUIConvertor(){

            @Override
            public LightUIElement convert(JSONObject json) {
                return new LightUIComboBox(json);
            }
        };
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        if (this.values != null && !this.values.isEmpty()) {
            JSONArray jsonValues = new JSONArray();
            for (LightUIComboBoxElement value : this.values) {
                jsonValues.add(value.toJSON());
            }
            json.put(KEY_VALUES, jsonValues);
        }
        if (this.alreadyFilled) {
            json.put(KEY_ALREADY_FILLED, true);
        }
        if (this.hasNotSpecifedLine) {
            json.put(KEY_HAS_NOT_SPECIFIED_LINE, true);
        }
        if (this.selectedValue != null) {
            json.put(KEY_SELECTED_VALUE, this.selectedValue.toJSON());
        }
        return json;
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        this.alreadyFilled = JSONConverter.getParameterFromJSON(json, KEY_ALREADY_FILLED, Boolean.class, false);
        this.hasNotSpecifedLine = JSONConverter.getParameterFromJSON(json, KEY_HAS_NOT_SPECIFIED_LINE, Boolean.class, false);
        JSONObject jsonSelectedValue = JSONConverter.getParameterFromJSON(json, "", JSONObject.class);
        if (jsonSelectedValue != null) {
            this.selectedValue = new LightUIComboBoxElement(jsonSelectedValue);
        }
        JSONArray jsonValues = JSONConverter.getParameterFromJSON(json, KEY_VALUES, JSONArray.class);
        this.values = new ArrayList<LightUIComboBoxElement>();
        if (jsonValues != null) {
            for (Object jsonValue : jsonValues) {
                this.values.add(new LightUIComboBoxElement(JSONConverter.getObjectFromJSON(jsonValue, JSONObject.class)));
            }
        }
    }

    @Override
    public Object getValueForContext() {
        if (this.hasSelectedValue()) {
            return this.getSelectedValue();
        }
        return null;
    }

    @Override
    public void _setValueFromContext(Object value) {
        if (value != null) {
            JSONObject jsonSelectedValue = JSONConverter.getObjectFromJSON(value, JSONObject.class);
            this.selectedValue = new LightUIComboBoxElement(jsonSelectedValue);
        } else {
            this.selectedValue = null;
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.clearValues();
    }
}

