/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.date;

import java.applet.Applet;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.DisplayabilityListener;
import org.openconcerto.ui.PositiveIntegerTableCellEditor;
import org.openconcerto.ui.date.DateRange;
import org.openconcerto.ui.date.DateRangeTableModel;
import org.openconcerto.ui.table.FocusAwareEditor;
import org.openconcerto.ui.table.TimestampTableCellEditor;
import org.openconcerto.utils.StringUtils;

public class DateRangeTable
extends JPanel {
    private static final List<JTable> FOCUS_TABLES = new ArrayList<JTable>();
    private static final PropertyChangeListener FOCUS_LISTENER = new PropertyChangeListener(){

        /*
         * Unable to fully structure code
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            c = ((KeyboardFocusManager)evt.getSource()).getPermanentFocusOwner();
            if (c == null) {
                return;
            }
            rootOfNewFocusOwner = SwingUtilities.getRoot(c);
            block0: for (JTable t : DateRangeTable.access$0()) {
                rootOfTable = SwingUtilities.getRoot(t);
                if (rootOfNewFocusOwner == rootOfTable) ** GOTO lbl17
                this.stopTableCellEditing(t);
                continue;
lbl-1000:
                // 1 sources

                {
                    if (c == t) {
                        return;
                    }
                    if (c instanceof Window || c instanceof Applet && c.getParent() == null) {
                        if (c != rootOfTable) continue block0;
                        this.stopTableCellEditing(t);
                        continue block0;
                    }
                    c = c.getParent();
lbl17:
                    // 2 sources

                    ** while (c != null)
                }
lbl18:
                // 1 sources

            }
        }

        public void stopTableCellEditing(JTable t) {
            if (t.getCellEditor() != null && !(t.getCellEditor() instanceof FocusAwareEditor) && !t.getCellEditor().stopCellEditing()) {
                t.getCellEditor().cancelCellEditing();
            }
        }
    };
    private static final DisplayabilityListener DISP_FOCUS_LISTENER = new DisplayabilityListener(){

        @Override
        protected void displayabilityChanged(Component c) {
            String propertyName = "permanentFocusOwner";
            if (c.isDisplayable()) {
                boolean wasEmpty = FOCUS_TABLES.isEmpty();
                FOCUS_TABLES.add((JTable)c);
                if (wasEmpty) {
                    KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                    focusManager.addPropertyChangeListener("permanentFocusOwner", FOCUS_LISTENER);
                }
            } else {
                FOCUS_TABLES.remove(c);
                if (FOCUS_TABLES.isEmpty()) {
                    KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                    focusManager.removePropertyChangeListener("permanentFocusOwner", FOCUS_LISTENER);
                }
            }
        }
    };
    private static final long serialVersionUID = 351767837995219468L;
    public JButton bAdd = new JButton("Ajouter une plage horaire");
    public JButton bRemove = new JButton("Supprimer");
    public JTable rangeTable;
    final DateFormat dateTimeInstance = DateFormat.getDateTimeInstance(0, 3);
    final DateFormat timeInstance = DateFormat.getTimeInstance(3);
    private boolean nonEmpty;

    public static final void fixEditorFocus(JTable t) {
        t.addHierarchyListener(DISP_FOCUS_LISTENER);
    }

    public DateRangeTable(boolean nonEmpty, boolean withDesc) {
        this(nonEmpty, withDesc, true);
    }

    public DateRangeTable(final boolean nonEmpty, boolean withDesc, boolean allowNull) {
        this.nonEmpty = nonEmpty;
        final DateRangeTableModel model = new DateRangeTableModel(withDesc);
        this.rangeTable = new JTable(model){

            @Override
            public void changeSelection(int row, int column, boolean toggle, boolean extend) {
                super.changeSelection(row, column, toggle, extend);
                this.editCellAt(row, column);
                this.transferFocus();
            }
        };
        this.rangeTable.setRowHeight((int)((double)new JLabel((String)"A").getPreferredSize().height * 1.8));
        DateRangeTable.fixEditorFocus(this.rangeTable);
        TableColumn columnStart = this.rangeTable.getColumnModel().getColumn(0);
        columnStart.setIdentifier("start");
        columnStart.setCellRenderer(new DefaultTableCellRenderer(){
            private static final long serialVersionUID = -5791552871303767817L;

            @Override
            protected void setValue(Object value) {
                if (value != null && value instanceof Date) {
                    super.setValue(" " + StringUtils.firstUp(DateRangeTable.this.dateTimeInstance.format(value)));
                } else {
                    super.setValue(value);
                }
            }
        });
        TimestampTableCellEditor cellEditor = new TimestampTableCellEditor();
        cellEditor.setAllowNull(allowNull);
        columnStart.setCellEditor(cellEditor);
        TableColumn columnEnd = this.rangeTable.getColumnModel().getColumn(1);
        columnEnd.setCellRenderer(new DefaultTableCellRenderer(){
            private static final long serialVersionUID = -4281193780380371423L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value != null && value instanceof Date) {
                    Date endDate = (Date)value;
                    Calendar cEnd = Calendar.getInstance();
                    cEnd.setTime(endDate);
                    int col = table.getColumn("start").getModelIndex();
                    Object startDate = table.getValueAt(row, col);
                    if (startDate != null) {
                        Calendar cStart = Calendar.getInstance();
                        cStart.setTime((Date)startDate);
                        if (cStart.get(1) == cEnd.get(1) && cStart.get(6) == cEnd.get(6)) {
                            Calendar c = Calendar.getInstance();
                            c.clear();
                            c.add(12, cEnd.get(11) * 60 + cEnd.get(12));
                            c.add(12, -(cStart.get(11) * 60 + cStart.get(12)));
                            String m = String.valueOf(c.get(12));
                            if (m.length() < 2) {
                                m = "0" + m;
                            }
                            value = " " + DateRangeTable.this.timeInstance.format(value) + " (dur\u00e9e :" + c.get(11) + ":" + m + ")";
                        } else {
                            value = " " + StringUtils.firstUp(DateRangeTable.this.dateTimeInstance.format(value));
                        }
                    } else {
                        value = " " + StringUtils.firstUp(DateRangeTable.this.dateTimeInstance.format(value));
                    }
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        columnEnd.setCellEditor(cellEditor);
        TableColumn columnDuration = this.rangeTable.getColumnModel().getColumn(2);
        columnDuration.setCellEditor(new PositiveIntegerTableCellEditor(true));
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 0;
        this.add((Component)this.bAdd, c);
        ++c.gridx;
        this.bRemove.setEnabled(false);
        this.add((Component)this.bRemove, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        if (nonEmpty) {
            model.addNewLine();
        }
        this.add((Component)new JScrollPane(this.rangeTable), c);
        this.bAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                model.addNewLine();
            }
        });
        this.bRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selection = DateRangeTable.this.rangeTable.getSelectedRows();
                model.remove(selection);
            }
        });
        this.rangeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (DateRangeTable.this.rangeTable.getSelectedRowCount() > 0) {
                    DateRangeTable.this.bRemove.setEnabled(!nonEmpty || nonEmpty && DateRangeTable.this.rangeTable.getRowCount() > 1);
                } else {
                    DateRangeTable.this.bRemove.setEnabled(false);
                }
            }
        });
    }

    public void fillFrom(List<DateRange> list) {
        assert (SwingUtilities.isEventDispatchThread());
        this.getDateRangeTableModel().fillFrom(list);
        if (list.isEmpty() && this.nonEmpty) {
            this.getDateRangeTableModel().addNewLine();
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                JFrame f = new JFrame();
                f.setContentPane(new DateRangeTable(true, false));
                f.setSize(400, 300);
                f.setDefaultCloseOperation(3);
                f.setVisible(true);
            }
        });
    }

    private static void enableFocusLogging() {
        Logger focusLog = Logger.getLogger("java.awt.focus.Component");
        focusLog.setLevel(Level.ALL);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.ALL);
        focusLog.addHandler(handler);
    }

    public void clear() {
        this.fillFrom(Collections.EMPTY_LIST);
    }

    public List<DateRange> getRanges() {
        ArrayList<DateRange> result = new ArrayList<DateRange>();
        DateRangeTableModel model = this.getDateRangeTableModel();
        int i = 0;
        while (i < model.getRowCount()) {
            result.add(model.getRange(i));
            ++i;
        }
        return result;
    }

    private DateRangeTableModel getDateRangeTableModel() {
        return (DateRangeTableModel)this.rangeTable.getModel();
    }
}

