/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.jopencalendar.ui.DatePickerPanel;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.TimeSpinField;
import org.openconcerto.ui.TimeTextField;
import org.openconcerto.ui.table.TimestampTableCellEditor;

public class TimestampEditorPanel
extends JPanel
implements ActionListener {
    private TimeSpinField timeSpinner;
    private TimeTextField timeText;
    private JPanel panelHour;
    private DatePickerPanel pickerPanel;
    private List<ActionListener> listeners = new ArrayList<ActionListener>();
    private TimestampTableCellEditor aCellEditor;
    private Calendar calendar = Calendar.getInstance();
    private JDate dateEditor;

    public TimestampEditorPanel() {
        this(false);
    }

    public TimestampEditorPanel(boolean useSpinner) {
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 3, 0, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 13;
        c.fill = 2;
        this.panelHour = new JPanel(new GridBagLayout());
        JLabel labelHour = new JLabel("Heure ", 4);
        labelHour.setFont(labelHour.getFont().deriveFont(1));
        this.panelHour.add((Component)labelHour, c);
        ++c.gridx;
        if (useSpinner) {
            this.timeSpinner = new TimeSpinField();
            this.timeSpinner.setMinimumSize(new Dimension(this.timeSpinner.getPreferredSize()));
            this.panelHour.add((Component)this.timeSpinner, c);
        } else {
            this.timeText = new TimeTextField();
            this.timeText.grabFocus();
            this.panelHour.add((Component)this.timeText, c);
        }
        ++c.gridx;
        JButton buttonClose = new JButton(new ImageIcon(TimestampEditorPanel.class.getResource("validate_popup.png")));
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TimestampEditorPanel.this.aCellEditor != null) {
                    TimestampEditorPanel.this.aCellEditor.stopCellEditing();
                }
            }
        });
        buttonClose.setBorderPainted(false);
        buttonClose.setOpaque(false);
        buttonClose.setFocusPainted(false);
        buttonClose.setContentAreaFilled(false);
        buttonClose.setMargin(new Insets(1, 1, 1, 1));
        buttonClose.setFocusable(false);
        c.gridx = 0;
        this.panelHour.setOpaque(false);
        ++c.gridy;
        this.panelHour.add((Component)new JLabelBold("Date "), c);
        ++c.gridx;
        c.gridwidth = 2;
        this.dateEditor = new JDate(true, true);
        this.dateEditor.getTextComp().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                final JTextComponent textComp = TimestampEditorPanel.this.dateEditor.getTextComp();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        textComp.selectAll();
                    }
                });
            }
        });
        this.dateEditor.setButtonVisible(false);
        this.dateEditor.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Calendar c = Calendar.getInstance();
                c.setTimeInMillis(TimestampEditorPanel.this.dateEditor.getDate().getTime());
                TimestampEditorPanel.this.pickerPanel.setSelectedDate(c);
                TimestampEditorPanel.this.calendar.set(1, c.get(1));
                TimestampEditorPanel.this.calendar.set(2, c.get(2));
                TimestampEditorPanel.this.calendar.set(5, c.get(5));
                TimestampEditorPanel.this.dateOrTimeChanged();
            }
        });
        this.panelHour.add((Component)this.dateEditor, c);
        c.gridwidth = 1;
        this.add((Component)this.panelHour, c);
        c.fill = 0;
        c.anchor = 12;
        c.weightx = 1.0;
        ++c.gridx;
        this.add((Component)buttonClose, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        c.insets = new Insets(4, 0, 0, 0);
        c.fill = 2;
        this.add((Component)new JSeparator(0), c);
        this.setBackground(Color.WHITE);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.fill = 1;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        this.pickerPanel = new DatePickerPanel();
        this.pickerPanel.setFocusable(false);
        this.add((Component)this.pickerPanel, c);
        ++c.gridy;
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.pickerPanel.addPropertyChangeListener("timeInMillis", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TimestampEditorPanel.this.dateOrTimeChanged();
            }
        });
        if (useSpinner) {
            this.timeSpinner.addPropertyChangeListener("value", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    TimestampEditorPanel.this.dateOrTimeChanged();
                }
            });
        } else {
            this.timeText.addPropertyChangeListener("value", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    TimestampEditorPanel.this.dateOrTimeChanged();
                }
            });
            this.timeText.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if ((e.getKeyCode() == 9 || e.getKeyCode() == 10) && TimestampEditorPanel.this.aCellEditor != null) {
                        TimestampEditorPanel.this.aCellEditor.stopCellEditing();
                    }
                }
            });
        }
    }

    public void setTime(Date time) {
        this.calendar.setTimeInMillis(time.getTime());
        int hour = this.calendar.get(11);
        int minute = this.calendar.get(12);
        this.pickerPanel.setSelectedDate(this.calendar);
        if (this.timeSpinner != null) {
            this.timeSpinner.setTime(hour, minute);
        } else {
            this.timeText.setTime(hour, minute);
        }
    }

    public Timestamp getTime() {
        return new Timestamp(this.calendar.getTimeInMillis());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.dateOrTimeChanged();
    }

    public void dateOrTimeChanged() {
        this.stateChanged();
        this.fireTimeChangedPerformed();
    }

    public void stateChanged() {
        this.calendar.setTime(this.pickerPanel.getSelectedDate());
        this.dateEditor.setDate(this.pickerPanel.getSelectedDate());
        if (this.timeSpinner != null) {
            this.calendar.set(11, this.timeSpinner.getHours());
            this.calendar.set(12, this.timeSpinner.getMinutes());
        } else {
            this.calendar.set(11, this.timeText.getHours());
            this.calendar.set(12, this.timeText.getMinutes());
        }
    }

    private void fireTimeChangedPerformed() {
        int size = this.listeners.size();
        int i = 0;
        while (i < size) {
            ActionListener element = this.listeners.get(i);
            element.actionPerformed(null);
            ++i;
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    public void setCellEditor(TimestampTableCellEditor editor) {
        this.aCellEditor = editor;
    }

    public void setHourVisible(boolean b) {
        this.panelHour.setVisible(b);
    }

    @Override
    public void requestFocus() {
        this.timeText.requestFocus();
        this.timeText.setCaretPosition(0);
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        final TimestampEditorPanel t = new TimestampEditorPanel();
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(1, 2014);
        c.set(6, 8);
        c.set(11, 13);
        c.set(12, 14);
        t.setTime(c.getTime());
        t.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("TimestampEditorPanel got :" + t.getTime());
            }
        });
        f.setContentPane(t);
        f.pack();
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }
}

