/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.request.BaseFillSQLRequest;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.sql.view.list.UpdateRunnable;
import org.openconcerto.sql.view.list.search.SearchQueue;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.Value;
import org.openconcerto.utils.cc.ITransformer;

abstract class AbstractUpdateOneRunnable
extends UpdateRunnable {
    public AbstractUpdateOneRunnable(ITableModel model, SQLRow r) {
        super(model, r);
        if (this.getID() < 0) {
            throw new IllegalArgumentException("id is not valid : " + this.getID());
        }
    }

    protected final ListMap<Path, ListSQLLine> getAffectedPaths() {
        return this.getUpdateQ().getAffectedPaths(this.getRow());
    }

    protected final void updateLines(ListMap<Path, ListSQLLine> paths) {
        this.updateLines(paths, Value.getNone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateLines(ListMap<Path, ListSQLLine> paths, Value<ListSQLLine> line) {
        List<ListSQLLine> fullList;
        List<ListSQLLine> list = fullList = this.getUpdateQ().getFullList();
        synchronized (list) {
            this._updateLines(paths, line);
        }
    }

    private final void _updateLines(ListMap<Path, ListSQLLine> paths, Value<ListSQLLine> newLine) {
        boolean isPrimaryTable;
        boolean bl = isPrimaryTable = this.getRow().getTable() == this.getReq().getParent().getPrimaryTable();
        assert (newLine.hasValue() == isPrimaryTable);
        if (isPrimaryTable) {
            List lines = (List)paths.getNonNull(new Path(this.getRow().getTable()));
            if (lines.size() > 1) {
                throw new IllegalStateException("More than one line for " + this.getRow() + " : " + lines);
            }
            if (!newLine.hasValue()) {
                throw new IllegalArgumentException("Missing line");
            }
            ListSQLLine oldLine = this.getUpdateQ().replaceLine(this.getRow().getID(), newLine.getValue());
            assert (oldLine == CollectionUtils.getSole(lines));
        }
        for (Map.Entry e : paths.entrySet()) {
            SQLRowValues soleFetched;
            Path p = (Path)e.getKey();
            List lines = (List)e.getValue();
            if (p.length() <= 0 || lines.isEmpty()) continue;
            ListSQLRequest updateQueueReq = this.getModel().getLinesSource().getUpdateQueueReq();
            SQLRowValues proto = updateQueueReq.getGraphToFetch().followPathToOne(p, SQLRowValues.CreateMode.CREATE_NONE, false).deepCopy();
            String lastReferentField = SearchQueue.getLastReferentField(p);
            if (lastReferentField != null) {
                proto.put(lastReferentField, null);
            } else {
                proto.clearReferents();
                proto.retainAll(this.getModifedFields());
            }
            if (proto.getFields().isEmpty()) continue;
            SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(proto);
            BaseFillSQLRequest.setupForeign(fetcher);
            if (updateQueueReq.isLockSelect()) {
                fetcher.appendSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                    @Override
                    public SQLSelect transformChecked(SQLSelect input) {
                        input.addLockedTable(AbstractUpdateOneRunnable.this.getTable().getName());
                        return input;
                    }
                });
            }
            if ((soleFetched = fetcher.fetchOne(this.getRow().getIDNumber())) == null && lastReferentField == null) {
                Log.get().fine("no row fetched for " + this + ", lines have been changed without the TableModel knowing : " + lines + " req :\n" + fetcher.getReq());
                this.getModel().updateAll();
                continue;
            }
            for (ListSQLLine line : lines) {
                if (isPrimaryTable && this.getRow().getID() == line.getID()) continue;
                this.getUpdateQ().updateLine(line, p, this.getRow().getID(), soleFetched);
            }
        }
    }

    protected abstract Collection<String> getModifedFields();
}

