/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui.light;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import javax.swing.SwingUtilities;
import net.minidev.json.JSONObject;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLFunctionField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.ui.light.LightRowValuesTable;
import org.openconcerto.sql.ui.light.SearchInfo;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.light.SearchSpec;
import org.openconcerto.utils.cc.ITransformer;

public class LightRowValuesTableOnline
extends LightRowValuesTable {
    private final ITransformer<SQLSelect, SQLSelect> orginTransformer;

    public LightRowValuesTableOnline(Configuration configuration, Number userId, String id, ITableModel model) {
        super(configuration, userId, id, model);
        this.orginTransformer = ((SQLTableModelSourceOnline)model.getReq()).getReq().getSelectTransf();
    }

    public LightRowValuesTableOnline(LightRowValuesTableOnline tableElement) {
        super(tableElement);
        this.orginTransformer = tableElement.orginTransformer;
    }

    public LightRowValuesTableOnline(JSONObject json) {
        super(json);
        this.orginTransformer = null;
    }

    @Override
    public void doSearch(Configuration configuration, SearchSpec searchSpec, int offset) {
        this.getTableSpec().setSearch(searchSpec);
        this.setOffset(offset);
        final SQLTableModelSource tableSource = this.getModel().getReq();
        final SearchInfo sInfo = searchSpec != null ? new SearchInfo(searchSpec) : null;
        FutureTask<ListSQLRequest> f = new FutureTask<ListSQLRequest>(new Callable<ListSQLRequest>(){

            @Override
            public ListSQLRequest call() throws Exception {
                ListSQLRequest req = tableSource.getReq();
                final List<SQLTableModelColumn> columns = tableSource.getColumns();
                req.setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

                    @Override
                    public SQLSelect transformChecked(SQLSelect sel) {
                        if (LightRowValuesTableOnline.this.orginTransformer != null) {
                            LightRowValuesTableOnline.this.orginTransformer.transformChecked(sel);
                        }
                        LightRowValuesTableOnline.this.setWhere(sel, sInfo, columns);
                        return sel;
                    }
                });
                return req;
            }
        });
        SwingUtilities.invokeLater(f);
        try {
            ListSQLRequest req = f.get();
            long t4 = System.currentTimeMillis();
            List<SQLRowValues> rowValues = req.getValues();
            int size = rowValues.size();
            long t5 = System.currentTimeMillis();
            System.err.println("DefaultTableContentHandler.handle() getValues() :" + size + " : " + (t5 - t4) + " ms");
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private final void setWhere(SQLSelect sel, SearchInfo sInfo, List<SQLTableModelColumn> cols) {
        if (sInfo != null) {
            HashSet<SQLField> fields = new HashSet<SQLField>();
            for (SQLTableModelColumn sqlTableModelColumn : cols) {
                fields.addAll(sqlTableModelColumn.getFields());
            }
            ArrayList<Where> wheres = new ArrayList<Where>();
            ArrayList<Where> wFields = new ArrayList<Where>();
            List<String> texts = sInfo.getTexts();
            for (String string : texts) {
                wFields.clear();
                for (SQLField sqlField : fields) {
                    if (!sqlField.getType().getJavaType().equals(String.class)) continue;
                    Where w = new Where((FieldRef)new SQLFunctionField(SQLFunctionField.SQLFunction.LOWER, sel.getAlias(sqlField)), "LIKE", (Object)("%" + string.toLowerCase() + "%"));
                    wFields.add(w);
                }
                wheres.add(Where.or(wFields));
            }
            Where w = sel.getWhere() != null ? Where.and(sel.getWhere(), Where.and(wheres)) : Where.and(wheres);
            sel.setWhere(w);
            System.err.println(sel.asString());
        }
    }
}

