/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.FieldExpander;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.FilteredFillSQLRequest;

@ThreadSafe
public class ListSQLRequest
extends FilteredFillSQLRequest {
    private static final FieldExpander getExpander(FieldExpander showAs) {
        Configuration conf;
        FieldExpander res = showAs != null ? showAs : ((conf = Configuration.getInstance()) == null ? FieldExpander.getEmpty() : conf.getShowAs());
        return res;
    }

    public ListSQLRequest(SQLTable table, List<String> fieldss) {
        this(table, fieldss, null);
    }

    public ListSQLRequest(SQLTable table, List<String> fieldss, Where where) {
        this(table, fieldss, where, null);
    }

    public ListSQLRequest(SQLTable table, List<String> fieldss, Where where, FieldExpander showAs) {
        this(ListSQLRequest.computeGraph(table, fieldss, ListSQLRequest.getExpander(showAs)), where);
    }

    public ListSQLRequest(SQLRowValues graph, Where where) {
        super(graph, where);
        if (!this.getPrimaryTable().isOrdered()) {
            throw new IllegalArgumentException(this.getPrimaryTable() + " is not ordered.");
        }
    }

    protected ListSQLRequest(ListSQLRequest req, boolean freeze) {
        super(req, freeze);
    }

    @Override
    public ListSQLRequest toUnmodifiable() {
        return this.toUnmodifiableP(ListSQLRequest.class);
    }

    @Override
    protected ListSQLRequest clone(boolean forFreeze) {
        return new ListSQLRequest(this, forFreeze);
    }

    @Override
    protected final void customizeToFetch(SQLRowValues graphToFetch) {
        super.customizeToFetch(graphToFetch);
        this.addField(graphToFetch, this.getPrimaryTable().getCreationDateField());
        this.addField(graphToFetch, this.getPrimaryTable().getCreationUserField());
        this.addField(graphToFetch, this.getPrimaryTable().getModifDateField());
        this.addField(graphToFetch, this.getPrimaryTable().getModifUserField());
        this.addField(graphToFetch, this.getPrimaryTable().getFieldRaw("UI_LOCK"));
        this.addField(graphToFetch, this.getPrimaryTable().getFieldRaw("ID_USER_UI_LOCK"));
    }

    private void addField(SQLRowValues graphToFetch, SQLField f) {
        if (f != null && !graphToFetch.getFields().contains(f.getName())) {
            if (f.isKey()) {
                graphToFetch.putRowValues(f.getName()).putNulls("NOM", "PRENOM");
            } else {
                graphToFetch.put(f.getName(), null);
            }
        }
    }
}

