/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.GuardedBy;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataListener;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRequestLog;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValuesCluster;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableListenerData;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.model.graph.SQLKey;
import org.openconcerto.sql.model.graph.Step;
import org.openconcerto.sql.request.Inserter;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.utils.ReOrder;
import org.openconcerto.utils.CollectionMap2;
import org.openconcerto.utils.CollectionMap2Itf;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.CopyUtils;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.SetMap;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.cc.IdentitySet;
import org.openconcerto.utils.cc.LinkedIdentitySet;
import org.openconcerto.utils.cc.TransformedMap;
import org.openconcerto.utils.convertor.NumberConvertor;
import org.openconcerto.utils.convertor.ValueConvertor;
import org.openconcerto.utils.convertor.ValueConvertorFactory;

public final class SQLRowValues
extends SQLRowAccessor {
    public static final Object SQL_DEFAULT = new Object(){

        public String toString() {
            return String.valueOf(SQLRowValues.class.getSimpleName()) + ".SQL_DEFAULT";
        }
    };
    public static final Object SQL_EMPTY_LINK = new Object(){

        public String toString() {
            return String.valueOf(SQLRowValues.class.getSimpleName()) + ".SQL_EMPTY_LINK";
        }
    };
    @GuardedBy(value="this")
    private static ValidityCheck checkValidity;
    private static final boolean DEFAULT_ALLOW_BACKTRACK = true;
    private static final int DEFAULT_VALUES_CAPACITY = 8;
    private static final float DEFAULT_LOAD_FACTOR = 0.8f;
    private final Map<String, Object> values;
    private final Map<String, SQLRowValues> foreigns;
    private final SetMap<SQLField, SQLRowValues> referents;
    private SQLRowValuesCluster graph;
    private ListMap<SQLField, ReferentChangeListener> referentsListener;

    static {
        SQLRowValues.setValidityChecked(null);
    }

    public static synchronized void setValidityChecked(ValidityCheck vc) {
        checkValidity = vc == null ? ValidityCheck.TRUE_BY_DEFAULT : vc;
    }

    public static synchronized boolean isValidityChecked(Boolean asked) {
        return checkValidity.shouldCheck(asked);
    }

    private static final int getCapacity(int plannedSize, int defaultCapacity) {
        return plannedSize < 0 ? defaultCapacity : Math.max((int)((float)plannedSize / 0.8f) + 1, 4);
    }

    private static final LinkedHashMap<String, Object> createLinkedHashMap(int plannedSize) {
        if (plannedSize < 0) {
            throw new IllegalArgumentException("Negative capacity");
        }
        return SQLRowValues.createLinkedHashMap(plannedSize, -1);
    }

    private static final <K, V> LinkedHashMap<K, V> createLinkedHashMap(int plannedSize, int defaultCapacity) {
        return new LinkedHashMap(SQLRowValues.getCapacity(plannedSize, defaultCapacity), 0.8f);
    }

    private static final <K> SetMap<K, SQLRowValues> createSetMap(int plannedSize, int defaultCapacity) {
        return new SetMap<K, SQLRowValues>((Map)new HashMap(SQLRowValues.getCapacity(plannedSize, defaultCapacity), 0.8f), CollectionMap2.Mode.NULL_FORBIDDEN, Boolean.valueOf(false)){

            @Override
            public Set<SQLRowValues> createCollection(Collection<? extends SQLRowValues> coll) {
                return coll == null ? new LinkedIdentitySet<SQLRowValues>() : new LinkedIdentitySet<SQLRowValues>(coll);
            }
        };
    }

    public SQLRowValues(SQLTable t) {
        this(t, -1, -1, -1);
    }

    public SQLRowValues(SQLTable t, int valuesPlannedSize, int foreignsPlannedSize, int referentsPlannedSize) {
        super(t);
        this.values = SQLRowValues.createLinkedHashMap(valuesPlannedSize, 8);
        this.foreigns = SQLRowValues.createLinkedHashMap(foreignsPlannedSize, 4);
        this.referents = SQLRowValues.createSetMap(referentsPlannedSize, 4);
        this.referentsListener = null;
        this.graph = null;
    }

    public SQLRowValues(SQLTable t, Map<String, ?> values) {
        this(t, values.size(), -1, -1);
        this.setAll(values);
    }

    public SQLRowValues(SQLRowValues vals) {
        this(vals, ForeignCopyMode.COPY_ROW);
    }

    public SQLRowValues(SQLRowValues vals, ForeignCopyMode copyForeigns) {
        this(vals.getTable(), vals.getAllValues(copyForeigns));
    }

    public final SQLRowValues deepCopy() {
        return this.getGraph().deepCopy(this, false);
    }

    public final SQLRowValues toImmutable() {
        if (this.isFrozen()) {
            return this;
        }
        return this.getGraph().deepCopy(this, true);
    }

    private void updateLinks(String fieldName, Object old, Object value) {
        SQLRowValues vals;
        boolean oldRowVals = old instanceof SQLRowValues;
        boolean newRowVals = value instanceof SQLRowValues;
        if (!oldRowVals && !newRowVals) {
            return;
        }
        SQLField f = this.getTable().getField(fieldName);
        if (oldRowVals) {
            vals = (SQLRowValues)old;
            vals.referents.removeOne(f, this);
            this.foreigns.remove(fieldName);
            assert (this.graph == vals.graph);
            this.graph.remove(this, f, vals);
            vals.fireRefChange(f, false, this);
        }
        if (newRowVals) {
            vals = (SQLRowValues)value;
            vals.referents.add(f, this);
            this.foreigns.put(fieldName, vals);
            SQLRowValuesCluster usedGraph = this.graph != null && vals.graph == null ? this.graph : vals.getGraph();
            usedGraph.add(this, f, vals);
            assert (this.graph == vals.graph);
            vals.fireRefChange(f, true, this);
        }
    }

    public final SQLRowValuesCluster getGraph() {
        return this.getGraph(true);
    }

    final SQLRowValuesCluster getGraph(boolean create) {
        if (create && this.graph == null) {
            this.graph = new SQLRowValuesCluster(this);
        }
        return this.graph;
    }

    public final int getGraphSize() {
        SQLRowValuesCluster g = this.getGraph(false);
        return g == null ? 1 : g.size();
    }

    public final Set<SQLTable> getGraphTables() {
        SQLRowValuesCluster g = this.getGraph(false);
        if (g == null) {
            return Collections.singleton(this.getTable());
        }
        return g.getTables();
    }

    public final <T> void walkGraph(T acc, ITransformer<SQLRowValuesCluster.State<T>, T> closure) {
        this.getGraph().walk(this, acc, closure);
    }

    public final void walkFields(IClosure<FieldPath> closure) {
        this.walkFields(closure, false);
    }

    public final void walkFields(IClosure<FieldPath> closure, boolean includeFK) {
        this.getGraph().walkFields(this, closure, includeFK);
    }

    public final SQLRowValues prune(SQLRowValues graph) {
        return this.getGraph().prune(this, graph);
    }

    public final SQLRowValues grow(String fk) {
        Object val = this.getContainedObject(fk);
        if (val != null && !(val instanceof SQLRowValues)) {
            SQLRowValues vals = new SQLRowValues(this.getTable());
            vals.putRowValues(fk).setAllToNull();
            this.grow(vals, true);
        }
        return (SQLRowValues)this.getForeign(fk);
    }

    public final SQLRowValues grow(SQLRowValues graph) {
        return this.grow(graph, true);
    }

    public final SQLRowValues grow(SQLRowValues graph, boolean checkFields) {
        graph.getGraph().grow(graph, this, checkFields);
        return this;
    }

    public final boolean graphContains(SQLRowValues graph) {
        return this.getGraph().contains(this, graph) == null;
    }

    void setGraph(SQLRowValuesCluster g) {
        assert (g != null);
        this.graph = g;
    }

    public final boolean hasForeigns() {
        return !this.foreigns.isEmpty();
    }

    public final Map<String, SQLRowValues> getForeigns() {
        return Collections.unmodifiableMap(this.foreigns);
    }

    final int getForeignsSize() {
        return this.foreigns.size();
    }

    final Map<SQLField, SQLRowValues> getForeignsBySQLField() {
        return new TransformedMap<String, SQLField, SQLRowValues>(this.getForeigns(), new ITransformer<String, SQLField>(){

            @Override
            public SQLField transformChecked(String input) {
                return SQLRowValues.this.getTable().getField(input);
            }
        }, new ITransformer<SQLField, String>(){

            @Override
            public String transformChecked(SQLField input) {
                return input.getName();
            }
        });
    }

    final SetMap<SQLField, SQLRowValues> getReferents() {
        return this.referents;
    }

    public final CollectionMap2Itf.SetMapItf<SQLField, SQLRowValues> getReferentsMap() {
        return SetMap.unmodifiableMap(this.referents);
    }

    public final boolean hasReferents() {
        return !this.referents.isEmpty();
    }

    public Collection<SQLRowValues> getReferentRows() {
        return this.referents.createCollection(this.referents.allValues());
    }

    public Set<SQLRowValues> getReferentRows(SQLField refField) {
        return Collections.unmodifiableSet((Set)this.referents.getNonNull(refField));
    }

    public Collection<SQLRowValues> getReferentRows(SQLTable refTable) {
        Collection res = this.referents.createCollection((Collection)null);
        assert (res.isEmpty());
        for (Map.Entry e : this.referents.entrySet()) {
            if (!((SQLField)e.getKey()).getTable().equals(refTable)) continue;
            res.addAll((Collection)e.getValue());
        }
        return res;
    }

    public final SQLRowValues clearReferents() {
        return this.changeReferents(ForeignCopyMode.NO_COPY);
    }

    public final SQLRowValues changeReferents(ForeignCopyMode mode) {
        return this.changeReferents(null, false, mode);
    }

    public final SQLRowValues removeReferents(SQLField f) {
        for (SQLRowValues ref : new ArrayList(this.getReferentRows(f))) {
            ref.remove(f.getName());
        }
        return this;
    }

    public final SQLRowValues removeReferentFields(Collection<SQLField> fields) {
        return this.changeReferents(fields, false);
    }

    public final SQLRowValues retainReferentFields(Collection<SQLField> fields) {
        return this.changeReferents(fields, true);
    }

    private final SQLRowValues changeReferents(Collection<SQLField> fields, boolean retain) {
        return this.changeReferents(fields, retain, ForeignCopyMode.NO_COPY);
    }

    public final SQLRowValues changeReferents(Collection<SQLField> fields, boolean exclude, ForeignCopyMode mode) {
        if (!SQLRowValues.isEmpty(fields, exclude) && mode != ForeignCopyMode.COPY_ROW) {
            for (Map.Entry e : CopyUtils.copy(this.getReferents()).entrySet()) {
                if (fields != null && fields.contains(e.getKey()) == exclude) continue;
                for (SQLRowValues ref : (Set)e.getValue()) {
                    ref.flatten(((SQLField)e.getKey()).getName(), mode);
                }
            }
        }
        return this;
    }

    public SQLRowValues retainReferent(SQLRowValues toRetain) {
        return this.retainReferents(Collections.singleton(toRetain));
    }

    public SQLRowValues retainReferents(Collection<SQLRowValues> toRetain) {
        toRetain = CollectionUtils.toIdentitySet(toRetain);
        for (Map.Entry e : CopyUtils.copy(this.getReferents()).entrySet()) {
            for (SQLRowValues ref : (Set)e.getValue()) {
                if (toRetain.contains(ref)) continue;
                ref.remove(((SQLField)e.getKey()).getName());
            }
        }
        return this;
    }

    public int size() {
        return this.values.size();
    }

    @Override
    public final int getID() {
        Number res = this.getIDNumber(false);
        if (res != null) {
            return res.intValue();
        }
        return -1;
    }

    @Override
    public Number getIDNumber() {
        return this.getIDNumber(false);
    }

    public final Number getIDNumber(boolean mustBePresent) {
        Object res = this.getObject(this.getTable().getKey().getName(), mustBePresent);
        if (res == null) {
            return null;
        }
        return (Number)res;
    }

    @Override
    public final Object getObject(String fieldName) {
        return this.values.get(fieldName);
    }

    @Override
    public Map<String, Object> getAbsolutelyAll() {
        return this.getAllValues(ForeignCopyMode.COPY_ROW);
    }

    protected final Map<String, Object> getAllValues(ForeignCopyMode copyForeigns) {
        return this.getAllValues(copyForeigns, false);
    }

    private final Map<String, Object> getAllValues(ForeignCopyMode copyForeigns, boolean copy) {
        Map<String, Object> toAdd;
        if (copyForeigns == ForeignCopyMode.COPY_ROW || this.foreigns.size() == 0) {
            if (copy) {
                toAdd = SQLRowValues.createLinkedHashMap(this.size());
                toAdd.putAll(this.values);
            } else {
                toAdd = this.values;
            }
        } else {
            Set<Map.Entry<String, Object>> entrySet = this.values.entrySet();
            toAdd = SQLRowValues.createLinkedHashMap(entrySet.size());
            for (Map.Entry<String, Object> e : entrySet) {
                if (!(e.getValue() instanceof SQLRowValues)) {
                    toAdd.put(e.getKey(), e.getValue());
                    continue;
                }
                if (copyForeigns == ForeignCopyMode.COPY_NULL) {
                    toAdd.put(e.getKey(), null);
                    continue;
                }
                if (copyForeigns == ForeignCopyMode.NO_COPY) continue;
                SQLRowValues foreign = (SQLRowValues)e.getValue();
                if (foreign.hasID()) {
                    toAdd.put(e.getKey(), foreign.getIDNumber());
                    continue;
                }
                if (copyForeigns != ForeignCopyMode.COPY_ID_OR_ROW) continue;
                toAdd.put(e.getKey(), foreign);
            }
        }
        return copy ? toAdd : Collections.unmodifiableMap(toAdd);
    }

    public final Set<SQLTable.FieldGroup> getFieldGroups() throws IllegalStateException {
        Set<String> fields = this.getFields();
        LinkedHashSet<SQLTable.FieldGroup> set = new LinkedHashSet<SQLTable.FieldGroup>();
        Map<String, SQLTable.FieldGroup> tableGroups = this.getTable().getFieldGroups();
        for (String fieldName : fields) {
            SQLTable.FieldGroup group = tableGroups.get(fieldName);
            if (!set.add(group) || fields.containsAll(group.getFields())) continue;
            throw new IllegalStateException("Missing fields for " + group + ", current fields : " + fields);
        }
        return set;
    }

    @Override
    public final SQLRowAccessor getForeign(String fieldName) throws IllegalArgumentException, ClassCastException {
        return this.getForeign(this.getForeignLink(Collections.singletonList(fieldName)));
    }

    public final SQLRowAccessor getForeign(Link l) throws IllegalArgumentException {
        if (!((SQLTable)l.getSource()).equals(this.getTable())) {
            throw new IllegalArgumentException(l + " not from " + this);
        }
        String fieldName = l.getSingleField().getName();
        Object val = this.getContainedObject(fieldName);
        if (val instanceof SQLRowAccessor) {
            return (SQLRowAccessor)val;
        }
        if (val == null) {
            return null;
        }
        if (this.isDefault(fieldName)) {
            throw new IllegalStateException(String.valueOf(fieldName) + " is DEFAULT");
        }
        return new SQLRow((SQLTable)l.getTarget(), this.getInt(fieldName));
    }

    public boolean isDefault(String fieldName) {
        return SQL_DEFAULT.equals(this.getObject(fieldName));
    }

    @Override
    public Set<String> getFields() {
        return Collections.unmodifiableSet(this.values.keySet());
    }

    @Override
    public final SQLRow asRow() {
        if (!this.hasID()) {
            throw new IllegalStateException(this + " has no ID");
        }
        return new SQLRow(this.getTable(), this.getAllValues(ForeignCopyMode.COPY_ID_OR_RM));
    }

    @Override
    public final SQLRowValues asRowValues() {
        return this;
    }

    public final boolean isFrozen() {
        SQLRowValuesCluster g = this.getGraph(false);
        return g != null && g.isFrozen();
    }

    private void checkFrozen() {
        if (this.isFrozen()) {
            throw new IllegalStateException("Graph is not modifiable");
        }
    }

    public final SQLRowValues retainAll(Collection<String> fields) {
        return this.changeFields(fields, true);
    }

    private final SQLRowValues changeFields(Collection<String> fields, boolean retain) {
        return this.changeFields(fields, retain, false);
    }

    public final SQLRowValues changeFields(Collection<String> fields, boolean retain, boolean protectGraph) {
        if (SQLRowValues.isEmpty(fields, retain)) {
            return this;
        }
        if (!retain && fields == null && this.size() == 0) {
            return this;
        }
        HashSet<String> toRm = new HashSet<String>(this.values.keySet());
        if (protectGraph) {
            toRm.removeAll(this.foreigns.keySet());
        }
        if (fields != null) {
            if (retain) {
                toRm.removeAll(fields);
            } else {
                toRm.retainAll(fields);
            }
        }
        if (toRm.isEmpty()) {
            return this;
        }
        Map<String, SQLTable.FieldGroup> fieldGroups = this.getTable().getFieldGroups();
        for (String fieldName : toRm) {
            if (fieldGroups.get(fieldName).getKeyType() != SQLKey.Type.FOREIGN_KEY) continue;
            this._put(fieldName, null, false, ValueOperation.CHECK);
        }
        if (fields == null && !protectGraph) {
            assert (!retain && toRm.equals(this.values.keySet()));
            this.values.clear();
        } else {
            this.values.keySet().removeAll(toRm);
        }
        SQLRowValuesCluster graph = this.getGraph(false);
        if (graph != null) {
            graph.fireModification(this, toRm);
        }
        return this;
    }

    public final SQLRowValues removeAll(Collection<String> fields) {
        return this.changeFields(fields, false);
    }

    public final void remove(String field) {
        this.put(field, null);
        assert (!this.isFrozen()) : "Should already be checked by put(null)";
        this.values.remove(field);
    }

    public final void clear() {
        this.removeAll(null);
    }

    public final void clearPrimaryKeys() {
        this.checkFrozen();
        this.clearPrimaryKeys(this.values);
    }

    private Map<String, Object> clearPrimaryKeys(Map<String, Object> values) {
        return this.clearFields(values, this.getTable().getPrimaryKeys());
    }

    private Map<String, Object> clearFields(Map<String, Object> values, Set<SQLField> fields) {
        return this.changeFields(values, fields, false);
    }

    private Map<String, Object> changeFields(Map<String, Object> values, Set<SQLField> fields, boolean retain) {
        Iterator<String> iter = values.keySet().iterator();
        while (iter.hasNext()) {
            String fieldName = iter.next();
            if (!(fields.contains(this.getTable().getField(fieldName)) ^ retain)) continue;
            iter.remove();
        }
        return values;
    }

    public final SQLRowValues changeGraph(Collection<Path> paths, boolean exclude, ForeignCopyMode mode) {
        HashSet<String> foreignFields;
        HashSet<SQLField> refFields;
        if (this.getGraphSize() == 1) {
            return this;
        }
        if (paths == null) {
            refFields = null;
            foreignFields = null;
        } else {
            refFields = new HashSet<SQLField>();
            foreignFields = new HashSet<String>();
            for (Path p : paths) {
                if (p.getFirst() != this.getTable()) {
                    throw new IllegalArgumentException("Path not from this : " + p);
                }
                if (p.length() <= 0) continue;
                Step step = p.getStep(0);
                for (Link l : step.getLinks()) {
                    if (step.getDirection(l) == Link.Direction.REFERENT) {
                        refFields.addAll(l.getFields());
                        continue;
                    }
                    foreignFields.addAll(l.getCols());
                }
            }
        }
        this.changeForeigns(foreignFields, exclude, mode);
        this.changeReferents(refFields, exclude, mode);
        return this;
    }

    public final void detach() {
        this.detach(ForeignCopyMode.COPY_ID_OR_RM);
    }

    public final void detach(ForeignCopyMode mode) {
        if (mode.compareTo(ForeignCopyMode.COPY_ID_OR_ROW) >= 0) {
            throw new IllegalArgumentException("Might keep row and not detach : " + (Object)((Object)mode));
        }
        this.changeGraph(null, false, mode);
        assert (this.getGraphSize() == 1);
    }

    public SQLRowValues put(String fieldName, Object value) {
        return this.put(fieldName, value, true);
    }

    SQLRowValues put(String fieldName, Object value, boolean check) {
        return this.put(fieldName, value, check, check ? ValueOperation.CONVERT : ValueOperation.PASS);
    }

    SQLRowValues put(String fieldName, Object value, boolean checkName, ValueOperation checkValue) {
        this._put(fieldName, value, checkName, checkValue);
        SQLRowValuesCluster graph = this.getGraph(false);
        if (graph != null) {
            graph.fireModification(this, fieldName, value);
        }
        return this;
    }

    private static <T, U> U convert(Class<T> source, Object value, Class<U> dest) {
        ValueConvertor<Object, U> conv = ValueConvertorFactory.find(source, dest);
        if (conv == null) {
            throw new IllegalArgumentException("No convertor to " + dest + " from " + source);
        }
        assert (source == value.getClass());
        Object tVal = value;
        return conv.convert(tVal);
    }

    private void _put(String fieldName, Object value, boolean checkName, ValueOperation checkValue) {
        if (checkName && !this.getTable().contains(fieldName)) {
            throw new IllegalArgumentException(String.valueOf(fieldName) + " is not in table " + this.getTable());
        }
        if (value == SQL_EMPTY_LINK) {
            value = this.getForeignTable(fieldName).getUndefinedIDNumber();
        } else if (value != null && value != SQL_DEFAULT && checkValue != ValueOperation.PASS) {
            SQLField field = this.getTable().getField(fieldName);
            if (value instanceof SQLRowValues) {
                if (!field.isForeignKey()) {
                    throw new IllegalArgumentException("Since value is a SQLRowValues, expected a foreign key but got " + field);
                }
            } else {
                Class<?> javaType = field.getType().getJavaType();
                if (!javaType.isInstance(value)) {
                    if (checkValue == ValueOperation.CONVERT) {
                        value = SQLRowValues.convert(value.getClass(), value, javaType);
                    } else {
                        throw new IllegalArgumentException("Wrong type for " + fieldName + ", expected " + javaType + " but got " + value.getClass());
                    }
                }
            }
        }
        this.checkFrozen();
        this.updateLinks(fieldName, this.values.put(fieldName, value), value);
    }

    public SQLRowValues put(String fieldName, int value) {
        return this.put(fieldName, (Object)value);
    }

    public SQLRowValues putDefault(String fieldName) {
        return this.put(fieldName, SQL_DEFAULT);
    }

    public SQLRowValues putEmptyLink(String fieldName) {
        return this.put(fieldName, SQL_EMPTY_LINK);
    }

    public final SQLRowValues putRowValues(String fieldName) throws IllegalArgumentException {
        SQLRowValues vals = new SQLRowValues(this.getForeignTable(fieldName));
        this.put(fieldName, (Object)vals);
        return vals;
    }

    public final SQLRowValues putRowValues(Path p, boolean createPath) throws IllegalArgumentException {
        return this.put(p, createPath, null);
    }

    public final SQLRowValues put(Path p, boolean createPath, SQLRowValues vals) throws IllegalArgumentException {
        if (p.length() == 0) {
            throw new IllegalArgumentException("Empty path");
        }
        if (!p.isSingleLink()) {
            throw new IllegalArgumentException("Multi-link path " + p);
        }
        SQLRowValues beforeLast = createPath ? this.createPathToOne(p.minusLast()) : this.assurePath(p.minusLast());
        return beforeLast.put(p.getStep(-1), vals);
    }

    public final SQLRowValues putRowValues(Step step) throws IllegalArgumentException {
        return this.put(step, null);
    }

    public final SQLRowValues put(Step step, SQLRowValues vals) throws IllegalArgumentException {
        if (!step.getFrom().equals(this.getTable())) {
            throw new IllegalArgumentException(step + " not from " + this);
        }
        if (vals == null) {
            vals = new SQLRowValues(step.getTo());
        } else if (!step.getTo().equals(vals.getTable())) {
            throw new IllegalArgumentException(step + " not to " + vals);
        }
        for (Link l : step.getLinks()) {
            Link.Direction dir = step.getDirection(l);
            if (dir == Link.Direction.REFERENT) {
                vals._putForeign(l, this);
                continue;
            }
            assert (dir == Link.Direction.FOREIGN);
            this._putForeign(l, vals);
        }
        return vals;
    }

    private final SQLRowValues _putForeign(Link l, SQLRowValues vals) {
        this.put(l.getSingleField().getName(), (Object)vals);
        return vals;
    }

    public final SQLRowValues putForeign(Link l, SQLRowValues vals) throws IllegalArgumentException {
        if (!((SQLTable)l.getSource()).equals(this.getTable())) {
            throw new IllegalArgumentException(l + " not from " + this);
        }
        return this._putForeign(l, vals);
    }

    public final void remove(Step step) {
        for (Link l : step.getLinks()) {
            if (step.getDirection(l) == Link.Direction.FOREIGN) {
                this.removeForeignKey(l);
                continue;
            }
            this.removeReferentFields(l.getFields());
        }
    }

    public final SQLRowValues putForeignID(String fk, SQLRowAccessor r) throws IllegalArgumentException {
        return this.putForeignKey(Collections.singletonList(fk), r);
    }

    public final SQLRowValues putForeignKey(List<String> cols, SQLRowAccessor r) throws IllegalArgumentException {
        return this.putForeignKey(this.getForeignLink(cols), r);
    }

    public final SQLRowValues putForeignKey(Link foreignLink, SQLRowAccessor r) throws IllegalArgumentException {
        this.checkForeignLink(foreignLink);
        List<String> cols = foreignLink.getCols();
        if (r == null) {
            if (cols.size() == 1) {
                return this.putEmptyLink(cols.get(0));
            }
            return this.putNulls(cols);
        }
        this.checkSameTable(r, (SQLTable)foreignLink.getTarget());
        Iterator<String> iter = cols.iterator();
        Iterator<String> refIter = foreignLink.getRefCols().iterator();
        while (iter.hasNext()) {
            String col = iter.next();
            String refCol = refIter.next();
            this.put(col, r.getObject(refCol));
        }
        return this;
    }

    private void checkForeignLink(Link foreignLink) {
        if (foreignLink.getSource() != this.getTable()) {
            throw new IllegalArgumentException("Link not from " + this.getTable() + " : " + foreignLink);
        }
    }

    public final void removeForeignKey(Link foreignLink) {
        this.checkForeignLink(foreignLink);
        this.removeAll(foreignLink.getCols());
    }

    private void checkSameTable(SQLRowAccessor r, SQLTable t) {
        if (r.getTable() != t) {
            throw new IllegalArgumentException("Table mismatch : " + r.getTable().getSQLName() + " != " + t.getSQLName());
        }
    }

    public SQLRowValues setOrder(SQLRow r, boolean after) {
        return this.setOrder(r, after, ReOrder.DISTANCE.movePointRight(2).intValue(), 0);
    }

    private SQLRowValues setOrder(SQLRow r, boolean after, int nbToReOrder, int nbReOrdered) {
        BigDecimal freeOrder = r.getOrder(after);
        String orderName = this.getTable().getOrderField().getName();
        if (freeOrder != null) {
            return this.put(orderName, freeOrder);
        }
        if (nbReOrdered > r.getTable().getRowCount()) {
            throw new IllegalStateException("cannot reorder " + r.getTable().getSQLName());
        }
        try {
            ReOrder.create(this.getTable(), r.getOrder().intValue() - nbToReOrder / 2, nbToReOrder).exec();
        }
        catch (SQLException e) {
            throw ExceptionUtils.createExn(IllegalStateException.class, "reorder failed for " + this.getTable() + " at " + r.getOrder(), e);
        }
        r.fetchValues();
        return this.setOrder(r, after, nbToReOrder * 10, nbToReOrder);
    }

    public final SQLRowValues setID(Number id) {
        return this.setID(id, false);
    }

    public final SQLRowValues setID(Number id, boolean convert) {
        SQLField key = this.getTable().getKey();
        if (convert) {
            id = NumberConvertor.convert(id, key.getType().getJavaType().asSubclass(Number.class));
        }
        return this.put(key.getName(), id);
    }

    public final SQLRowValues setPrimaryKey(SQLRowAccessor r) {
        if (r == null) {
            return this.putNulls(this.getTable().getPKsNames(), false);
        }
        this.checkSameTable(r, this.getTable());
        return this.loadAll(r.getAbsolutelyAll(), this.getTable().getPKsNames(new HashSet()), true, FillMode.OVERWRITE);
    }

    public final SQLRowValues setAll(Map<String, ?> m) {
        return this.loadAll(m, FillMode.CLEAR);
    }

    public final SQLRowValues putAll(Map<String, ?> m) {
        return this.putAll(m, null);
    }

    public final SQLRowValues putAll(Map<String, ?> m, Collection<String> keys) {
        return this.putAll(m, keys, FillMode.OVERWRITE);
    }

    final SQLRowValues putAll(Map<String, ?> m, Collection<String> keys, FillMode fillMode) {
        return this.loadAll(m, keys, false, fillMode);
    }

    private final SQLRowValues loadAll(Map<String, ?> m, FillMode fillMode) {
        return this.loadAll(m, null, false, fillMode);
    }

    private final SQLRowValues loadAll(Map<String, ?> m, Collection<String> keys, boolean required, FillMode fillMode) {
        Collection<String> keySet;
        Collection<String> collection = keySet = keys == null ? m.keySet() : keys;
        if (!this.getTable().getFieldsName().containsAll(keySet)) {
            ArrayList<String> l1 = new ArrayList<String>(keySet);
            ArrayList<String> l2 = new ArrayList<String>(this.getTable().getFieldsName());
            Collections.sort(l1);
            Collections.sort(l2);
            throw new IllegalArgumentException("fields " + l1 + " are not a subset of " + this.getTable() + " : " + l2);
        }
        LinkedHashMap toLoad = new LinkedHashMap(m);
        if (keys != null) {
            if (required && !m.keySet().containsAll(keys)) {
                throw new IllegalArgumentException("Not all are keys " + keys + " are in " + m);
            }
            toLoad.keySet().retainAll(keys);
        }
        if (fillMode == FillMode.CLEAR) {
            this.clear();
        } else if (fillMode == FillMode.DONT_OVERWRITE) {
            toLoad.keySet().removeAll(this.getFields());
        }
        for (Map.Entry e : toLoad.entrySet()) {
            this._put((String)e.getKey(), e.getValue(), false, ValueOperation.CONVERT);
        }
        SQLRowValuesCluster graph = this.getGraph(false);
        if (graph != null) {
            graph.fireModification(this, toLoad);
        }
        return this;
    }

    public final SQLRowValues putNulls(String ... fields) {
        return this.putNulls(Arrays.asList(fields));
    }

    public final SQLRowValues putNulls(Collection<String> fields) {
        return this.putNulls(fields, false);
    }

    public final SQLRowValues putNulls(Collection<String> fields, boolean ignoreInexistant) {
        return this.fill(fields, null, ignoreInexistant, false);
    }

    public final SQLRowValues fill(Collection<String> fields, Object val, boolean ignoreInexistant, boolean ignoreExisting) throws IllegalArgumentException {
        LinkedHashSet<String> tableFieldsNames = this.getTable().getFieldsName();
        LinkedHashSet<String> actualFields = fields == null ? tableFieldsNames : new LinkedHashSet<String>(fields);
        LinkedHashMap<String, Object> m = SQLRowValues.createLinkedHashMap(actualFields.size());
        for (String fn : actualFields) {
            if (fields != null && ignoreInexistant && !tableFieldsNames.contains(fn)) continue;
            m.put(fn, val);
        }
        return this.loadAll(m, ignoreExisting ? FillMode.DONT_OVERWRITE : FillMode.OVERWRITE);
    }

    public final SQLRowValues fillWith(Object val, boolean overwrite) {
        return this.fill(null, val, false, !overwrite);
    }

    public final SQLRowValues setAllToNull() {
        return this.fillWith(null, true);
    }

    public final void addReferentListener(SQLField field, ReferentChangeListener l) {
        if (this.referentsListener == null) {
            this.referentsListener = new ListMap();
        }
        this.referentsListener.add(field, l);
    }

    public final void removeReferentListener(SQLField field, ReferentChangeListener l) {
        if (this.referentsListener != null) {
            this.referentsListener.removeOne(field, l);
        }
    }

    private void fireRefChange(SQLField f, boolean put, SQLRowValues vals) {
        if (this.referentsListener != null || this.getGraph().referentFireNeeded(put)) {
            ReferentChangeEvent evt = new ReferentChangeEvent(f, put, vals);
            if (this.referentsListener != null) {
                for (ReferentChangeListener l : (List)this.referentsListener.getNonNull(f)) {
                    l.referentChange(evt);
                }
                for (ReferentChangeListener l : (List)this.referentsListener.getNonNull(null)) {
                    l.referentChange(evt);
                }
            }
            assert (this.graph != null);
            this.getGraph().fireModification(evt);
        }
    }

    public final void addValueListener(SQLRowValuesCluster.ValueChangeListener l) {
        this.getGraph().addValueListener(this, l);
    }

    public final void removeValueListener(SQLRowValuesCluster.ValueChangeListener l) {
        this.getGraph().removeValueListener(this, l);
    }

    public final Collection<SQLRowValues> followLink(Link l, Link.Direction direction) {
        return this.followPath((Path)Path.get(this.getTable()).add(l, direction), CreateMode.CREATE_NONE, false);
    }

    public final SQLRowValues assurePath(Path p) {
        return this.followPath(p, true);
    }

    public final SQLRowValues followPath(Path p) {
        return this.followPath(p, false);
    }

    private final SQLRowValues followPath(Path p, boolean create) {
        return this.followPathToOne(p, create ? CreateMode.CREATE_ONE : CreateMode.CREATE_NONE, true);
    }

    public final SQLRowValues followPathToOne(Path p, CreateMode create, boolean allowBackTrack) {
        Collection<SQLRowValues> res = this.followPath(p, create, true, allowBackTrack);
        assert (res.size() <= 1);
        return CollectionUtils.getSole(res);
    }

    public final Collection<SQLRowValues> getDistantRows(Path path) {
        return this.followPath(path, CreateMode.CREATE_NONE, false);
    }

    public final SQLRowValues createPathToOne(Path p) {
        Collection<SQLRowValues> res = this.createPath(p, true);
        assert (res.size() == 1);
        return res.iterator().next();
    }

    public final Collection<SQLRowValues> createPath(Path p, boolean createOne) {
        return this.followPath(p, createOne ? CreateMode.CREATE_ONE : CreateMode.CREATE_MANY, true, false, null);
    }

    public final Collection<SQLRowValues> followPath(Path p, CreateMode create, boolean onlyOne) {
        return this.followPath(p, create, onlyOne, true);
    }

    public final Collection<SQLRowValues> followPath(Path p, CreateMode create, boolean onlyOne, boolean allowBackTrack) throws IllegalArgumentException, IllegalStateException {
        return this.followPath(p, create, false, onlyOne, allowBackTrack ? null : new LinkedIdentitySet());
    }

    /*
     * WARNING - void declaration
     */
    private final IdentitySet<SQLRowValues> followPath(Path p, CreateMode create, boolean alwaysCreate, boolean onlyOne, IdentitySet<SQLRowValues> beenThere) {
        boolean neverCreate;
        if (p.getFirst() != this.getTable()) {
            throw new IllegalArgumentException("path " + p + " doesn't start with us " + this);
        }
        boolean bl = neverCreate = create == CreateMode.CREATE_NONE;
        if (alwaysCreate && neverCreate) {
            throw new IllegalArgumentException("If alwaysCreate, don't pass " + (Object)((Object)create));
        }
        if (alwaysCreate && beenThere != null) {
            throw new IllegalArgumentException("If alwaysCreate, existing rows are ignored so the same row can never be visited more than once");
        }
        if (p.length() > 0) {
            int newCount;
            if (onlyOne && create == CreateMode.CREATE_MANY && !p.isSingleLink()) {
                throw new IllegalStateException("more than one link with " + (Object)((Object)create) + " and onlyOne : " + p);
            }
            Step firstStep = p.getStep(0);
            Set<Link> ffs = firstStep.getLinks();
            SetMap<Link, SQLRowValues> existingRows = SQLRowValues.createSetMap(-1, 6);
            HashSet<Link> linksToCreate = neverCreate ? Collections.emptySet() : new HashSet<Link>();
            for (Link l : ffs) {
                void var15_17;
                boolean hasRef;
                SQLField ff = l.getLabel();
                if (firstStep.isForeign(l)) {
                    Object fkValue = this.getObject(ff.getName());
                    if (fkValue instanceof SQLRowValues && (beenThere == null || !beenThere.contains(fkValue))) {
                        if (alwaysCreate) {
                            throw new IllegalStateException("alwaysCreate=true but foreign link is not empty : " + l);
                        }
                        existingRows.add(l, (SQLRowValues)fkValue);
                        continue;
                    }
                    if (neverCreate) continue;
                    linksToCreate.add(l);
                    continue;
                }
                Collection referentRows = this.getReferentRows(ff);
                if (beenThere == null || beenThere.size() == 0) {
                    Collection collection = referentRows;
                } else {
                    LinkedIdentitySet linkedIdentitySet = new LinkedIdentitySet(referentRows);
                    linkedIdentitySet.removeAll(beenThere);
                }
                boolean bl2 = hasRef = var15_17.size() > 0;
                if (hasRef) {
                    existingRows.addAll(l, (Collection<SQLRowValues>)var15_17);
                }
                if (!alwaysCreate && (neverCreate || hasRef)) continue;
                linksToCreate.add(l);
            }
            assert (!alwaysCreate || linksToCreate.size() > 0);
            LinkedIdentitySet<Object> next = new LinkedIdentitySet<Object>();
            if (!alwaysCreate) {
                next.addAll(existingRows.allValues());
            }
            int existingCount = next.size();
            if (onlyOne && existingCount > 1) {
                throw new IllegalStateException("more than one row exist and onlyOne=true : " + existingRows);
            }
            if (create == CreateMode.CREATE_MANY) {
                newCount = existingCount + linksToCreate.size();
            } else if (create == CreateMode.CREATE_ONE) {
                if (linksToCreate.size() > 0 && existingCount > 1) {
                    throw new IllegalStateException("more than one row exist and " + (Object)((Object)create) + ", this step won't be between two rows : " + existingRows);
                }
                newCount = Math.max(existingCount, 1);
            } else {
                assert (neverCreate);
                newCount = existingCount;
            }
            if (onlyOne && newCount > 1) {
                throw new IllegalStateException("Will have more than one row and onlyOne=true : " + existingRows + " to create : " + linksToCreate);
            }
            for (Link l : linksToCreate) {
                SQLRowValues nextOne;
                SQLField ff = l.getLabel();
                boolean isForeign = firstStep.isForeign(l);
                if (create == CreateMode.CREATE_ONE && next.size() == 1) {
                    nextOne = (SQLRowValues)next.iterator().next();
                } else {
                    Object fkValue;
                    assert (create == CreateMode.CREATE_MANY || create == CreateMode.CREATE_ONE && next.size() == 0) : "Creating more than one, already " + next.size();
                    nextOne = new SQLRowValues(firstStep.getTo());
                    if (isForeign && (fkValue = this.getObject(ff.getName())) instanceof Number) {
                        nextOne.setID((Number)fkValue);
                    }
                    next.add(nextOne);
                }
                if (isForeign) {
                    this.put(ff.getName(), (Object)nextOne);
                    continue;
                }
                nextOne.put(ff.getName(), (Object)this);
            }
            assert (!onlyOne || next.size() <= 1);
            LinkedIdentitySet<SQLRowValues> res = new LinkedIdentitySet<SQLRowValues>();
            for (SQLRowValues sQLRowValues : next) {
                LinkedIdentitySet<SQLRowValues> newBeenThere;
                if (beenThere == null) {
                    newBeenThere = null;
                } else {
                    newBeenThere = new LinkedIdentitySet<SQLRowValues>(beenThere);
                    boolean added = newBeenThere.add(this);
                    assert (added);
                }
                res.addAll(sQLRowValues.followPath(p.minusFirst(), create, alwaysCreate, onlyOne, newBeenThere));
            }
            return res;
        }
        return CollectionUtils.createIdentitySet(this);
    }

    public final SQLRowValues changeForeigns(ForeignCopyMode mode) {
        return this.changeForeigns(null, false, mode);
    }

    private static final boolean isEmpty(Collection<?> coll, boolean exclude) {
        if (exclude) {
            return coll == null;
        }
        return coll != null && coll.isEmpty();
    }

    public final SQLRowValues changeForeigns(Collection<String> fields, boolean exclude, ForeignCopyMode mode) {
        if (!SQLRowValues.isEmpty(fields, exclude) && mode != ForeignCopyMode.COPY_ROW) {
            for (String ff : new ArrayList<String>(this.getForeigns().keySet())) {
                if (fields != null && fields.contains(ff) == exclude) continue;
                this.flatten(ff, mode);
            }
        }
        return this;
    }

    public final SQLRowValues flatten(String ff, ForeignCopyMode mode) {
        SQLRowValues foreign;
        if (mode != ForeignCopyMode.COPY_ROW && (foreign = this.foreigns.get(ff)) != null) {
            if (mode == ForeignCopyMode.COPY_NULL) {
                this.put(ff, null);
            } else if (mode == ForeignCopyMode.NO_COPY) {
                this.remove(ff);
            } else if (foreign.hasID()) {
                assert (mode == ForeignCopyMode.COPY_ID_OR_ROW || mode == ForeignCopyMode.COPY_ID_OR_RM);
                this.put(ff, foreign.getIDNumber());
            } else if (mode == ForeignCopyMode.COPY_ID_OR_RM) {
                this.remove(ff);
            } else assert (mode == ForeignCopyMode.COPY_ID_OR_ROW && !foreign.hasID());
        }
        return this;
    }

    public void loadAbsolutelyAll(SQLRow row) {
        this.setAll(row.getAbsolutelyAll());
    }

    public void load(SQLRowAccessor row, Collection<String> fieldsNames) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>(row.getAbsolutelyAll());
        if (fieldsNames != null) {
            m.keySet().retainAll(fieldsNames);
        }
        if (row instanceof SQLRowValues) {
            ((SQLRowValues)row).removeAll(m.keySet());
        }
        this.putAll(m);
    }

    public void merge(SQLRowValues v) {
        this.getGraph().merge(this, v);
    }

    void checkValidity() {
        Object[] pb = this.getInvalid();
        if (pb != null) {
            throw new IllegalStateException("can't update " + this + " : the field " + pb[0] + " points to " + pb[1]);
        }
    }

    public Object[] getInvalid() {
        HashMap<String, Link> foreignLinks = new HashMap<String, Link>();
        for (Link foreignLink : this.getTable().getForeignLinks()) {
            for (String f : foreignLink.getCols()) {
                foreignLinks.put(f, foreignLink);
            }
        }
        for (String fieldName : this.values.keySet()) {
            Link foreignLink = (Link)foreignLinks.remove(fieldName);
            if (foreignLink == null) continue;
            SQLTable foreignTable = (SQLTable)foreignLink.getTarget();
            if (foreignTable.isRowable()) {
                SQLRow pb;
                assert (foreignLink.getCols().size() == 1);
                Object fieldVal = this.getObject(fieldName);
                if (fieldVal == null || fieldVal == SQL_DEFAULT || fieldVal instanceof SQLRowValues || (pb = foreignTable.checkValidity(((Number)fieldVal).intValue())) == null) continue;
                return new Object[]{fieldName, pb};
            }
            for (String ff : foreignLink.getCols()) {
                if (this.getFields().contains(ff)) continue;
                Object[] objectArray = new Object[2];
                objectArray[0] = ff;
                return objectArray;
            }
            foreignLinks.keySet().removeAll(foreignLink.getCols());
        }
        return null;
    }

    public SQLRow insert() throws SQLException {
        return this.store(SQLRowValuesCluster.StoreMode.INSERT);
    }

    public SQLRow insertVerbatim() throws SQLException {
        return this.store(SQLRowValuesCluster.StoreMode.INSERT_VERBATIM);
    }

    public SQLRow insert(boolean insertPK, boolean insertOrder) throws SQLException {
        return this.store(new SQLRowValuesCluster.Insert(insertPK, insertOrder));
    }

    public SQLRow store(SQLRowValuesCluster.StoreMode mode) throws SQLException {
        return this.getGraph().store(mode).getStoredRow(this);
    }

    SQLTableEvent insertJustThis(boolean fetchStoredRow, Set<SQLField> autoFields) throws SQLException {
        final Map<String, Object> copy = this.clearFields(new HashMap<String, Object>(this.values), autoFields);
        try {
            Tuple2<List<String>, Number> fieldsAndID = this.getTable().getBase().getDataSource().useConnection(new ConnectionHandlerNoSetup<Tuple2<List<String>, Number>, SQLException>(){

                @Override
                public Tuple2<List<String>, Number> handle(SQLDataSource ds) throws SQLException {
                    Tuple2 pStmt = SQLRowValues.createInsertStatement(SQLRowValues.this.getTable(), copy);
                    try {
                        Number newID = SQLRowValues.insert((PreparedStatement)pStmt.get0(), SQLRowValues.this.getTable());
                        ((PreparedStatement)pStmt.get0()).close();
                        return Tuple2.create((List)pStmt.get1(), newID);
                    }
                    catch (Exception e) {
                        throw new SQLException("Unable to insert " + pStmt.get0(), e);
                    }
                }
            });
            assert (this.getTable().isRowable() == (fieldsAndID.get1() != null));
            if (this.getTable().isRowable()) {
                return new SQLTableEvent(this.getEventRow(fieldsAndID.get1().intValue(), fetchStoredRow), SQLTableEvent.Mode.ROW_ADDED, (Collection<String>)fieldsAndID.get0());
            }
            return new SQLTableEvent(this.getTable(), -1, SQLTableEvent.Mode.ROW_ADDED, (Collection<String>)fieldsAndID.get0());
        }
        catch (SQLException e) {
            throw new SQLException("unable to insert " + this + " using " + copy, e);
        }
    }

    private SQLRow getEventRow(int newID, boolean fetch) {
        SQLRow res = fetch ? new SQLRow(this.getTable(), newID).fetchValues(false) : SQLRow.createEmpty(this.getTable(), newID);
        assert (res.isFilled());
        return res;
    }

    public SQLRow update() throws SQLException {
        if (!this.hasID()) {
            throw new IllegalStateException("can't update : no ID specified, use update(int) or set ID for " + this);
        }
        return this.commit();
    }

    public SQLRow update(int id) throws SQLException {
        this.put(this.getTable().getKey().getName(), id);
        return this.commit();
    }

    SQLTableEvent updateJustThis(boolean fetchStoredRow, final int id) throws SQLException {
        if (id == this.getTable().getUndefinedID()) {
            throw new IllegalArgumentException("can't update undefined with " + this);
        }
        final Map<String, Object> updatedValues = this.clearPrimaryKeys(new HashMap<String, Object>(this.values));
        List<String> updatedCols = updatedValues.isEmpty() ? Collections.emptyList() : this.getTable().getDBSystemRoot().getDataSource().useConnection(new ConnectionHandlerNoSetup<List<String>, SQLException>(){

            @Override
            public List<String> handle(SQLDataSource ds) throws SQLException {
                Tuple2 pStmt = SQLRowValues.createUpdateStatement(SQLRowValues.this.getTable(), updatedValues, id);
                long timeMs = System.currentTimeMillis();
                long time = System.nanoTime();
                int updateCount = ((PreparedStatement)pStmt.get0()).executeUpdate();
                long afterExecute = System.nanoTime();
                SQLRequestLog.log((PreparedStatement)pStmt.get0(), "rowValues.update()", timeMs, time, afterExecute, afterExecute, afterExecute, afterExecute, System.nanoTime());
                ((PreparedStatement)pStmt.get0()).close();
                if (updateCount > 1) {
                    throw new IllegalStateException(String.valueOf(updateCount) + " rows updated with ID " + id);
                }
                return updateCount == 0 ? null : (List)pStmt.get1();
            }
        });
        return updatedCols == null ? null : new SQLTableEvent(this.getEventRow(id, fetchStoredRow), SQLTableEvent.Mode.ROW_UPDATED, updatedCols);
    }

    public SQLRow commit() throws SQLException {
        return this.store(SQLRowValuesCluster.StoreMode.COMMIT);
    }

    SQLTableEvent commitJustThis(boolean fetchStoredRow) throws SQLException {
        if (!this.hasID()) {
            return this.insertJustThis(fetchStoredRow, Collections.emptySet());
        }
        return this.updateJustThis(fetchStoredRow, this.getID());
    }

    public String toString() {
        String result = String.valueOf(this.getClass().getSimpleName()) + " on " + this.getTable() + " : {";
        result = String.valueOf(result) + CollectionUtils.join(this.values.entrySet(), ", ", new ITransformer<Map.Entry<String, ?>, String>(){

            @Override
            public String transformChecked(Map.Entry<String, ?> e) {
                SQLRowValues foreignVals;
                String className;
                String string = className = e.getValue() == null ? "" : "(" + e.getValue().getClass() + ")";
                String value = e.getValue() instanceof SQLRowValues ? ((foreignVals = (SQLRowValues)e.getValue()) == SQLRowValues.this ? "this" : (foreignVals.hasID() ? foreignVals.getIDNumber().toString() : "@" + System.identityHashCode(foreignVals))) : String.valueOf(e.getValue());
                return String.valueOf(e.getKey()) + "=" + value + className;
            }
        });
        result = String.valueOf(result) + "}";
        return result;
    }

    public final String printTree() {
        return this.getGraph().printTree(this, 16);
    }

    public final String printGraph() {
        return this.getGraph().printNodes();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SQLRowValues) {
            return this.equalsGraph((SQLRowValues)obj);
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getTable().hashCode();
        result = 31 * result + this.getFields().hashCode();
        result = 31 * result + this.getGraphSize();
        result = 31 * result + this.foreigns.keySet().hashCode();
        result = 31 * result + this.referents.keySet().hashCode();
        return result;
    }

    public final boolean equalsGraph(SQLRowValues other) {
        return this.getGraphFirstDifference(other) == null;
    }

    public final String getGraphFirstDifference(SQLRowValues other) {
        return this.getGraphFirstDifference(other, false);
    }

    public final String getGraphFirstDifference(SQLRowValues other, boolean useOrder) {
        if (this == other) {
            return null;
        }
        return this.getGraph().getFirstDifference(this, other, useOrder, useOrder, true).getFirstDifference();
    }

    public final boolean equalsJustThis(SQLRowValues o) {
        return this.equalsJustThis(o, false);
    }

    public final boolean equalsJustThis(SQLRowValues o, boolean useFieldsOrder) {
        return this.equalsJustThis(o, useFieldsOrder, true);
    }

    final boolean equalsJustThis(SQLRowValues o, boolean useFieldsOrder, boolean useForeignID) {
        return this.equalsJustThis(o, useFieldsOrder, useForeignID, true);
    }

    final boolean equalsJustThis(SQLRowValues o, boolean useFieldsOrder, boolean useForeignID, boolean usePK) {
        if (this == o) {
            return true;
        }
        if (!this.getTable().equals(o.getTable())) {
            return false;
        }
        if (useFieldsOrder ? !CompareUtils.equalsUsingIterator(this.values.keySet(), o.values.keySet()) : !this.values.keySet().equals(o.values.keySet())) {
            return false;
        }
        ForeignCopyMode copyMode = useForeignID ? ForeignCopyMode.COPY_ID_OR_RM : ForeignCopyMode.NO_COPY;
        Map<String, Object> thisVals = this.getAllValues(copyMode, !usePK);
        Map<String, Object> oVals = o.getAllValues(copyMode, !usePK);
        if (!usePK) {
            List<String> pk = this.getTable().getPKsNames();
            thisVals.keySet().removeAll(pk);
            oVals.keySet().removeAll(pk);
        }
        return thisVals.equals(oVals);
    }

    private static Tuple2<PreparedStatement, List<String>> createInsertStatement(SQLTable table, Map<String, Object> values) throws SQLException {
        Tuple2<List<String>, List<Object>> l = CollectionUtils.mapToLists(values);
        List<String> fieldsNames = l.get0();
        List<Object> vals = l.get1();
        SQLRowValues.addMetadata(fieldsNames, vals, table.getCreationUserField(), SQLRowValues.getUser());
        SQLRowValues.addMetadata(fieldsNames, vals, table.getCreationDateField(), new Timestamp(System.currentTimeMillis()));
        return SQLRowValues.createStatement(table, fieldsNames, vals, true);
    }

    private static Tuple2<PreparedStatement, List<String>> createUpdateStatement(SQLTable table, Map<String, Object> values, int id) throws SQLException {
        Tuple2<List<String>, List<Object>> l = CollectionUtils.mapToLists(values);
        List<String> fieldsNames = l.get0();
        List<Object> vals = l.get1();
        vals.add(new Integer(id));
        return SQLRowValues.createStatement(table, fieldsNames, vals, false);
    }

    private static void addMetadata(List<String> fieldsNames, List<Object> values, SQLField field, Object fieldValue) throws SQLException {
        if (field != null) {
            int index = fieldsNames.indexOf(field.getName());
            if (index < 0) {
                fieldsNames.add(0, field.getName());
                values.add(0, fieldValue);
            } else {
                values.set(index, fieldValue);
            }
        }
    }

    private static Object getUser() {
        int userID = UserManager.getUserID();
        return userID < 0 ? SQL_DEFAULT : Integer.valueOf(userID);
    }

    private static Tuple2<PreparedStatement, List<String>> createStatement(SQLTable table, List<String> fieldsNames, List<Object> values, boolean insert) throws SQLException {
        PreparedStatement pStmt;
        SQLRowValues.addMetadata(fieldsNames, values, table.getModifUserField(), SQLRowValues.getUser());
        SQLRowValues.addMetadata(fieldsNames, values, table.getModifDateField(), new Timestamp(System.currentTimeMillis()));
        String tableQuoted = table.getSQLName().quote();
        String req = String.valueOf(insert ? "INSERT INTO " : "UPDATE ") + tableQuoted + " ";
        if (insert) {
            boolean selectOrder;
            assert (fieldsNames.size() == values.size());
            int i = values.size() - 1;
            while (i >= 0) {
                if (values.get(i) == SQL_DEFAULT) {
                    fieldsNames.remove(i);
                    values.remove(i);
                }
                --i;
            }
            assert (fieldsNames.size() == values.size());
            SQLField order = table.getOrderField();
            if (order != null && !fieldsNames.contains(order.getName())) {
                fieldsNames.add(order.getName());
                selectOrder = true;
            } else {
                selectOrder = false;
            }
            if (fieldsNames.size() == 0 && table.getServer().getSQLSystem() != SQLSystem.MYSQL) {
                req = String.valueOf(req) + "DEFAULT VALUES";
            } else {
                req = String.valueOf(req) + "(" + CollectionUtils.join(fieldsNames, ", ", new ITransformer<String, String>(){

                    @Override
                    public String transformChecked(String input) {
                        return SQLBase.quoteIdentifier(input);
                    }
                }) + ")";
                String questionMarks = CollectionUtils.join(Collections.nCopies(values.size(), "?"), ", ");
                if (selectOrder) {
                    req = String.valueOf(req) + " select ";
                    req = String.valueOf(req) + questionMarks;
                    if (values.size() > 0) {
                        req = String.valueOf(req) + ", ";
                    }
                    req = String.valueOf(req) + "COALESCE(MAX(" + SQLBase.quoteIdentifier(order.getName()) + "), " + ReOrder.MIN_ORDER + ") + 1 FROM " + tableQuoted;
                } else {
                    req = String.valueOf(req) + " VALUES (";
                    req = String.valueOf(req) + questionMarks;
                    req = String.valueOf(req) + ")";
                }
            }
            pStmt = SQLRowValues.createInsertStatement(req, table);
        } else {
            assert (fieldsNames.size() == values.size() - 1);
            ArrayList<String> fieldAndValues = new ArrayList<String>(fieldsNames.size());
            ListIterator<String> iter = fieldsNames.listIterator();
            while (iter.hasNext()) {
                String fieldName = iter.next();
                SQLField field = table.getField(fieldName);
                Object value = values.get(iter.previousIndex());
                fieldAndValues.add(String.valueOf(SQLBase.quoteIdentifier(field.getName())) + "= " + SQLRowValues.getFieldValue(value));
            }
            req = String.valueOf(req) + "SET " + CollectionUtils.join(fieldAndValues, ", ");
            req = String.valueOf(req) + " WHERE " + table.getKey().getFieldRef() + "= ?";
            Connection c = table.getBase().getDataSource().getConnection();
            pStmt = c.prepareStatement(req);
        }
        int i = 0;
        for (Object value : values) {
            if (value == SQL_DEFAULT) continue;
            Object toIns = value instanceof SQLRowValues ? ((SQLRowValues)value).insert().getIDNumber() : value;
            pStmt.setObject(i + 1, toIns);
            ++i;
        }
        return Tuple2.create(pStmt, fieldsNames);
    }

    private static String getFieldValue(Object value) {
        return value == SQL_DEFAULT ? "DEFAULT" : "?";
    }

    @Override
    public SQLTableModifiedListener createTableListener(SQLDataListener l) {
        return new SQLTableListenerData<SQLRowValues>(this, l);
    }

    public static final PreparedStatement createInsertStatement(String req, SQLTable table) throws SQLException {
        boolean isPG;
        boolean rowable = table.isRowable();
        boolean bl = isPG = table.getServer().getSQLSystem() == SQLSystem.POSTGRESQL;
        if (rowable && isPG) {
            req = String.valueOf(req) + " RETURNING " + SQLBase.quoteIdentifier(table.getKey().getName());
        }
        Connection c = table.getDBSystemRoot().getDataSource().getConnection();
        int returnGenK = rowable && !isPG && c.getMetaData().supportsGetGeneratedKeys() ? 1 : 2;
        return c.prepareStatement(req, returnGenK);
    }

    public static final Number insert(PreparedStatement pStmt, SQLTable table) throws SQLException {
        Number newID;
        long timeMs = System.currentTimeMillis();
        long time = System.nanoTime();
        pStmt.execute();
        long afterExecute = System.nanoTime();
        if (table.isRowable()) {
            ResultSet rs = table.getServer().getSQLSystem() == SQLSystem.POSTGRESQL ? pStmt.getResultSet() : pStmt.getGeneratedKeys();
            try {
                if (!rs.next()) {
                    throw new IllegalStateException("no keys have been autogenerated for the successfully executed statement :" + pStmt);
                }
                newID = (Number)rs.getObject(1);
            }
            catch (SQLException exn) {
                throw new IllegalStateException("can't get autogenerated keys for the successfully executed statement :" + pStmt);
            }
        } else {
            newID = null;
        }
        long afterHandle = System.nanoTime();
        SQLRequestLog.log(pStmt, "rowValues.insert()", timeMs, time, afterExecute, afterExecute, afterExecute, afterHandle, System.nanoTime());
        return newID;
    }

    public static final List<Number> insertIDs(SQLTable t, String sql) throws SQLException {
        boolean rowable = t.isRowable();
        Inserter.Insertion<?> res = SQLRowValues.insert(t, sql, rowable ? Inserter.ReturnMode.FIRST_FIELD : Inserter.ReturnMode.NO_FIELDS);
        if (rowable) {
            return res.getRows();
        }
        return null;
    }

    public static final Inserter.Insertion<List<Object>> insert(SQLTable t, String sql) throws SQLException {
        return SQLRowValues.insert(t, sql, Inserter.ReturnMode.ALL_FIELDS);
    }

    public static final int insertCount(SQLTable t, String sql) throws SQLException {
        return SQLRowValues.insert(t, sql, Inserter.ReturnMode.NO_FIELDS).getCount();
    }

    private static final Inserter.Insertion<?> insert(SQLTable t, String sql, Inserter.ReturnMode mode) throws SQLException {
        return new Inserter(t).insert(sql, mode, true);
    }

    public static final List<SQLRow> insertRows(SQLTable t, String sql) throws SQLException {
        List<Number> ids = SQLRowValues.insertIDs(t, sql);
        if (ids == null) {
            return null;
        }
        ArrayList<SQLRow> res = new ArrayList<SQLRow>(ids.size());
        for (Number id : ids) {
            res.add(new SQLRow(t, id.intValue()));
        }
        return res;
    }

    public static final int insertFromTable(SQLTable dest, SQLTable src) throws SQLException {
        return SQLRowValues.insertFromTable(dest, src, src.getChildrenNames());
    }

    public static final int insertFromTable(SQLTable dest, SQLTable src, Set<String> fieldsNames) throws SQLException {
        if (dest.getDBSystemRoot() != src.getDBSystemRoot()) {
            throw new IllegalArgumentException("Tables are not on the same system root : " + dest.getSQLName() + " / " + src.getSQLName());
        }
        if (!dest.getChildrenNames().containsAll(fieldsNames)) {
            throw new IllegalArgumentException("Destination table " + dest.getSQLName() + " doesn't contain all fields of the source " + src + " : " + fieldsNames);
        }
        ArrayList<SQLField> fields = new ArrayList<SQLField>(fieldsNames.size());
        for (String fName : fieldsNames) {
            fields.add(src.getField(fName));
        }
        SQLSelect sel = new SQLSelect(true);
        sel.addAllSelect(fields);
        String colNames = "(" + CollectionUtils.join(fields, ",", new ITransformer<SQLField, String>(){

            @Override
            public String transformChecked(SQLField input) {
                return SQLBase.quoteIdentifier(input.getName());
            }
        }) + ") ";
        return SQLRowValues.insertCount(dest, String.valueOf(colNames) + sel.asString());
    }

    public static final List<SQLRowValues> trim(Collection<SQLRowValues> graphs) {
        ArrayList<SQLRowValues> res = new ArrayList<SQLRowValues>(graphs.size());
        for (SQLRowValues r : graphs) {
            res.add(SQLRowValues.trim(r));
        }
        return res;
    }

    public static final SQLRowValues trim(SQLRowValues r) {
        return new SQLRowValues(r, ForeignCopyMode.COPY_ID_OR_RM);
    }

    public static enum CreateMode {
        CREATE_NONE,
        CREATE_ONE,
        CREATE_MANY;

    }

    static enum FillMode {
        CLEAR,
        OVERWRITE,
        DONT_OVERWRITE;

    }

    public static enum ForeignCopyMode {
        NO_COPY,
        COPY_NULL,
        COPY_ID_OR_RM,
        COPY_ID_OR_ROW,
        COPY_ROW;

    }

    public class ReferentChangeEvent
    extends EventObject {
        private final SQLField f;
        private final SQLRowValues vals;
        private final boolean put;

        public ReferentChangeEvent(SQLField f, boolean put, SQLRowValues vals) {
            super(SQLRowValues.this);
            assert (f != null && f.getDBSystemRoot().getGraph().getForeignTable(f) == this.getSource().getTable() && f.getTable() == vals.getTable());
            this.f = f;
            this.put = put;
            this.vals = vals;
        }

        @Override
        public SQLRowValues getSource() {
            return (SQLRowValues)super.getSource();
        }

        public final SQLField getField() {
            return this.f;
        }

        public final SQLRowValues getChangedReferent() {
            return this.vals;
        }

        public final boolean isAddition() {
            return this.put;
        }

        public final boolean isRemoval() {
            return !this.isAddition();
        }

        @Override
        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + (this.isAddition() ? " added" : " removed") + " on field " + this.getField() + " from " + this.getSource().asRow() + " : " + this.getChangedReferent();
        }
    }

    public static interface ReferentChangeListener
    extends EventListener {
        public void referentChange(ReferentChangeEvent var1);
    }

    public static enum ValidityCheck {
        FORBIDDEN{

            @Override
            public boolean shouldCheck(Boolean asked) {
                return false;
            }
        }
        ,
        FALSE_BY_DEFAULT{

            @Override
            public boolean shouldCheck(Boolean asked) {
                return asked == null ? false : asked;
            }
        }
        ,
        TRUE_BY_DEFAULT{

            @Override
            public boolean shouldCheck(Boolean asked) {
                return asked == null ? true : asked;
            }
        }
        ,
        FORCED{

            @Override
            public boolean shouldCheck(Boolean asked) {
                return true;
            }
        };


        public abstract boolean shouldCheck(Boolean var1);
    }

    public static enum ValueOperation {
        CONVERT,
        CHECK,
        PASS;

    }
}

