/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.map.model;

import java.awt.Color;
import java.awt.Polygon;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openconcerto.map.model.DatabaseAccessor;
import org.openconcerto.map.model.MapPoint;
import org.openconcerto.map.model.MapPointSelection;
import org.openconcerto.map.model.Region;
import org.openconcerto.map.ui.MapViewerPanel;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.StringUtils;

public class Ville {
    private static Map<String, Ville> map = new HashMap<String, Ville>();
    private static DatabaseAccessor accessor;
    private static final List<Ville> villes;
    private static final List<String> villesNames;
    private static final List<PropertyChangeListener> listeners;
    private static Thread init;
    private static boolean loaded;
    private int nbMatch = 0;
    private final String name;
    private final String codepostal;
    private final long xLambert;
    private final long yLambert;
    long population;
    private long minimumZoom;
    private Color color = null;

    static {
        villes = new ArrayList<Ville>(39000);
        villesNames = new ArrayList<String>(39000);
        listeners = new ArrayList<PropertyChangeListener>();
        init = null;
        loaded = false;
    }

    public static synchronized void init(final DatabaseAccessor d, final boolean loadFromFile) {
        Ville.await();
        accessor = d;
        init = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<Ville> clazz = Ville.class;
                synchronized (Ville.class) {
                    if (loadFromFile) {
                        Ville.parseFile();
                    }
                    List<Ville> l = d.read();
                    for (Ville ville : l) {
                        Ville.addVilleSilently(ville);
                    }
                    init = null;
                    Ville.class.notifyAll();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
        init.setPriority(1);
        init.setName("Ville asynchronous loader");
        init.start();
    }

    private static void parseFile() {
        Ville.parseFile(null);
    }

    private static synchronized void parseFile(File mapDir) {
        if (loaded) {
            throw new IllegalStateException("Data already loaded");
        }
        long t1 = System.nanoTime();
        try {
            InputStreamReader fReader = null;
            if (mapDir != null && mapDir.exists() && mapDir.list().length > 0) {
                File[] files = mapDir.listFiles();
                int i = 0;
                while (i < files.length) {
                    File file = files[i];
                    fReader = new FileReader(file);
                    Ville.parse(fReader);
                    fReader.close();
                    ++i;
                }
            } else {
                fReader = new InputStreamReader(Ville.class.getResourceAsStream("villes.txt"), "UTF8");
                Ville.parse(fReader);
                fReader.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long t2 = System.nanoTime();
        Logger.getLogger("map").config("parseFile took " + (t2 - t1) / 1000000L + " ms");
        Collections.sort(villesNames);
        Region.parseFile();
        loaded = true;
    }

    private static void parse(InputStreamReader fReader) throws IOException {
        BufferedReader bufReader = new BufferedReader(fReader, 0x400000);
        String n = bufReader.readLine();
        while (n != null) {
            long pop = Ville.parsePositiveLong(bufReader.readLine());
            long x = Ville.parsePositiveLong(bufReader.readLine());
            long y = Ville.parsePositiveLong(bufReader.readLine());
            String cp = bufReader.readLine();
            Ville v = new Ville(n, pop, x, y, cp);
            if (v.xLambert > 0L) {
                Ville.addVilleSilently(v);
            }
            n = bufReader.readLine();
        }
        bufReader.close();
    }

    private static final void parseLine(String line) {
        List<String> strs = StringUtils.fastSplit(line, ';');
        Ville v = new Ville(strs.get(3), Ville.parsePositiveLong(strs.get(4)), Ville.parsePositiveLong(strs.get(8)), Ville.parsePositiveLong(strs.get(9)), strs.get(2));
        if (strs.size() > 10) {
            v.setMinimumZoom(Ville.parsePositiveLong(strs.get(10)));
        }
        if (v.xLambert > 0L) {
            Ville.addVilleSilently(v);
        }
    }

    private static synchronized void addVilleSilently(Ville v) {
        villes.add(v);
        String villeEtCode = v.getVilleEtCode();
        villesNames.add(villeEtCode);
        map.put(villeEtCode, v);
    }

    public static synchronized void addVille(Ville v) {
        String villeEtCode = v.getVilleEtCode();
        if (map.containsKey(villeEtCode)) {
            return;
        }
        Ville.addVilleSilently(v);
        accessor.store(v);
        Ville.fireListModified();
    }

    public static synchronized void removeVille(Ville v) {
        if (v != null) {
            villes.remove(v);
            String villeEtCode = v.getVilleEtCode();
            villesNames.remove(villeEtCode);
            map.remove(villeEtCode);
            accessor.delete(v);
            Ville.fireListModified();
        }
    }

    private static final synchronized void await() {
        if (init != null) {
            try {
                Ville.class.wait();
            }
            catch (InterruptedException e) {
                throw new RTInterruptedException(e);
            }
        }
    }

    public static synchronized List<Ville> getVilles() {
        Ville.await();
        return villes;
    }

    public static synchronized List<String> getVillesNames() {
        Ville.await();
        return villesNames;
    }

    public static synchronized Ville getVilleFromVilleEtCode(String s) {
        Ville.await();
        return map.get(s);
    }

    public static synchronized Ville getVilleContaining(String string) {
        string = string.trim().toLowerCase();
        List<Ville> l = Ville.getVilles();
        int size = l.size();
        int i = 0;
        while (i < size) {
            Ville v = l.get(i);
            if (v.getName().toLowerCase().indexOf(string) >= 0) {
                return v;
            }
            ++i;
        }
        return null;
    }

    public static synchronized List<Ville> getVillesContaining(String string) {
        string = string.trim().toLowerCase();
        ArrayList<Ville> list = new ArrayList<Ville>();
        List<Ville> l = Ville.getVilles();
        int size = l.size();
        int i = 0;
        while (i < size) {
            Ville v = l.get(i);
            if (v.getName().toLowerCase().indexOf(string) >= 0) {
                list.add(v);
            }
            ++i;
        }
        return list;
    }

    public static synchronized Ville getVilleContaining(String string, String codepostal) {
        if (codepostal.length() == 0 && string.length() <= 2) {
            return null;
        }
        List<Ville> l = Ville.getVillesFromCode(codepostal);
        if (l.size() == 0) {
            return null;
        }
        if (l.size() == 1) {
            return l.get(0);
        }
        string = string.trim().toLowerCase();
        int size = l.size();
        int i = 0;
        while (i < size) {
            Ville v = l.get(i);
            if (v.getName().toLowerCase().indexOf(string) >= 0) {
                return v;
            }
            ++i;
        }
        return null;
    }

    private static List<Ville> getVillesFromCode(String cp) {
        ArrayList<Ville> list = new ArrayList<Ville>();
        List<Ville> l = Ville.getVilles();
        int size = l.size();
        int i = 0;
        while (i < size) {
            Ville v = l.get(i);
            if (v.getCodepostal().toLowerCase().indexOf(cp) >= 0) {
                list.add(v);
            }
            ++i;
        }
        return list;
    }

    public static synchronized List<Ville> getVilleIn(MapPointSelection sel) {
        ArrayList<Ville> r = null;
        if (sel == null) {
            return null;
        }
        if (sel.size() > 2) {
            r = new ArrayList<Ville>();
            Polygon p = new Polygon();
            int i = 0;
            while (i < sel.size()) {
                MapPoint mapPoint = sel.get(i);
                long x = mapPoint.getX();
                long y = mapPoint.getY();
                p.addPoint((int)x, (int)y);
                ++i;
            }
            long minX = sel.getMinX();
            long maxX = sel.getMaxX();
            long minY = sel.getMinY();
            long maxY = sel.getMaxY();
            List<Ville> allVilles = Ville.getVilles();
            int stop = allVilles.size();
            int i2 = 0;
            while (i2 < stop) {
                long y;
                Ville v = allVilles.get(i2);
                long x = v.getXLambert();
                if (x <= maxX && x >= minX && (y = v.getYLambert()) <= maxY && y >= minY && p.contains(x, y)) {
                    r.add(v);
                }
                ++i2;
            }
        }
        return r;
    }

    public static long parsePositiveLong(String str) {
        str = str.trim();
        long value = 0L;
        int stop = str.length();
        int i = 0;
        while (i < stop) {
            char c = str.charAt(i);
            if (c == '.') break;
            value *= 10L;
            value += (long)(c - 48);
            ++i;
        }
        return value;
    }

    public static synchronized long getMinXLambert() {
        List<Ville> l = Ville.getVilles();
        if (l.size() > 0) {
            long min = l.get((int)0).xLambert;
            int i = 0;
            while (i < l.size()) {
                Ville v = l.get(i);
                if (v.xLambert < min) {
                    min = v.xLambert;
                }
                ++i;
            }
            return min;
        }
        return 0L;
    }

    static synchronized long getMaxXLambert() {
        List<Ville> l = Ville.getVilles();
        if (l.size() > 0) {
            long max = l.get((int)0).xLambert;
            int i = 0;
            while (i < l.size()) {
                Ville v = l.get(i);
                if (v.xLambert > max) {
                    max = v.xLambert;
                }
                ++i;
            }
            return max;
        }
        return 0L;
    }

    public static synchronized long getMinYLambert() {
        List<Ville> l = Ville.getVilles();
        long min = l.get((int)0).yLambert;
        int i = 0;
        while (i < l.size()) {
            Ville v = l.get(i);
            if (v.yLambert < min) {
                min = v.yLambert;
            }
            ++i;
        }
        return min;
    }

    static synchronized long getMaxYLambert() {
        List<Ville> l = Ville.getVilles();
        long max = l.get((int)0).yLambert;
        int i = 0;
        while (i < l.size()) {
            Ville v = l.get(i);
            if (v.yLambert > max) {
                max = v.yLambert;
            }
            ++i;
        }
        return max;
    }

    public String getCodepostal() {
        return this.codepostal;
    }

    public long getPopulation() {
        return this.population;
    }

    public long getXLambert() {
        return this.xLambert;
    }

    public long getYLambert() {
        return this.yLambert;
    }

    public String getName() {
        return this.name;
    }

    public String getVilleEtCode() {
        return String.valueOf(this.name) + " (" + this.codepostal + ")";
    }

    public Ville(String name, long population, long xLambert, long yLambert, String codepostal) {
        this.name = name;
        this.population = population;
        this.codepostal = codepostal;
        this.xLambert = xLambert;
        this.yLambert = yLambert;
    }

    public String toString() {
        return String.valueOf(this.name) + " (" + this.codepostal + ")";
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    private void setMinimumZoom(long l) {
        this.minimumZoom = l;
    }

    public long getMinimumZoom() {
        return this.minimumZoom;
    }

    public void setNbMatch(int nb) {
        this.nbMatch = nb;
    }

    public int getNbMatch() {
        return this.nbMatch;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            long t1 = System.nanoTime();
            Ville.parseFile();
            long t2 = System.nanoTime();
            System.out.println("Parsing: " + (t2 - t1) / 1000000L + " ms");
            System.out.println("MinXLambert:" + Ville.getMinXLambert() + ",MinYLambert" + Ville.getMinYLambert());
            System.out.println("MaxXLambert:" + Ville.getMaxXLambert() + ",MinXLambert" + Ville.getMaxYLambert());
            System.out.println("DeltaX:" + (Ville.getMaxXLambert() - Ville.getMinXLambert()));
            System.out.println("DeltaY:" + (Ville.getMaxYLambert() - Ville.getMinYLambert()));
            long t3 = System.nanoTime();
            System.out.println("Min: " + (t3 - t1) / 1000000L + " ms");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JFrame f = new JFrame();
                    f.setContentPane(new MapViewerPanel());
                    f.setDefaultCloseOperation(3);
                    f.setSize(1000, 600);
                    f.setVisible(true);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized void sortByPopulation() {
        Ville.sortByPopulation(villes);
    }

    public static synchronized void sortByPopulation(List<Ville> list) {
        Collections.sort(list, new Comparator<Ville>(){

            @Override
            public int compare(Ville v1, Ville v2) {
                return (int)(v2.getPopulation() - v1.getPopulation());
            }
        });
    }

    public static void addListener(PropertyChangeListener listener) {
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public static void removeListener(PropertyChangeListener listener) {
        listeners.remove(listener);
    }

    private static void fireListModified() {
        for (PropertyChangeListener l : listeners) {
            l.propertyChange(new PropertyChangeEvent(Ville.class, "list", null, null));
        }
    }
}

