/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.map.model;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.openconcerto.map.model.Ville;
import org.openconcerto.utils.StringUtils;

public class Extract {
    private static List<Ville> villes = new ArrayList<Ville>();

    public static void main(String[] args) {
        Extract.parseFile1();
        Extract.parseFile2();
        Extract.save();
    }

    private static void save() {
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("villes.txt"), "UTF8"));
            PrintWriter prt = new PrintWriter(out);
            int size = villes.size();
            int i = 0;
            while (i < size) {
                Ville v = villes.get(i);
                prt.println(v.getName().trim());
                prt.println(String.valueOf(v.getPopulation()));
                prt.println(String.valueOf(v.getXLambert()));
                prt.println(String.valueOf(v.getYLambert()));
                String codepostal = v.getCodepostal().trim();
                if (codepostal.length() < 5) {
                    codepostal = "0" + codepostal;
                }
                prt.println(codepostal);
                ++i;
            }
            prt.close();
            ((Writer)out).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static synchronized void parseFile1() {
        long t1 = System.nanoTime();
        try {
            InputStreamReader fReader = new InputStreamReader(Ville.class.getResourceAsStream("villes.csv"), "CP1252");
            BufferedReader bufReader = new BufferedReader(fReader, 0x400000);
            String line = bufReader.readLine();
            line = bufReader.readLine();
            while (line != null) {
                Extract.parseLine1(line);
                line = bufReader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long t2 = System.nanoTime();
        System.out.println(String.valueOf((t2 - t1) / 1000000L) + " ms");
    }

    private static synchronized void parseFile2() {
        long t1 = System.nanoTime();
        try {
            InputStreamReader fReader = new InputStreamReader(Ville.class.getResourceAsStream("population.csv"), "CP1252");
            BufferedReader bufReader = new BufferedReader(fReader, 0x400000);
            String line = bufReader.readLine();
            line = bufReader.readLine();
            while (line != null) {
                Extract.parseLine2(line);
                line = bufReader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long t2 = System.nanoTime();
        System.out.println(String.valueOf((t2 - t1) / 1000000L) + " ms");
    }

    private static final void parseLine1(String line) {
        List<String> strs = StringUtils.fastSplit(line, ';');
        Ville v = new Ville(strs.get(3), Extract.parsePositiveLong(strs.get(4)), Extract.parsePositiveLong(strs.get(8)), Extract.parsePositiveLong(strs.get(9)), strs.get(2));
        if (v.getXLambert() > 0L) {
            villes.add(v);
        }
    }

    private static final void parseLine2(String line) {
        List<String> strs = StringUtils.fastSplit(line, ';');
        System.err.println(line);
        String n = strs.get(1);
        long pop = Extract.parsePositiveLong(strs.get(2));
        int size = villes.size();
        int i = 0;
        while (i < size) {
            Ville v = villes.get(i);
            if (v.getName().equalsIgnoreCase(n)) {
                v.population = pop;
                System.out.println(String.valueOf(v.getName()) + " ok :" + pop);
                break;
            }
            ++i;
        }
    }

    public static long parsePositiveLong(String str) {
        str = str.trim();
        long value = 0L;
        int stop = str.length();
        int i = 0;
        while (i < stop) {
            char c = str.charAt(i);
            if (c == '.') break;
            value *= 10L;
            value += (long)(c - 48);
            ++i;
        }
        return value;
    }
}

